/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.model;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Action;
import org.netbeans.modules.ruby.debugger.ContextProviderWrapper;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.rubyforge.debugcommons.model.RubyThreadInfo;

public final class ThreadsModel
implements TreeModel,
TableModel,
NodeModel,
NodeActionsProvider {
    private static final String CURRENT = "org/netbeans/modules/debugger/resources/threadsView/CurrentThread";
    private static final String RUNNING = "org/netbeans/modules/debugger/resources/threadsView/RunningThread";
    private static final String SUSPENDED = "org/netbeans/modules/debugger/resources/threadsView/SuspendedThread";
    private ContextProviderWrapper contextProvider;
    private final RubySession rubySession;
    private final List<ModelListener> listeners;

    public ThreadsModel(ContextProvider contextProvider) {
        this.contextProvider = new ContextProviderWrapper(contextProvider);
        this.rubySession = this.contextProvider.getRubySession();
        this.listeners = new CopyOnWriteArrayList<ModelListener>();
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            return this.rubySession.getThreadInfos();
        }
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof RubyThreadInfo) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return this.rubySession.getThreadInfos().length;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public void fireChanges() {
        for (ModelListener listener : this.listeners) {
            listener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return NbBundle.getMessage(ThreadsModel.class, (String)"CTL_ThreadsModel.Column.Name.Name");
        }
        if (node instanceof RubyThreadInfo) {
            RubyThreadInfo ti = (RubyThreadInfo)node;
            String threadName = this.getThreadName(ti);
            return this.rubySession.isActiveThread(ti.getId()) ? "<html><b>" + threadName + "</b></html>" : threadName;
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node == "Root" || node instanceof RubyThreadInfo) {
            RubyThreadInfo ti = (RubyThreadInfo)node;
            if (this.rubySession.isActiveThread(ti.getId())) {
                return CURRENT;
            }
            if (this.rubySession.isSuspended(ti)) {
                return SUSPENDED;
            }
            return RUNNING;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return NbBundle.getMessage(ThreadsModel.class, (String)"CTL_ThreadsModel.Column.Name.Desc");
        }
        if (node instanceof RubyThreadInfo) {
            return this.getThreadName((RubyThreadInfo)node);
        }
        throw new UnknownTypeException(node);
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof RubyThreadInfo && "ThreadState".equals(columnID)) {
            return ((RubyThreadInfo)node).getStatus();
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof RubyThreadInfo && "ThreadState".equals(columnID)) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (!(node instanceof RubyThreadInfo)) {
            throw new UnknownTypeException(node);
        }
        RubyThreadInfo ti = (RubyThreadInfo)node;
        this.rubySession.switchThread(ti.getId(), this.contextProvider);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        return new Action[0];
    }

    private String getThreadName(RubyThreadInfo ti) {
        return "RubyThread - " + ti.getId();
    }
}

