/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.model;

import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Action;
import org.netbeans.modules.ruby.debugger.ContextProviderWrapper;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.rubyforge.debugcommons.model.RubyFrame;

public class CallStackModel
implements TreeModel,
NodeModel,
NodeActionsProvider,
TableModel {
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private final ContextProviderWrapper contextProvider;
    private final RubySession rubySession;
    private final List<ModelListener> listeners;

    public CallStackModel(ContextProvider contextProvider) {
        this.contextProvider = new ContextProviderWrapper(contextProvider);
        this.rubySession = this.contextProvider.getRubySession();
        this.listeners = new CopyOnWriteArrayList<ModelListener>();
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            return this.rubySession.getFrames();
        }
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof RubyFrame) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return this.rubySession.getFrames().length;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public void fireChanges() {
        for (ModelListener listener : this.listeners) {
            listener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return NbBundle.getMessage(CallStackModel.class, (String)"CTL_CallstackModel.Column.Name.Name");
        }
        if (node instanceof RubyFrame) {
            RubyFrame frame = (RubyFrame)node;
            String basename = new File(frame.getFile()).getName();
            String dn = basename + ':' + frame.getLine();
            return this.rubySession.isSelectedFrame(frame) ? "<html><b>" + dn + "</b></html>" : dn;
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof RubyFrame) {
            if (this.rubySession.isSelectedFrame((RubyFrame)node)) {
                return CURRENT_CALL_STACK;
            }
            return CALL_STACK;
        }
        if (node == "Root") {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return NbBundle.getMessage(CallStackModel.class, (String)"CTL_CallstackModel.Column.Name.Desc");
        }
        if (node instanceof RubyFrame) {
            return ((RubyFrame)node).getName();
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (!(node instanceof RubyFrame)) {
            throw new UnknownTypeException(node);
        }
        RubyFrame frame = (RubyFrame)node;
        EditorUtil.showLine(EditorUtil.getLineAnnotable(this.rubySession.resolveAbsolutePath(frame.getFile()), frame.getLine() - 1));
        this.rubySession.selectFrame(frame);
        this.fireChanges();
        this.contextProvider.getVariablesModel().fireChanges();
        this.contextProvider.getWatchesModel().fireChanges();
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        return new Action[0];
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (columnID == "CallStackFrameLocation" && node instanceof RubyFrame) {
            RubyFrame frame = (RubyFrame)node;
            return frame.getFile();
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (columnID == "CallStackFrameLocation" && node instanceof RubyFrame) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }
}

