/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import java.awt.EventQueue;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.ruby.debugger.DebuggerAnnotation;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Line;

public final class EditorUtil {
    private static final Logger LOGGER = Logger.getLogger(EditorUtil.class.getName());
    public static boolean showLines = true;
    private static DebuggerAnnotation currentLineDA;

    private EditorUtil() {
    }

    static void markCurrent(String filePath, int lineNumber) {
        EditorUtil.markCurrent(EditorUtil.getLineAnnotable(filePath, lineNumber));
    }

    private static void markCurrent(Line line) {
        EditorUtil.unmarkCurrent();
        if (line == null) {
            return;
        }
        currentLineDA = new DebuggerAnnotation("CurrentPC", (Annotatable)line);
        EditorUtil.showLine(line, true);
    }

    static void unmarkCurrent() {
        if (currentLineDA != null) {
            currentLineDA.detach();
            currentLineDA = null;
        }
    }

    public static Line getLineAnnotable(String filePath, int lineNumber) {
        return EditorUtil.getLine(filePath, lineNumber);
    }

    public static Line getLine(String filePath, int lineNumber) {
        if (filePath == null || lineNumber < 0) {
            return null;
        }
        File file = new File(filePath);
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            LOGGER.info("Cannot resolve \"" + filePath + '\"');
            return null;
        }
        LineCookie lineCookie = EditorUtil.getLineCookie(fileObject);
        if (lineCookie == null) {
            LOGGER.info("Can't find LineCookie for: " + fileObject);
            return null;
        }
        try {
            return lineCookie.getLineSet().getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException ioobe) {
            return null;
        }
    }

    public static LineCookie getLineCookie(FileObject fo) {
        LineCookie result = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fo);
            if (dataObject != null) {
                result = (LineCookie)dataObject.getCookie(LineCookie.class);
            }
        }
        catch (DataObjectNotFoundException e) {
            LOGGER.log(Level.INFO, "Cannot find DataObject for: " + fo, e.getMessage());
        }
        return result;
    }

    public static void showLine(final Line lineToShow, boolean toFront) {
        if (!showLines) {
            return;
        }
        if (lineToShow == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                lineToShow.show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS);
            }
        });
    }

    public static void showLine(Line line) {
        EditorUtil.showLine(line, false);
    }

    public static Line getCurrentLine() {
        FileObject fo = EditorContextDispatcher.getDefault().getCurrentFile();
        if (fo == null) {
            return null;
        }
        if (!Util.isRubySource(fo)) {
            return null;
        }
        return EditorContextDispatcher.getDefault().getCurrentLine();
    }
}

