/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;

public class BrkpntSetCommand
extends DbgpCommand {
    public static final String BREAKPOINT_SET = "breakpoint_set";
    private static final String TYPE_ARG = "-t ";
    private static final String FILE_ARG = "-f ";
    private static final String LINE_ARG = "-n ";
    private static final String STATE_ARG = "-s ";
    private static final String TEMP_ARG = "-r ";
    private static final String FUNC_ARG = "-m ";
    private static final String EXCEPTION_ARG = "-x";
    protected static final String SPACE = " ";
    private String myFunction;
    private Types myType;
    private String myFile;
    private String myException;
    private State myState = State.ENABLED;
    private int myLineNumber = -1;
    private String myExpression;
    private boolean isTemporary;
    private int myHitCount = -1;
    private int myHitValue = -1;
    private String myHitCondition;
    private AbstractBreakpoint myBrkpnt;

    BrkpntSetCommand(String transactionId) {
        this(BREAKPOINT_SET, transactionId);
    }

    BrkpntSetCommand(String cmndName, String transactionId) {
        super(cmndName, transactionId);
    }

    @Override
    public boolean wantAcknowledgment() {
        return true;
    }

    public void setBreakpoint(AbstractBreakpoint breakpoint) {
        this.myBrkpnt = breakpoint;
    }

    public AbstractBreakpoint getBreakpoint() {
        return this.myBrkpnt;
    }

    public void setType(Types type) {
        this.myType = type;
    }

    public void setFile(String file) {
        this.myFile = file;
    }

    public void setFunction(String function) {
        this.myFunction = function;
    }

    public void setException(String exception) {
        this.myException = exception;
    }

    public void setState(State state) {
        this.myState = state;
    }

    public void setLineNumber(int line) {
        this.myLineNumber = line;
    }

    public void setExpression(String expression) {
        this.myException = expression;
    }

    public void setTemporary(boolean isTemp) {
        this.isTemporary = isTemp;
    }

    public void setHitCount(int count) {
        this.myHitCount = count;
    }

    public void setHitValue(int value) {
        this.myHitValue = value;
    }

    public void setHitCondition(String condition) {
        this.myHitCondition = condition;
    }

    @Override
    protected String getData() {
        return this.myExpression;
    }

    @Override
    protected String getArguments() {
        assert (this.myType != null);
        StringBuilder builder = new StringBuilder();
        this.setType(builder);
        this.setState(builder);
        this.setTemporary(builder);
        switch (this.myType) {
            case LINE: {
                this.setLineArguments(builder);
                break;
            }
            case CALL: {
                this.setCallArguments(builder);
                break;
            }
            case RETURN: {
                this.setReturnArguments(builder);
                break;
            }
            case EXCEPTION: {
                this.setExceptionArguments(builder);
                break;
            }
            case CONDITIONAL: {
                this.setConditionalArguments(builder);
                break;
            }
            case WATCH: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return builder.toString();
    }

    private void setTemporary(StringBuilder builder) {
        if (this.isTemporary) {
            builder.append(SPACE);
            builder.append(TEMP_ARG);
            builder.append(1);
        }
    }

    private void setState(StringBuilder builder) {
        if (this.myState != null) {
            builder.append(SPACE);
            builder.append(STATE_ARG);
            builder.append(this.myState.toString());
        }
    }

    private void setConditionalArguments(StringBuilder builder) {
        builder.append(SPACE);
        builder.append(FILE_ARG);
        builder.append(this.myFile);
        if (this.myLineNumber > -1) {
            builder.append(SPACE);
            builder.append(FILE_ARG);
            builder.append(this.myFile);
        }
    }

    private void setExceptionArguments(StringBuilder builder) {
        builder.append(SPACE);
        builder.append(EXCEPTION_ARG);
        builder.append(this.myException);
    }

    private void setReturnArguments(StringBuilder builder) {
        this.setCallArguments(builder);
    }

    private void setCallArguments(StringBuilder builder) {
        builder.append(SPACE);
        builder.append(FUNC_ARG);
        builder.append(this.myFunction);
    }

    private void setLineArguments(StringBuilder builder) {
        builder.append(SPACE);
        builder.append(FILE_ARG);
        builder.append(this.myFile);
        builder.append(SPACE);
        builder.append(LINE_ARG);
        builder.append(this.myLineNumber + 1);
    }

    private void setType(StringBuilder builder) {
        builder.append(TYPE_ARG);
        builder.append(this.myType.toString());
    }

    public static enum State {
        ENABLED,
        DISABLED;


        public String toString() {
            return super.toString().toLowerCase();
        }

        public static State forString(String str) {
            State[] states;
            for (State state : states = State.values()) {
                if (!state.toString().equals(str)) continue;
                return state;
            }
            return null;
        }
    }

    public static enum Types {
        LINE,
        CALL,
        RETURN,
        EXCEPTION,
        CONDITIONAL,
        WATCH;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

