/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.db.sql.history.SQLHistory;
import org.netbeans.modules.db.sql.history.SQLHistoryException;
import org.netbeans.modules.db.sql.history.SQLHistoryModel;
import org.netbeans.modules.db.sql.history.SQLHistoryPersistenceManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;

public class SQLHistoryModelImpl
implements SQLHistoryModel {
    private static final int SAVE_STATEMENTS_EMPTY = 0;
    private static final String SAVE_STATEMENTS_CLEARED = "";
    private static final Logger LOGGER = Logger.getLogger(SQLHistoryModelImpl.class.getName());
    private static final FileObject USERDIR = FileUtil.getConfigRoot();
    List<SQLHistory> _sqlHistoryList = new ArrayList<SQLHistory>();

    @Override
    public void initialize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setFilter(String filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getFilter() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<SQLHistory> getSQLHistoryList() throws SQLHistoryException {
        List<Object> retrievedSQL = new ArrayList();
        this._sqlHistoryList.clear();
        try {
            String savedLimit;
            boolean isRewriteSQLRequired = false;
            FileObject historyRoot = USERDIR.getFileObject("Databases/SQLHISTORY");
            if (historyRoot == null) {
                return new ArrayList<SQLHistory>();
            }
            retrievedSQL = SQLHistoryPersistenceManager.getInstance().retrieve(historyRoot);
            if (!this.isSQLUnique(retrievedSQL)) {
                retrievedSQL = this.removeDuplicates(retrievedSQL);
                isRewriteSQLRequired = true;
            }
            if ((savedLimit = NbPreferences.forModule(SQLHistoryPersistenceManager.class).get("SQL_STATEMENTS_SAVED_FOR_HISTORY", SAVE_STATEMENTS_CLEARED)).equals(SAVE_STATEMENTS_CLEARED)) {
                savedLimit = "100";
            }
            int limit = Integer.parseInt(savedLimit);
            if (retrievedSQL.size() > limit) {
                retrievedSQL = this.removeExtraSQL(retrievedSQL, limit);
                isRewriteSQLRequired = true;
            }
            if (isRewriteSQLRequired) {
                SQLHistoryPersistenceManager.getInstance().updateSQLSaved(0, historyRoot);
                Collections.reverse(retrievedSQL);
                SQLHistoryPersistenceManager.getInstance().create(historyRoot, retrievedSQL);
                Collections.reverse(retrievedSQL);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new SQLHistoryException();
        }
        return retrievedSQL;
    }

    private boolean isSQLUnique(List<SQLHistory> sqlHistoryList) {
        ArrayList<SQLHistory> revSqLHistoryList = new ArrayList<SQLHistory>();
        boolean isUnique = true;
        for (SQLHistory sqlHistory : sqlHistoryList) {
            for (SQLHistory revHistory : revSqLHistoryList) {
                if (!revHistory.getSql().trim().equals(sqlHistory.getSql().trim()) || !revHistory.getUrl().equals(sqlHistory.getUrl())) continue;
                isUnique = false;
            }
            revSqLHistoryList.add(sqlHistory);
        }
        return isUnique;
    }

    private List<SQLHistory> removeDuplicates(List<SQLHistory> sqlHistoryList) {
        ArrayList<SQLHistory> revSqLHistoryList = new ArrayList<SQLHistory>();
        boolean canAdd = true;
        for (SQLHistory sqlHistory : sqlHistoryList) {
            for (SQLHistory revHistory : revSqLHistoryList) {
                if (!revHistory.getSql().trim().equals(sqlHistory.getSql().trim()) || !revHistory.getUrl().equals(sqlHistory.getUrl())) continue;
                canAdd = false;
            }
            if (canAdd) {
                revSqLHistoryList.add(sqlHistory);
                continue;
            }
            canAdd = true;
        }
        return revSqLHistoryList;
    }

    private List<SQLHistory> removeExtraSQL(List<SQLHistory> sqlHistoryList, int limit) {
        int i = 0;
        ArrayList<SQLHistory> revSqLHistoryList = new ArrayList<SQLHistory>();
        for (SQLHistory sqlHistory : sqlHistoryList) {
            if (i < limit) {
                revSqLHistoryList.add(sqlHistory);
            }
            ++i;
        }
        return revSqLHistoryList;
    }

    @Override
    public void setSQLHistoryList(List<SQLHistory> sqlHistoryList) {
        this._sqlHistoryList = sqlHistoryList;
    }
}

