/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.metro.model.ui;

import com.sun.xml.ws.runtime.config.MetroConfig;
import com.sun.xml.ws.runtime.config.TubeFactoryConfig;
import com.sun.xml.ws.runtime.config.TubeFactoryList;
import com.sun.xml.ws.runtime.config.TubelineDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.metro.model.MetroConfigLoader;
import org.netbeans.modules.websvc.metro.model.ui.TubesConfigPanel;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TubesProjectConfigPanel
extends JPanel {
    private Project project;
    private boolean isChanged;
    private MetroConfig cfg;
    private boolean override;
    private MetroConfigLoader cfgLoader = new MetroConfigLoader();
    private JButton addBtnClient;
    private JButton addBtnService;
    private JLabel clientLbl;
    private JButton downBtnClient;
    private JButton downBtnService;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JCheckBox overrideChBox;
    private JButton removeBtnClient;
    private JButton removeBtnService;
    private JLabel serviceLbl;
    private JTable tubeTableClient;
    private TubeTableModel tubeTableClientModel;
    private JTable tubeTableService;
    private TubeTableModel tubeTableServiceModel;
    private JButton upBtnClient;
    private JButton upBtnService;

    public TubesProjectConfigPanel(Project project, MetroConfig metroConfig, boolean bl) {
        this.project = project;
        this.cfg = metroConfig;
        this.override = bl;
        this.initComponents();
        this.addBtnClient.addActionListener(new AddButtonActionListener(true));
        this.removeBtnClient.addActionListener(new RemoveButtonActionListener(true));
        this.addBtnService.addActionListener(new AddButtonActionListener(false));
        this.removeBtnService.addActionListener(new RemoveButtonActionListener(false));
        this.populateValues();
        this.isChanged = false;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public boolean isOverride() {
        return this.overrideChBox.isSelected();
    }

    public List<String> getTubeList(boolean bl) {
        TubeTableModel tubeTableModel = bl ? this.tubeTableClientModel : this.tubeTableServiceModel;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < tubeTableModel.getRowCount(); ++i) {
            arrayList.add((String)tubeTableModel.getValueAt(i, 0));
        }
        return arrayList;
    }

    protected void populateValues() {
        TubelineDefinition tubelineDefinition = this.cfgLoader.getDefaultTubeline(this.cfg);
        if (tubelineDefinition != null) {
            List<TubeFactoryConfig> list;
            TubeFactoryList tubeFactoryList = tubelineDefinition.getClientSide();
            TubeFactoryList tubeFactoryList2 = tubelineDefinition.getEndpointSide();
            if (tubeFactoryList != null) {
                list = tubeFactoryList.getTubeFactoryConfigs();
                for (TubeFactoryConfig tubeFactoryConfig : list) {
                    this.tubeTableClientModel.addRow(new Object[]{tubeFactoryConfig.getClassName()});
                }
                if (this.tubeTableClientModel.getRowCount() > 0) {
                    this.tubeTableClient.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
            if (tubeFactoryList2 != null) {
                list = tubeFactoryList2.getTubeFactoryConfigs();
                for (TubeFactoryConfig tubeFactoryConfig : list) {
                    this.tubeTableServiceModel.addRow(new Object[]{tubeFactoryConfig.getClassName()});
                }
                if (this.tubeTableServiceModel.getRowCount() > 0) {
                    this.tubeTableService.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        }
        this.overrideChBox.setSelected(this.override);
        this.enableDisable();
    }

    private void enableDisable() {
        boolean bl = this.overrideChBox.isSelected();
        this.serviceLbl.setEnabled(bl);
        this.downBtnService.setEnabled(bl);
        this.upBtnService.setEnabled(bl);
        this.addBtnService.setEnabled(bl);
        this.removeBtnService.setEnabled(bl);
        this.jScrollPane2.setEnabled(bl);
        this.tubeTableService.setEnabled(bl);
        this.clientLbl.setEnabled(bl);
        this.downBtnClient.setEnabled(bl);
        this.upBtnClient.setEnabled(bl);
        this.addBtnClient.setEnabled(bl);
        this.removeBtnClient.setEnabled(bl);
        this.jScrollPane3.setEnabled(bl);
        this.tubeTableClient.setEnabled(bl);
    }

    private void initComponents() {
        this.addBtnService = new JButton();
        this.removeBtnService = new JButton();
        this.upBtnService = new JButton();
        this.downBtnService = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.tubeTableService = new TubeTable(false);
        this.jScrollPane3 = new JScrollPane();
        this.tubeTableClient = new TubeTable(true);
        this.addBtnClient = new JButton();
        this.upBtnClient = new JButton();
        this.removeBtnClient = new JButton();
        this.downBtnClient = new JButton();
        this.clientLbl = new JLabel();
        this.serviceLbl = new JLabel();
        this.overrideChBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.addBtnService, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Add"));
        this.addBtnService.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeBtnService, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Remove"));
        this.removeBtnService.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.upBtnService, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Move_Up"));
        this.upBtnService.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Move_Up"));
        this.upBtnService.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TubesProjectConfigPanel.this.moveUpHandler(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.downBtnService, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Move_Down"));
        this.downBtnService.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Move_Down"));
        this.downBtnService.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TubesProjectConfigPanel.this.moveDownHandler(actionEvent);
            }
        });
        this.tubeTableServiceModel = new TubeTableModel(new String[]{NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HEADING_TUBES")}, 0);
        this.tubeTableService.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.tubeTableService.setModel(this.tubeTableServiceModel);
        this.jScrollPane2.setViewportView(this.tubeTableService);
        this.tubeTableService.getAccessibleContext().setAccessibleName("null");
        this.tubeTableService.getAccessibleContext().setAccessibleDescription("null");
        this.tubeTableClientModel = new TubeTableModel(new String[]{NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HEADING_TUBES")}, 0);
        this.tubeTableClient.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.tubeTableClient.setModel(this.tubeTableClientModel);
        this.jScrollPane3.setViewportView(this.tubeTableClient);
        Mnemonics.setLocalizedText((AbstractButton)this.addBtnClient, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Add"));
        this.addBtnClient.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.upBtnClient, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Move_Up"));
        this.upBtnClient.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Move_Up"));
        this.upBtnClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TubesProjectConfigPanel.this.upBtnClientmoveUpHandler(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeBtnClient, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Remove"));
        this.removeBtnClient.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.downBtnClient, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_Move_Down"));
        this.downBtnClient.setToolTipText(NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"HINT_Move_Down"));
        this.downBtnClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TubesProjectConfigPanel.this.downBtnClientmoveDownHandler(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.clientLbl, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_ClientTubeline"));
        Mnemonics.setLocalizedText((JLabel)this.serviceLbl, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_ServiceTubeline"));
        Mnemonics.setLocalizedText((AbstractButton)this.overrideChBox, (String)NbBundle.getMessage(TubesProjectConfigPanel.class, (String)"LBL_OverrideLibDefaults"));
        this.overrideChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TubesProjectConfigPanel.this.overrideChBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane2, -1, 332, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.addBtnService, -1, 190, Short.MAX_VALUE).add((Component)this.upBtnService, -1, 190, Short.MAX_VALUE).add((Component)this.removeBtnService, -1, 190, Short.MAX_VALUE).add((Component)this.downBtnService, -1, 190, Short.MAX_VALUE))).add((Component)this.serviceLbl).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane3, -1, 332, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.addBtnClient, -1, 190, Short.MAX_VALUE).add((Component)this.upBtnClient, -1, 190, Short.MAX_VALUE).add((Component)this.removeBtnClient, -1, 190, Short.MAX_VALUE).add((Component)this.downBtnClient, -1, 190, Short.MAX_VALUE))).add((Component)this.clientLbl).add((Component)this.overrideChBox)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.overrideChBox).addPreferredGap(0).add((Component)this.serviceLbl).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane2, -2, 246, -2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addBtnService).addPreferredGap(0).add((Component)this.removeBtnService).add(23, 23, 23).add((Component)this.upBtnService).addPreferredGap(0).add((Component)this.downBtnService))).addPreferredGap(1).add((Component)this.clientLbl).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane3, -2, 246, -2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addBtnClient).addPreferredGap(0).add((Component)this.removeBtnClient).add(23, 23, 23).add((Component)this.upBtnClient).addPreferredGap(0).add((Component)this.downBtnClient))).addContainerGap(-1, Short.MAX_VALUE)));
        this.addBtnService.getAccessibleContext().setAccessibleName("null");
    }

    private void moveUpHandler(ActionEvent actionEvent) {
        int n = this.getSelectedRow(false);
        if (n == -1) {
            return;
        }
        int n2 = n - 1;
        this.tubeTableServiceModel.moveRow(n, n, n2);
        this.tubeTableService.getSelectionModel().setSelectionInterval(n2, n2);
        this.isChanged = true;
    }

    private void moveDownHandler(ActionEvent actionEvent) {
        int n = this.getSelectedRow(false);
        if (n == -1) {
            return;
        }
        int n2 = n + 1;
        this.tubeTableServiceModel.moveRow(n, n, n2);
        this.tubeTableService.getSelectionModel().setSelectionInterval(n2, n2);
        this.isChanged = true;
    }

    private void upBtnClientmoveUpHandler(ActionEvent actionEvent) {
        int n = this.getSelectedRow(true);
        if (n == -1) {
            return;
        }
        int n2 = n - 1;
        this.tubeTableClientModel.moveRow(n, n, n2);
        this.tubeTableClient.getSelectionModel().setSelectionInterval(n2, n2);
        this.isChanged = true;
    }

    private void downBtnClientmoveDownHandler(ActionEvent actionEvent) {
        int n = this.getSelectedRow(true);
        if (n == -1) {
            return;
        }
        int n2 = n + 1;
        this.tubeTableClientModel.moveRow(n, n, n2);
        this.tubeTableClient.getSelectionModel().setSelectionInterval(n2, n2);
        this.isChanged = true;
    }

    private void overrideChBoxActionPerformed(ActionEvent actionEvent) {
        this.enableDisable();
        this.isChanged = true;
    }

    protected int getSelectedRow(boolean bl) {
        JTable jTable = bl ? this.tubeTableClient : this.tubeTableService;
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            return -1;
        }
        return listSelectionModel.getMinSelectionIndex();
    }

    class TubeTableModel
    extends DefaultTableModel {
        public TubeTableModel(Object[] objectArray, int n) {
            super(objectArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class TubeListSelectionListener
    implements ListSelectionListener {
        private boolean client;

        public TubeListSelectionListener(boolean bl) {
            this.client = bl;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                JButton jButton;
                JButton jButton2 = this.client ? TubesProjectConfigPanel.this.upBtnClient : TubesProjectConfigPanel.this.upBtnService;
                int n = TubesProjectConfigPanel.this.getSelectedRow(this.client);
                if (n == 0) {
                    jButton2.setEnabled(false);
                } else if (!jButton2.isEnabled()) {
                    jButton2.setEnabled(true);
                }
                TubeTableModel tubeTableModel = this.client ? TubesProjectConfigPanel.this.tubeTableClientModel : TubesProjectConfigPanel.this.tubeTableServiceModel;
                JButton jButton3 = jButton = this.client ? TubesProjectConfigPanel.this.downBtnClient : TubesProjectConfigPanel.this.downBtnService;
                if (n == tubeTableModel.getRowCount() - 1) {
                    jButton.setEnabled(false);
                } else if (!jButton.isEnabled()) {
                    jButton.setEnabled(true);
                }
            }
        }
    }

    class TubeTable
    extends JTable {
        private boolean client;

        public TubeTable(boolean bl) {
            this.client = bl;
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.setResizingAllowed(false);
            jTableHeader.setReorderingAllowed(false);
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            listSelectionModel.setSelectionMode(1);
            listSelectionModel.addListSelectionListener(new TubeListSelectionListener(bl));
        }

        @Override
        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            this.getTableHeader().setEnabled(this.isEnabled());
            component.setEnabled(this.isEnabled());
            return component;
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        private boolean client;
        DialogDescriptor dlgDesc = null;

        public AddButtonActionListener(boolean bl) {
            this.client = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            TubeTableModel tubeTableModel;
            ClassDialog classDialog = new ClassDialog(TubesProjectConfigPanel.this.project, null);
            classDialog.show();
            int n = 0;
            TubeTableModel tubeTableModel2 = tubeTableModel = this.client ? TubesProjectConfigPanel.this.tubeTableClientModel : TubesProjectConfigPanel.this.tubeTableServiceModel;
            if (classDialog.okButtonPressed()) {
                object = classDialog.getSelectedClasses();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    tubeTableModel.addRow(new Object[]{string});
                    n = tubeTableModel.getRowCount() - 1;
                }
            }
            object = this.client ? TubesProjectConfigPanel.this.tubeTableClient : TubesProjectConfigPanel.this.tubeTableService;
            ((JTable)object).getSelectionModel().setSelectionInterval(n, n);
            TubesProjectConfigPanel.this.isChanged = true;
        }
    }

    class RemoveButtonActionListener
    implements ActionListener {
        private boolean client;

        public RemoveButtonActionListener(boolean bl) {
            this.client = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = this.client ? TubesProjectConfigPanel.this.tubeTableClient : TubesProjectConfigPanel.this.tubeTableService;
            int[] nArray = jTable.getSelectedRows();
            Arrays.sort(nArray);
            if (nArray == null || nArray.length <= 0) {
                return;
            }
            TubeTableModel tubeTableModel = this.client ? TubesProjectConfigPanel.this.tubeTableClientModel : TubesProjectConfigPanel.this.tubeTableServiceModel;
            String string = "";
            for (int n : nArray) {
                string = string + (String)tubeTableModel.getValueAt(n, 0) + ", \n";
            }
            if (this.confirmDeletion(string)) {
                int n;
                for (n = nArray.length - 1; n >= 0; --n) {
                    tubeTableModel.removeRow(nArray[n]);
                }
                n = nArray[0] - 1;
                jTable.getSelectionModel().setSelectionInterval(n, n);
                TubesProjectConfigPanel.this.isChanged = true;
            }
        }

        private boolean confirmDeletion(String string) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TubesConfigPanel.class, (String)"MSG_CONFIRM_DELETE", (Object)string), NbBundle.getMessage(TubesConfigPanel.class, (String)"TTL_CONFIRM_DELETE"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            return confirmation.getValue() == NotifyDescriptor.YES_OPTION;
        }
    }
}

