/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.util;

import java.beans.PropertyEditor;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import org.netbeans.modules.j2ee.sun.bridge.apis.AppserverMgmtActiveNode;
import org.netbeans.modules.j2ee.sun.ide.editors.LogLevelEditor;
import org.netbeans.modules.j2ee.sun.ide.editors.NameValuePair;
import org.netbeans.modules.j2ee.sun.ide.editors.NameValuePairsPropertyEditor;
import org.netbeans.modules.j2ee.sun.ide.runtime.nodes.DomainRootNode;
import org.netbeans.modules.j2ee.sun.ide.runtime.nodes.ResourceLeafNode;
import org.netbeans.modules.j2ee.sun.util.EnhancedPropertyEditorFactory;
import org.netbeans.modules.j2ee.sun.util.PropertyConstants;
import org.openide.execution.NbClassPath;
import org.openide.nodes.PropertySupport;

public class PropertySupportFactory {
    private static Logger logger;
    private static PropertySupportFactory factory;
    private EnhancedPropertyEditorFactory editorFactory;
    private static final String ARRAY_DELIM = " , ";
    ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/util/Bundle");
    static Map typeToClassesMap;

    private PropertySupportFactory() {
        this.editorFactory = EnhancedPropertyEditorFactory.getInstance();
    }

    public static PropertySupportFactory getInstance() {
        if (factory == null) {
            factory = new PropertySupportFactory();
        }
        return factory;
    }

    public PropertySupport getPropertySupport(AppserverMgmtActiveNode parent, Attribute attr, MBeanAttributeInfo info) {
        PropertySupport support = null;
        String attrName = attr.getName();
        if (Arrays.asList(PropertyConstants.CUSTOM_PROPERTIES).contains(attrName)) {
            support = this.getCustomPropertyEditors(parent, attr, info, attrName);
        } else if (attr.getValue() instanceof String[]) {
            String[] strArray = (String[])attr.getValue();
            support = info.isWritable() ? this.createStringArrayWritableProperty(parent, attr, info, strArray.getClass()) : this.createStringArrayReadOnlyProperty(attr, info, strArray.getClass());
            support.setValue("item.separator", (Object)" ");
        } else {
            support = info.isWritable() ? (parent.getNodeType().equals("WEB_APP") && attrName.equals("ContextRoot") && !parent.isServerLocal() ? this.createReadOnlyPropertySupport(attr, info) : this.createReadWritePropertySupport(parent, attr, info)) : this.createReadOnlyPropertySupport(attr, info);
        }
        return support;
    }

    private PropertySupport getCustomPropertyEditors(AppserverMgmtActiveNode parent, Attribute attr, MBeanAttributeInfo info, String attrName) {
        PropertySupport support = null;
        if (attrName.equals("Properties") && !parent.getNodeType().equals("JVM") && parent instanceof ResourceLeafNode) {
            ResourceLeafNode resourceNode = (ResourceLeafNode)parent;
            support = this.createExtraProperties(resourceNode, attr, info);
        } else {
            support = attrName.equals("ResType") ? (parent.getNodeType().equals("CONNECTION_POOL") ? this.createWritablePropertySupportWithEditor(parent, attr, info, attrName) : this.createWritablePropertySupportWithoutEditor(parent, attr, info)) : this.createWritablePropertySupportWithEditor(parent, attr, info, attrName);
        }
        return support;
    }

    private PropertySupport createReadOnlyPropertySupport(final Attribute attr, MBeanAttributeInfo info) {
        String name = attr.getName();
        return new PropertySupport.ReadOnly(name, PropertySupportFactory.getClassFromStringType(info.getType()), name, name){

            public Object getValue() {
                return PropertySupportFactory.this.calculateReturnObjectType(attr);
            }
        };
    }

    private PropertySupport createReadWritePropertySupport(AppserverMgmtActiveNode parent, Attribute attr, MBeanAttributeInfo info) {
        PropertySupport support = null;
        if (attr.getValue() instanceof Boolean || info.getType().equalsIgnoreCase("boolean")) {
            support = this.createWritablePropertySupportWithEditor(parent, attr, info, "Boolean");
        } else if (Arrays.asList(PropertyConstants.JVM_STR_TO_ARR).contains(attr.getName())) {
            if (parent.isServerLocal()) {
                support = this.createNetBeansClassPathProperty(parent, attr, info);
            } else {
                String[] arrayNames = new String[]{};
                support = this.createModifiedStringArrayReadOnlyProperty(parent, attr, info, arrayNames.getClass());
            }
        } else {
            support = this.createWritablePropertySupportWithoutEditor(parent, attr, info);
        }
        return support;
    }

    private PropertySupport createWritablePropertySupportWithEditor(final AppserverMgmtActiveNode parent, final Attribute attr, MBeanAttributeInfo info, final String customType) {
        String name = attr.getName();
        return new PropertySupport.ReadWrite(name, PropertySupportFactory.getClassFromStringType(info.getType()), name, name){
            Attribute attribute;
            {
                super(x0, x1, x2, x3);
                this.attribute = attr;
            }

            public Object getValue() {
                Object obj = this.attribute.getValue();
                if (obj != null) {
                    obj = obj.toString();
                }
                return obj;
            }

            public void setValue(Object obj) {
                this.attribute = PropertySupportFactory.this.revertAttribute(parent, this.getName(), obj, this.attribute);
            }

            public PropertyEditor getPropertyEditor() {
                return PropertySupportFactory.this.editorFactory.getEnhancedPropertyEditor(this.attribute.getValue(), customType);
            }
        };
    }

    private PropertySupport createWritablePropertySupportWithoutEditor(final AppserverMgmtActiveNode parent, final Attribute attr, MBeanAttributeInfo info) {
        String name = attr.getName();
        return new PropertySupport.ReadWrite(name, PropertySupportFactory.getClassFromStringType(info.getType()), name, name){
            Attribute attribute;
            {
                super(x0, x1, x2, x3);
                this.attribute = attr;
            }

            public Object getValue() {
                return PropertySupportFactory.this.calculateReturnObjectType(this.attribute);
            }

            public void setValue(Object obj) {
                this.attribute = PropertySupportFactory.this.revertAttribute(parent, this.getName(), obj, this.attribute);
            }
        };
    }

    private Object calculateReturnObjectType(Attribute attr) {
        Object obj = attr.getValue();
        if (obj instanceof ObjectName[]) {
            ObjectName[] objNames = (ObjectName[])obj;
            String[] arrayNames = new String[objNames.length];
            for (int i = 0; i < objNames.length; ++i) {
                arrayNames[i] = objNames[i].toString();
            }
            return arrayNames;
        }
        if (obj instanceof String[]) {
            String[] values = (String[])obj;
            StringBuffer returnVals = new StringBuffer();
            int pos = 0;
            for (int i = 0; i < values.length; ++i) {
                returnVals.append(values[i]);
                if (++pos >= values.length) continue;
                returnVals.append(ARRAY_DELIM);
            }
            return returnVals;
        }
        if (obj != null || !(obj instanceof String)) {
            if (obj == null) {
                return "";
            }
            obj = obj.toString();
            return obj;
        }
        return "";
    }

    private static Class getClassFromStringType(String type) {
        Class<?> clazz = null;
        try {
            clazz = (Class<?>)typeToClassesMap.get(type);
            if (clazz == null) {
                clazz = Class.forName(type);
            }
            if (clazz == null) {
                throw new ClassNotFoundException(type);
            }
            if (!String.class.isAssignableFrom(clazz) && !Number.class.isAssignableFrom(clazz)) {
                throw new ClassNotFoundException(type);
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
        return clazz;
    }

    PropertySupport createExtraProperties(final ResourceLeafNode parent, final Attribute attr, MBeanAttributeInfo info) {
        return new PropertySupport.ReadWrite(info.getName(), NameValuePairsPropertyEditor.class, this.bundle.getString("LBL_ExtParams"), this.bundle.getString("DSC_ExtParams")){
            Attribute attribute;
            {
                super(x0, x1, x2, x3);
                this.attribute = attr;
            }

            public Object getValue() {
                return this.attribute.getValue();
            }

            public void setValue(Object obj) {
                if (obj instanceof Object[]) {
                    Map attributeMap = (Map)this.attribute.getValue();
                    Map oldAttrMap = (Map)this.attribute.getValue();
                    Object[] currentVal = (Object[])obj;
                    NameValuePair[] pairs = PropertySupportFactory.this.getNameValuePairs(currentVal);
                    HashMap<String, String> propertyList = new HashMap<String, String>();
                    HashMap<String, Attribute> newPropsMap = new HashMap<String, Attribute>();
                    for (int i = 0; i < pairs.length; ++i) {
                        String name = pairs[i].getParamName();
                        String value = pairs[i].getParamValue();
                        if (attributeMap.containsKey(name)) {
                            String prevValue = (String)attributeMap.get(name);
                            if (!prevValue.equals(value)) {
                                Attribute attr2 = new Attribute(name, value);
                                newPropsMap.put(name, attr2);
                            } else {
                                oldAttrMap.remove(name);
                            }
                        } else {
                            Attribute attr3 = new Attribute(name, value);
                            newPropsMap.put(name, attr3);
                        }
                        propertyList.put(name, value);
                    }
                    Object[] props = newPropsMap.values().toArray();
                    parent.updateExtraProperty(props, oldAttrMap);
                    this.attribute = new Attribute(this.getName(), propertyList);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new NameValuePairsPropertyEditor(this.attribute.getValue());
            }
        };
    }

    PropertySupport createStringArrayReadOnlyProperty(final Attribute a, MBeanAttributeInfo attr, Class type) {
        return new PropertySupport.ReadOnly(attr.getName(), type, attr.getName(), attr.getName()){
            Attribute attribute;
            {
                super(x0, x1, x2, x3);
                this.attribute = a;
            }

            public Object getValue() {
                Object[] val = (Object[])this.attribute.getValue();
                if (this.attribute.getValue() instanceof ObjectName[]) {
                    ObjectName[] objNames = (ObjectName[])val;
                    String[] arrayNames = new String[objNames.length];
                    for (int i = 0; i < objNames.length; ++i) {
                        arrayNames[i] = objNames[i].toString();
                    }
                    return arrayNames;
                }
                return this.attribute.getValue();
            }
        };
    }

    PropertySupport createStringArrayWritableProperty(final AppserverMgmtActiveNode parent, final Attribute attr, MBeanAttributeInfo info, Class type) {
        return new PropertySupport.ReadWrite(info.getName(), type, info.getName(), info.getName()){
            Attribute attribute;
            {
                super(x0, x1, x2, x3);
                this.attribute = attr;
            }

            public Object getValue() {
                Object[] val = (Object[])this.attribute.getValue();
                if (this.attribute.getValue() instanceof ObjectName[]) {
                    ObjectName[] objNames = (ObjectName[])val;
                    String[] arrayNames = new String[objNames.length];
                    for (int i = 0; i < objNames.length; ++i) {
                        arrayNames[i] = objNames[i].toString();
                    }
                    return arrayNames;
                }
                String[] values = (String[])this.attribute.getValue();
                return values;
            }

            public void setValue(Object obj) {
                this.attribute = PropertySupportFactory.this.revertAttribute(parent, this.getName(), obj, this.attribute);
            }
        };
    }

    PropertySupport createNetBeansClassPathProperty(final AppserverMgmtActiveNode parent, final Attribute attr, MBeanAttributeInfo info) {
        return new PropertySupport.ReadWrite(info.getName(), NbClassPath.class, info.getName(), info.getName()){
            Attribute attribute;
            {
                super(x0, x1, x2, x3);
                this.attribute = attr;
            }

            public Object getValue() {
                if (this.attribute.getValue() != null) {
                    String val = PropertySupportFactory.this.replacePathSeperatorToken(this.attribute.getValue().toString());
                    return new NbClassPath(val);
                }
                return null;
            }

            public void setValue(Object val) {
                String value = ((NbClassPath)val).getClassPath();
                value = PropertySupportFactory.this.stripQuotes(value);
                String obj = PropertySupportFactory.this.replacePathSeperator(value);
                this.attribute = PropertySupportFactory.this.revertAttribute(parent, this.getName(), obj, this.attribute);
            }
        };
    }

    public PropertySupport createLogLevelProperty(final DomainRootNode parent, final Attribute attr, MBeanAttributeInfo info) {
        return new PropertySupport.ReadWrite(info.getName(), LogLevelEditor.class, info.getName(), info.getName()){
            Attribute attribute;
            {
                super(x0, x1, x2, x3);
                this.attribute = attr;
            }

            public Object getValue() {
                return this.attribute.getValue();
            }

            public void setValue(Object val) {
                Attribute updatedAttribute = null;
                try {
                    updatedAttribute = parent.setSheetProperty(this.getName(), val);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (updatedAttribute != null) {
                    this.attribute = updatedAttribute;
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new LogLevelEditor();
            }
        };
    }

    PropertySupport createModifiedStringArrayReadOnlyProperty(AppserverMgmtActiveNode parent, final Attribute attr, MBeanAttributeInfo info, Class classType) {
        return new PropertySupport.ReadOnly(info.getName(), classType, info.getName(), info.getName()){
            char sepChar;
            Attribute attribute;
            {
                super(x0, x1, x2, x3);
                this.sepChar = (char)59;
                this.attribute = attr;
            }

            public Object getValue() {
                Object val = this.attribute.getValue();
                String[] value = null;
                if (val != null) {
                    String strVal = PropertySupportFactory.this.replacePathSeperatorToken(val.toString());
                    if (strVal != null) {
                        this.sepChar = PropertySupportFactory.getSeperationChar(strVal);
                    }
                    value = PropertySupportFactory.createClasspathArray(strVal);
                }
                return value;
            }
        };
    }

    public String replacePathSeperatorToken(String tokenString) {
        String token = "path.separator";
        String resolvedToken = File.pathSeparator;
        tokenString = tokenString.replaceAll("\\$\\{" + token + "\\}", resolvedToken);
        return tokenString;
    }

    public String replacePathSeperator(String tokenString) {
        String token = "path.separator";
        String resolvedToken = File.pathSeparator;
        tokenString = tokenString.replaceAll(resolvedToken, "\\$\\{" + token + "\\}");
        return tokenString;
    }

    private Attribute revertAttribute(AppserverMgmtActiveNode parent, String attrName, Object attrValue, Attribute attribute) {
        Attribute updatedAttribute = null;
        try {
            updatedAttribute = parent.setSheetProperty(attrName, attrValue);
        }
        catch (RuntimeException rex) {
            // empty catch block
        }
        if (updatedAttribute != null) {
            return updatedAttribute;
        }
        return attribute;
    }

    private NameValuePair[] getNameValuePairs(Object[] attrVal) {
        NameValuePair[] pairs = new NameValuePair[attrVal.length];
        for (int j = 0; j < attrVal.length; ++j) {
            NameValuePair pair;
            pairs[j] = pair = (NameValuePair)attrVal[j];
        }
        return pairs;
    }

    private static String[] createClasspathArray(Object cpath) {
        Vector<String> path = new Vector<String>();
        if (cpath != null) {
            String classPath = cpath.toString();
            char sepChar = PropertySupportFactory.getSeperationChar(classPath);
            while (classPath.indexOf(sepChar) != -1) {
                int index = classPath.indexOf(sepChar);
                String val = classPath.substring(0, index);
                path.add(val);
                classPath = classPath.substring(index + 1, classPath.length());
            }
            path.add(classPath);
        }
        if (path != null) {
            Object[] finalPath = path.toArray();
            String[] value = new String[finalPath.length];
            for (int i = 0; i < finalPath.length; ++i) {
                value[i] = finalPath[i].toString();
            }
            return value;
        }
        return null;
    }

    private static char getSeperationChar(String classPath) {
        if (classPath.indexOf(";") != -1) {
            return ';';
        }
        return ':';
    }

    private String stripQuotes(String classPath) {
        if (classPath.startsWith("\"")) {
            int index = classPath.indexOf("\"");
            classPath = classPath.substring(index + 1, classPath.lastIndexOf("\""));
        }
        return classPath;
    }

    static {
        typeToClassesMap = new HashMap();
        typeToClassesMap.put("short", String.class);
        typeToClassesMap.put("long", String.class);
        typeToClassesMap.put("int", String.class);
        typeToClassesMap.put("boolean", String.class);
        typeToClassesMap.put("float", String.class);
        typeToClassesMap.put("double", String.class);
        typeToClassesMap.put("byte", String.class);
        typeToClassesMap.put("char", String.class);
        typeToClassesMap.put(String[].class.getName(), String.class);
        typeToClassesMap.put(Boolean.class.getName(), String.class);
        typeToClassesMap.put(Map.class.getName(), String.class);
        logger = Logger.getLogger("org.netbeans.modules.j2ee.sun");
    }
}

