/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.util;

import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmValidable;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;

public class CsmBaseUtilities {
    private static boolean TRACE_XREF_REPOSITORY = Boolean.getBoolean("cnd.modelimpl.trace.xref.repository");

    private CsmBaseUtilities() {
    }

    public static boolean isValid(CsmObject obj) {
        if (CsmKindUtilities.isValidable(obj)) {
            return ((CsmValidable)((Object)obj)).isValid();
        }
        return obj != null;
    }

    public static boolean isGlobalNamespace(CsmScope scope) {
        if (CsmKindUtilities.isNamespace(scope)) {
            return ((CsmNamespace)scope).isGlobal();
        }
        return false;
    }

    public static boolean isInlineFunction(CsmFunction fun) {
        if (fun.isInline()) {
            return true;
        }
        CsmScope outScope = fun.getScope();
        if (outScope == null || CsmBaseUtilities.isGlobalNamespace(outScope)) {
            return false;
        }
        CsmFunction decl = CsmBaseUtilities.getFunctionDeclaration(fun);
        if (decl == null || !CsmKindUtilities.isMethod(fun)) {
            return false;
        }
        return outScope.equals(((CsmMethod)decl).getContainingClass());
    }

    public static boolean isStaticContext(CsmFunction fun) {
        assert (fun != null) : "must be not null";
        if (CsmKindUtilities.isGlobalFunction(fun)) {
            return true;
        }
        CsmFunction funDecl = CsmBaseUtilities.getFunctionDeclaration(fun);
        if (CsmKindUtilities.isClassMember(funDecl)) {
            return ((CsmMember)((Object)funDecl)).isStatic();
        }
        return false;
    }

    public static CsmFunction getOperator(CsmClassifier cls, CsmFunction.OperatorKind opKind) {
        if (!CsmKindUtilities.isClass(cls)) {
            return null;
        }
        for (CsmMember member : ((CsmClass)cls).getMembers()) {
            if (!CsmKindUtilities.isOperator(member) || ((CsmFunction)((Object)member)).getOperatorKind() != opKind) continue;
            return (CsmFunction)((Object)member);
        }
        return null;
    }

    public static CsmObject[] getDefinitionDeclaration(CsmObject target, boolean unboxInstantiation) {
        CsmObject def;
        CsmObject decl;
        if (unboxInstantiation && CsmKindUtilities.isTemplateInstantiation(target)) {
            target = ((CsmInstantiation)target).getTemplateDeclaration();
        }
        if (CsmKindUtilities.isVariableDefinition(target)) {
            decl = ((CsmVariableDefinition)target).getDeclaration();
            if (decl == null) {
                decl = target;
                if (TRACE_XREF_REPOSITORY) {
                    System.err.println("not found declaration for variable definition " + target);
                }
            }
            def = target;
        } else if (CsmKindUtilities.isVariableDeclaration(target)) {
            decl = target;
            def = ((CsmVariable)target).getDefinition();
        } else if (CsmKindUtilities.isFunctionDefinition(target)) {
            decl = ((CsmFunctionDefinition)target).getDeclaration();
            if (decl == null) {
                decl = target;
                if (TRACE_XREF_REPOSITORY) {
                    System.err.println("not found declaration for function definition " + target);
                }
            }
            def = target;
        } else if (CsmKindUtilities.isFunctionDeclaration(target)) {
            decl = target;
            def = ((CsmFunction)target).getDefinition();
        } else if (CsmKindUtilities.isClassForwardDeclaration(target)) {
            CsmClassForwardDeclaration fd = (CsmClassForwardDeclaration)target;
            if (fd.getCsmClass() != null) {
                decl = target;
                def = fd.getCsmClass();
            } else {
                decl = target;
                def = null;
            }
        } else if (CsmKindUtilities.isClass(target)) {
            CsmClass cls = (CsmClass)target;
            CsmClassifier c = cls.getContainingFile().getProject().findClassifier(cls.getQualifiedName());
            if (cls.equals(c)) {
                decl = target;
                def = null;
            } else if (c != null) {
                decl = c;
                def = cls;
            } else {
                decl = target;
                def = null;
            }
        } else {
            decl = target;
            def = null;
        }
        assert (decl != null);
        return new CsmObject[]{decl, def};
    }

    public static CsmClass getFunctionClass(CsmFunction fun) {
        assert (fun != null) : "must be not null";
        CsmClass clazz = null;
        CsmFunction funDecl = CsmBaseUtilities.getFunctionDeclaration(fun);
        if (CsmKindUtilities.isClassMember(funDecl)) {
            clazz = ((CsmMember)((Object)funDecl)).getContainingClass();
        }
        return clazz;
    }

    public static CsmClass getFunctionClassByQualifiedName(CsmFunction fun) {
        if (fun != null) {
            String className = ((Object)fun.getQualifiedName()).toString().replaceAll("(.*)::.*", "$1");
            CsmClassifier obj = CsmClassifierResolver.getDefault().findClassifierUsedInFile(className, fun.getContainingFile(), false);
            if (CsmKindUtilities.isClassifier(obj)) {
                CsmClassifier cls = obj;
                cls = CsmClassifierResolver.getDefault().getOriginalClassifier(cls, fun.getContainingFile());
                if (CsmKindUtilities.isClass(cls)) {
                    return (CsmClass)cls;
                }
            }
        }
        return null;
    }

    public static CsmClass getObjectClass(CsmObject obj) {
        CsmScope scope;
        CsmClass objClass = null;
        if (CsmKindUtilities.isFunction(obj)) {
            objClass = CsmBaseUtilities.getFunctionClass((CsmFunction)obj);
        } else if (CsmKindUtilities.isClass(obj)) {
            objClass = (CsmClass)obj;
        } else if (CsmKindUtilities.isEnumerator(obj)) {
            objClass = CsmBaseUtilities.getObjectClass(((CsmEnumerator)obj).getEnumeration());
        } else if (CsmKindUtilities.isScopeElement(obj) && CsmKindUtilities.isClass(scope = ((CsmScopeElement)obj).getScope())) {
            objClass = (CsmClass)scope;
        }
        return objClass;
    }

    public static CsmNamespace getObjectNamespace(CsmObject obj) {
        CsmScope scope;
        CsmNamespace objNs = null;
        if (CsmKindUtilities.isNamespace(obj)) {
            objNs = (CsmNamespace)obj;
        } else if (CsmKindUtilities.isFunction(obj)) {
            objNs = CsmBaseUtilities.getFunctionNamespace((CsmFunction)obj);
        } else if (CsmKindUtilities.isClass(obj)) {
            objNs = CsmBaseUtilities.getClassNamespace((CsmClassifier)obj);
        } else if (CsmKindUtilities.isEnumerator(obj)) {
            objNs = CsmBaseUtilities.getObjectNamespace(((CsmEnumerator)obj).getEnumeration());
        } else if (CsmKindUtilities.isScopeElement(obj) && CsmKindUtilities.isNamespace(scope = ((CsmScopeElement)obj).getScope())) {
            objNs = (CsmNamespace)scope;
        }
        return objNs;
    }

    public static CsmNamespace getFunctionNamespace(CsmFunction fun) {
        if (CsmKindUtilities.isFunctionDefinition(fun)) {
            CsmFunction decl = ((CsmFunctionDefinition)fun).getDeclaration();
            CsmFunction csmFunction = fun = decl != null ? decl : fun;
        }
        if (fun != null) {
            CsmScope scope = fun.getScope();
            if (CsmKindUtilities.isNamespaceDefinition(scope)) {
                CsmNamespace ns = ((CsmNamespaceDefinition)scope).getNamespace();
                return ns;
            }
            if (CsmKindUtilities.isNamespace(scope)) {
                CsmNamespace ns = (CsmNamespace)scope;
                return ns;
            }
            if (CsmKindUtilities.isClass(scope)) {
                return CsmBaseUtilities.getClassNamespace((CsmClass)scope);
            }
        }
        return null;
    }

    public static CsmNamespace getClassNamespace(CsmClassifier cls) {
        CsmScope scope = cls.getScope();
        while (scope != null) {
            if (CsmKindUtilities.isNamespace(scope)) {
                return (CsmNamespace)scope;
            }
            if (!CsmKindUtilities.isScopeElement(scope)) break;
            scope = ((CsmScopeElement)((Object)scope)).getScope();
        }
        return null;
    }

    public static CsmFunction getFunctionDeclaration(CsmFunction fun) {
        assert (fun != null) : "must be not null";
        CsmFunction funDecl = fun;
        if (CsmKindUtilities.isFunctionDefinition(funDecl)) {
            funDecl = ((CsmFunctionDefinition)funDecl).getDeclaration();
        }
        return funDecl;
    }

    public static boolean isFileLocalFunction(CsmFunction fun) {
        CsmFunction decl = CsmBaseUtilities.getFunctionDeclaration(fun);
        return decl != null && CsmKindUtilities.isFile(decl.getScope());
    }

    public static boolean isDeclarationFromUnnamedNamespace(CsmObject obj) {
        if (CsmKindUtilities.isScopeElement(obj)) {
            CsmScope scope = ((CsmScopeElement)obj).getScope();
            if (CsmKindUtilities.isNamespaceDefinition(scope)) {
                return ((CsmNamespaceDefinition)scope).getName().length() == 0;
            }
            if (CsmKindUtilities.isNamespace(scope)) {
                CsmNamespace ns = (CsmNamespace)scope;
                return !ns.isGlobal() && ns.getName().length() == 0;
            }
        }
        return false;
    }

    public static CsmClass getContextClass(CsmOffsetableDeclaration contextDeclaration) {
        if (contextDeclaration == null) {
            return null;
        }
        CsmClass clazz = null;
        if (CsmKindUtilities.isClass(contextDeclaration)) {
            clazz = (CsmClass)contextDeclaration;
        } else if (CsmKindUtilities.isClassMember(contextDeclaration)) {
            clazz = ((CsmMember)contextDeclaration).getContainingClass();
        } else if (CsmKindUtilities.isFunction(contextDeclaration)) {
            clazz = CsmBaseUtilities.getFunctionClass((CsmFunction)contextDeclaration);
        }
        return clazz;
    }

    public static CsmFunction getContextFunction(CsmOffsetableDeclaration contextDeclaration) {
        if (contextDeclaration == null) {
            return null;
        }
        CsmFunction fun = null;
        if (CsmKindUtilities.isFunction(contextDeclaration)) {
            fun = (CsmFunction)contextDeclaration;
        }
        return fun;
    }

    public static CsmClassifier getOriginalClassifier(CsmClassifier orig, CsmFile contextFile) {
        return CsmClassifierResolver.getDefault().getOriginalClassifier(orig, contextFile);
    }

    public static CsmClassifier getClassifier(CsmType type, CsmFile contextFile, boolean resolveTypeChain) {
        return CsmClassifierResolver.getDefault().getTypeClassifier(type, contextFile, 0, resolveTypeChain);
    }
}

