/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionParameterList;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;

public interface CsmFunction
extends CsmOffsetableDeclaration,
CsmScope {
    public CharSequence getDeclarationText();

    public CsmFunctionDefinition getDefinition();

    public CsmFunction getDeclaration();

    public boolean isOperator();

    public OperatorKind getOperatorKind();

    public boolean isInline();

    public CsmType getReturnType();

    public CsmFunctionParameterList getParameterList();

    public Collection<CsmParameter> getParameters();

    public CharSequence getSignature();

    public static enum OperatorKind {
        COMMA(",", true),
        NOT("!", false),
        NOT_EQ("!=", true),
        MOD("%", true),
        MOD_EQ("%=", true),
        AND("&", true),
        ADDRESS("&", false),
        AND_AND("&&", true),
        AND_EQ("&=", true),
        FUN_CALL("()", null),
        CAST("()", false),
        MUL("*", true),
        POINTER("*", false),
        MUL_EQ("*=", true),
        PLUS("+", true),
        PLUS_EQ("+=", true),
        PLUS_UNARY("+", false),
        PLUS_PLUS("++", false),
        MINUS("-", true),
        MINUS_EQ("-=", true),
        MINUS_UNARY("-", false),
        MINUS_MINUS("--", false),
        ARROW("->", true),
        ARROW_MBR("->*", true),
        DIV("/", true),
        DIV_EQ("/=", true),
        LESS("<", true),
        LEFT_SHIFT("<<", true),
        LEFT_SHIFT_EQ("<<=", true),
        LESS_EQ("<=", true),
        EQ("=", true),
        EQ_EQ("==", true),
        GREATER(">", true),
        GREATER_EQ(">=", true),
        RIGHT_SHIFT(">>", true),
        RIGHT_SHIFT_EQ(">>=", true),
        ARRAY("[]", null),
        XOR("^", true),
        XOR_EQ("^=", true),
        OR("|", true),
        OR_EQ("|=", true),
        OR_OR("||", true),
        TILDE("~", false),
        DELETE("delete", null),
        NEW("new", null),
        CONVERSION("", false),
        NONE("", null);

        private final String img;
        private final Boolean binary;
        private static boolean inited;
        private static Map<String, OperatorKind> binaryMap;
        private static Map<String, OperatorKind> unaryMap;

        private OperatorKind(String img, Boolean binary) {
            this.img = img;
            this.binary = binary;
        }

        public String getImage() {
            return this.img;
        }

        public Boolean isBinary() {
            return this.binary;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public static OperatorKind getKindByImage(String image, boolean binary) {
            boolean wasInited = inited;
            if (!wasInited) {
                Class<CsmFunction> clazz = CsmFunction.class;
                // MONITORENTER : org.netbeans.modules.cnd.api.model.CsmFunction.class
                if (!inited) {
                    for (OperatorKind kind : OperatorKind.values()) {
                        String img = kind.getImage();
                        if (img.length() <= 0) continue;
                        if (kind.isBinary() != null && kind.isBinary().booleanValue()) {
                            binaryMap.put(img, kind);
                            continue;
                        }
                        unaryMap.put(img, kind);
                    }
                    inited = true;
                }
                // MONITOREXIT : clazz
            }
            OperatorKind kind = binary ? binaryMap.get(image) : unaryMap.get(image);
            if (kind != null) return kind;
            return NONE;
        }

        static {
            inited = false;
            binaryMap = new HashMap<String, OperatorKind>();
            unaryMap = new HashMap<String, OperatorKind>();
        }
    }
}

