/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.qnavigator.navigator.ItemEvent;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorModel;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorPanelUI;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

public class NavigatorComponent
implements NavigatorPanel,
LookupListener {
    private Lookup.Result<DataObject> doContext;
    private NavigatorPanelUI panelUI;
    private NavigatorModel curModel;
    private DataObject curData;

    public String getDisplayName() {
        return NbBundle.getBundle(NavigatorComponent.class).getString("LBL_members");
    }

    public String getDisplayHint() {
        return NbBundle.getBundle(NavigatorComponent.class).getString("HINT_NavigatorTopComponen");
    }

    public JComponent getComponent() {
        return this.getPanelUI();
    }

    private String getMime(DataObject dobj) {
        FileObject fo = dobj == null ? null : dobj.getPrimaryFile();
        String mime = fo == null ? "" : fo.getMIMEType();
        return mime;
    }

    public synchronized void panelActivated(Lookup context) {
        this.doContext = context.lookupResult(DataObject.class);
        this.doContext.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public synchronized void panelDeactivated() {
        this.doContext.removeLookupListener((LookupListener)this);
        this.doContext = null;
        this.detachFromModel(this.curModel);
        this.curModel = null;
        this.curData = null;
    }

    public synchronized void resultChanged(LookupEvent ev) {
        for (DataObject dob : this.doContext.allInstances()) {
            if (!MIMENames.isFortranOrHeaderOrCppOrC((String)this.getMime(dob))) continue;
            if (dob.equals(this.curData)) break;
            this.detachFromModel(this.curModel);
            this.curData = dob;
            this.setNewContent(dob);
            break;
        }
    }

    public Lookup getLookup() {
        return this.panelUI.getLookup();
    }

    public void busyStart() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getPanelUI().setBusyState(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavigatorComponent.this.getPanelUI().setBusyState(true);
                }
            });
        }
    }

    public void busyEnd() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getPanelUI().setBusyState(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavigatorComponent.this.getPanelUI().setBusyState(false);
                }
            });
        }
    }

    public void newContentReady() {
        this.getPanelUI().newContentReady();
    }

    public void itemsChanged(ItemEvent evt) {
    }

    public void itemsCleared(ItemEvent evt) {
        this.getPanelUI().getContent().repaint();
    }

    private void setNewContent(final DataObject cdo) {
        final NavigatorPanelUI ui = this.getPanelUI();
        CsmModelAccessor.getModel().enqueue(new Runnable(){

            @Override
            public void run() {
                NavigatorComponent.this.setNewContentImpl(cdo, ui);
            }
        }, (CharSequence)"Updating QuickNavigator Content");
    }

    private void setNewContentImpl(DataObject cdo, NavigatorPanelUI ui) {
        this.curModel = new NavigatorModel(cdo, ui, this, this.getMime(cdo));
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this.curModel);
        CsmListeners.getDefault().addModelListener((CsmModelListener)this.curModel);
        ui.getContent().setModel(this.curModel);
        try {
            this.curModel.addBusyListener(this);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.curModel.addNotify();
    }

    private void detachFromModel(NavigatorModel model) {
        if (model != null) {
            CsmListeners.getDefault().removeProgressListener((CsmProgressListener)model);
            CsmListeners.getDefault().removeModelListener((CsmModelListener)model);
            model.removeBusyListener(this);
            model.removeNotify();
        }
    }

    private NavigatorPanelUI getPanelUI() {
        if (this.panelUI == null) {
            this.panelUI = new NavigatorPanelUI();
        }
        return this.panelUI;
    }
}

