/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.util.StringTokenizer;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public abstract class IndexSearchThread
implements Runnable {
    private static final RequestProcessor RP = new RequestProcessor(IndexSearchThread.class.getName(), 1, false, false);
    protected FileObject indexRoot;
    private DocIndexItemConsumer ddiConsumer;
    private final RequestProcessor.Task rpTask;
    private boolean isFinished = false;
    protected boolean caseSensitive;
    protected String lastField = "";
    protected String middleField = "";
    protected String reminder = "";
    private int tokens = 0;
    private String lastAdd = "";
    private String lastDeclaring = "";

    abstract void stopSearch();

    public IndexSearchThread(String toFind, FileObject fo, DocIndexItemConsumer ddiConsumer, boolean caseSensitive) {
        this.ddiConsumer = ddiConsumer;
        this.indexRoot = fo;
        this.caseSensitive = caseSensitive;
        this.rpTask = RP.create((Runnable)this);
        StringTokenizer st = new StringTokenizer(toFind, ".");
        this.tokens = st.countTokens();
        if (this.tokens > 1) {
            if (this.tokens == 2) {
                this.middleField = st.nextToken();
                this.lastField = st.nextToken();
            } else {
                for (int i = 0; i < this.tokens - 2; ++i) {
                    this.reminder = this.reminder + st.nextToken();
                    if (i + 1 >= this.tokens - 2) continue;
                    this.reminder = this.reminder + '.';
                }
                this.middleField = st.nextToken();
                this.lastField = st.nextToken();
            }
        } else {
            this.lastField = toFind;
        }
        if (!caseSensitive) {
            this.reminder = this.reminder.toUpperCase();
            this.middleField = this.middleField.toUpperCase();
            this.lastField = this.lastField.toUpperCase();
        }
    }

    protected synchronized void insertDocIndexItem(DocIndexItem dii) {
        String diiField = dii.getField();
        String diiDeclaringClass = dii.getDeclaringClass();
        String diiPackage = dii.getPackage();
        if (!this.caseSensitive) {
            diiField = diiField.toUpperCase();
            diiDeclaringClass = diiDeclaringClass.toUpperCase();
            diiPackage = diiPackage.toUpperCase();
        }
        if (this.tokens < 2) {
            if (diiField.startsWith(this.lastField)) {
                if (!this.lastAdd.equals(diiField) || !this.lastDeclaring.equals(diiDeclaringClass)) {
                    this.ddiConsumer.addDocIndexItem(dii);
                    this.lastAdd = diiField;
                    this.lastDeclaring = diiDeclaringClass;
                }
            } else if (diiDeclaringClass.startsWith(this.lastField) && dii.getIconIndex() == 2) {
                if (!this.lastAdd.equals(diiDeclaringClass)) {
                    this.ddiConsumer.addDocIndexItem(dii);
                    this.lastAdd = diiDeclaringClass;
                }
            } else if (diiPackage.startsWith(this.lastField + '.') && dii.getIconIndex() == 1 && !this.lastAdd.equals(diiPackage)) {
                this.ddiConsumer.addDocIndexItem(dii);
                this.lastAdd = diiPackage;
            }
        } else if (this.tokens == 2) {
            if (diiField.startsWith(this.lastField) && diiDeclaringClass.equals(this.middleField)) {
                this.ddiConsumer.addDocIndexItem(dii);
            } else if (diiPackage.startsWith(this.middleField) && diiDeclaringClass.equals(this.lastField)) {
                this.ddiConsumer.addDocIndexItem(dii);
            } else if (diiPackage.startsWith(this.middleField + '.' + this.lastField) && dii.getIconIndex() == 1) {
                this.ddiConsumer.addDocIndexItem(dii);
            }
        } else if (diiField.startsWith(this.lastField) && diiDeclaringClass.equals(this.middleField) && diiPackage.startsWith(this.reminder)) {
            this.ddiConsumer.addDocIndexItem(dii);
        } else if (diiDeclaringClass.startsWith(this.lastField) && diiPackage.equals(this.reminder + '.' + this.middleField + '.')) {
            this.ddiConsumer.addDocIndexItem(dii);
        } else if (diiPackage.startsWith(this.reminder + '.' + this.middleField + '.' + this.lastField) && dii.getIconIndex() == 1) {
            this.ddiConsumer.addDocIndexItem(dii);
        }
    }

    public void go() {
        this.rpTask.schedule(0);
        this.rpTask.waitFinished();
    }

    public void finish() {
        if (!this.rpTask.isFinished() && !this.rpTask.cancel()) {
            this.stopSearch();
        }
        this.taskFinished();
    }

    public void taskFinished() {
        if (!this.isFinished) {
            this.isFinished = true;
            this.ddiConsumer.indexSearchThreadFinished(this);
        }
    }

    public static interface DocIndexItemConsumer {
        public void addDocIndexItem(DocIndexItem var1);

        public void indexSearchThreadFinished(IndexSearchThread var1);
    }
}

