/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

final class AddTagFix
implements Fix,
CancellableTask<WorkingCopy> {
    private final ElementHandle methodHandle;
    private final String paramName;
    private final int index;
    private final FileObject file;
    private final SourceVersion spec;
    private final String descKey;
    private final Kind kind;
    private Position insertPosition;
    String insertJavadoc;
    private int openOffset;
    Document doc;

    private AddTagFix(ElementHandle elementHandle, String string, int n, FileObject fileObject, SourceVersion sourceVersion, String string2, Kind kind) {
        this.methodHandle = elementHandle;
        this.paramName = string;
        this.index = n;
        this.file = fileObject;
        this.spec = sourceVersion;
        this.descKey = string2;
        this.kind = kind;
    }

    public static Fix createAddParamTagFix(ExecutableElement executableElement, String string, FileObject fileObject, SourceVersion sourceVersion) {
        return new AddTagFix(ElementHandle.create((Element)executableElement), string, -1, fileObject, sourceVersion, "MISSING_PARAM_HINT", Kind.PARAM);
    }

    public static Fix createAddTypeParamTagFix(Element element, String string, FileObject fileObject, SourceVersion sourceVersion) {
        return new AddTagFix(ElementHandle.create((Element)element), string, -1, fileObject, sourceVersion, "MISSING_TYPEPARAM_HINT", Kind.TYPEPARAM);
    }

    public static Fix createAddReturnTagFix(ExecutableElement executableElement, FileObject fileObject, SourceVersion sourceVersion) {
        return new AddTagFix(ElementHandle.create((Element)executableElement), "", -1, fileObject, sourceVersion, "MISSING_RETURN_HINT", Kind.RETURN);
    }

    public static Fix createAddThrowsTagFix(ExecutableElement executableElement, String string, int n, FileObject fileObject, SourceVersion sourceVersion) {
        return new AddTagFix(ElementHandle.create((Element)executableElement), string, n, fileObject, sourceVersion, "MISSING_THROWS_HINT", Kind.THROWS);
    }

    public static Fix createAddDeprecatedTagFix(Element element, FileObject fileObject, SourceVersion sourceVersion) {
        return new AddTagFix(ElementHandle.create((Element)element), "", -1, fileObject, sourceVersion, "MISSING_DEPRECATED_HINT", Kind.DEPRECATED);
    }

    public String getText() {
        return NbBundle.getMessage(AddTagFix.class, (String)this.descKey, (Object)this.paramName);
    }

    public ChangeInfo implement() {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
        try {
            javaSource.runModificationTask((Task)this).commit();
            if (this.doc == null || this.insertPosition == null || this.insertJavadoc == null) {
                return null;
            }
            this.insertJavadoc();
            JavadocUtilities.open(this.file, this.openOffset);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(AddTagFix.class.getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
        }
        catch (IOException iOException) {
            Logger.getLogger(AddTagFix.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return null;
    }

    public void run(final WorkingCopy workingCopy) throws Exception {
        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
        final Element element = this.methodHandle.resolve((CompilationInfo)workingCopy);
        if (element == null) {
            return;
        }
        final Doc doc = workingCopy.getElementUtilities().javaDocFor(element);
        this.doc = workingCopy.getDocument();
        if (this.doc == null) {
            return;
        }
        NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    AddTagFix.this.computeInsertPositionAndJavadoc((CompilationInfo)workingCopy, element, doc);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(AddTagFix.class.getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
                }
            }
        });
    }

    private void computeInsertPositionAndJavadoc(CompilationInfo compilationInfo, Element element, Doc doc) throws BadLocationException {
        boolean[] blArray = new boolean[1];
        switch (this.kind) {
            case PARAM: {
                this.insertPosition = this.getParamInsertPosition(compilationInfo, this.doc, (ExecutableElement)element, (ExecutableMemberDoc)doc, blArray);
                this.insertJavadoc = "@param " + this.paramName + " ";
                break;
            }
            case TYPEPARAM: {
                this.insertPosition = this.getTypeParamInsertPosition(compilationInfo, this.doc, element, doc, blArray);
                this.insertJavadoc = "@param <" + this.paramName + "> ";
                break;
            }
            case RETURN: {
                this.insertPosition = this.getReturnInsertPosition(compilationInfo, this.doc, doc, blArray);
                this.insertJavadoc = "@return ";
                break;
            }
            case THROWS: {
                this.insertPosition = this.getThrowsInsertPosition(compilationInfo, this.doc, (ExecutableMemberDoc)doc, blArray);
                this.insertJavadoc = "@throws " + this.paramName + " ";
                break;
            }
            case DEPRECATED: {
                this.insertPosition = this.getDeprecatedInsertPosition(compilationInfo, this.doc, doc, blArray);
                this.insertJavadoc = "@deprecated ";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (this.insertPosition == null) {
            return;
        }
        Position[] positionArray = JavadocUtilities.findDocBounds(compilationInfo, this.doc, doc);
        int n = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)positionArray[0].getOffset());
        int n2 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)positionArray[1].getOffset());
        int n3 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)this.insertPosition.getOffset());
        if (n == n3 && n3 == n2) {
            this.insertJavadoc = '\n' + this.insertJavadoc;
            this.openOffset = this.insertJavadoc.length();
            this.insertJavadoc = this.insertJavadoc + '\n';
        } else if (n3 == n2) {
            if (blArray[0] && !this.isEmptyLine(this.doc, this.insertPosition.getOffset())) {
                this.insertJavadoc = '\n' + this.insertJavadoc;
            }
            this.openOffset = this.insertJavadoc.length();
            this.insertJavadoc = this.insertJavadoc + '\n';
        } else if (n3 == n) {
            this.insertJavadoc = '\n' + this.insertJavadoc;
            this.openOffset = this.insertJavadoc.length();
            if (!blArray[0]) {
                this.insertJavadoc = this.insertJavadoc + '\n';
            }
        } else if (blArray[0]) {
            this.insertJavadoc = '\n' + this.insertJavadoc;
            this.openOffset = this.insertJavadoc.length();
        } else {
            this.openOffset = this.insertJavadoc.length();
            this.insertJavadoc = this.insertJavadoc + '\n';
        }
    }

    private boolean isEmptyLine(Document document, int n) throws BadLocationException {
        char c;
        CharSequence charSequence = (CharSequence)document.getProperty(CharSequence.class);
        if (charSequence == null) {
            charSequence = document.getText(0, n + 1);
        }
        boolean bl = true;
        int n2 = 0;
        for (int i = n; i >= 0 && (c = charSequence.charAt(i)) != '\n'; --i) {
            if (c == '*') {
                if (n2 > 0) {
                    bl = false;
                    break;
                }
                ++n2;
                continue;
            }
            if (Character.isSpaceChar(c)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertJavadoc() throws BadLocationException {
        final Indent indent = Indent.get((Document)this.doc);
        try {
            indent.lock();
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        int n = AddTagFix.this.insertPosition.getOffset();
                        int n2 = n + AddTagFix.this.insertJavadoc.length() + 1;
                        AddTagFix.this.doc.insertString(n, AddTagFix.this.insertJavadoc, null);
                        Position position = AddTagFix.this.doc.createPosition(n + AddTagFix.this.openOffset - 1);
                        indent.reindent(n, n2);
                        AddTagFix.this.doc.insertString(position.getOffset(), " ", null);
                        AddTagFix.this.openOffset = position.getOffset();
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.getLogger(AddTagFix.class.getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
                    }
                }
            });
        }
        finally {
            indent.unlock();
        }
    }

    public void cancel() {
    }

    private Position getDeprecatedInsertPosition(CompilationInfo compilationInfo, Document document, Doc doc, boolean[] blArray) throws BadLocationException {
        return this.getTagInsertPosition(compilationInfo, document, doc, null, false, blArray);
    }

    private Position getTypeParamInsertPosition(CompilationInfo compilationInfo, Document document, Element element, Doc doc, boolean[] blArray) throws BadLocationException {
        ParamTag[] paramTagArray;
        ElementKind elementKind = element.getKind();
        if (elementKind.isClass() || elementKind.isInterface()) {
            paramTagArray = ((ClassDoc)doc).typeParamTags();
        } else if (elementKind == ElementKind.METHOD || elementKind == ElementKind.CONSTRUCTOR) {
            paramTagArray = ((ExecutableMemberDoc)doc).typeParamTags();
        } else {
            throw new IllegalStateException(element + ", " + (Object)((Object)elementKind) + "\n" + doc.getRawCommentText());
        }
        ParamTag paramTag = null;
        boolean bl = true;
        if (paramTagArray.length > 0) {
            List<? extends TypeParameterElement> list = elementKind == ElementKind.METHOD || elementKind == ElementKind.CONSTRUCTOR ? ((ExecutableElement)element).getTypeParameters() : ((TypeElement)element).getTypeParameters();
            int n = this.findParamIndex(list, this.paramName);
            paramTag = n < paramTagArray.length ? paramTagArray[n] : paramTagArray[paramTagArray.length - 1];
            bl = n < paramTagArray.length;
        } else {
            paramTagArray = doc.tags();
            if (paramTagArray.length > 0) {
                paramTag = paramTagArray[0];
            }
        }
        return this.getTagInsertPosition(compilationInfo, document, doc, (Tag)paramTag, bl, blArray);
    }

    private Position getThrowsInsertPosition(CompilationInfo compilationInfo, Document document, ExecutableMemberDoc executableMemberDoc, boolean[] blArray) throws BadLocationException {
        ThrowsTag[] throwsTagArray = executableMemberDoc.throwsTags();
        ThrowsTag throwsTag = null;
        boolean bl = true;
        if (throwsTagArray.length > 0) {
            throwsTag = this.index < throwsTagArray.length ? throwsTagArray[this.index] : throwsTagArray[throwsTagArray.length - 1];
            bl = this.index < throwsTagArray.length;
        } else {
            throwsTagArray = executableMemberDoc.tags("@return");
            if (throwsTagArray.length == 0) {
                throwsTagArray = executableMemberDoc.tags("@param");
            }
            if (throwsTagArray.length == 0) {
                throwsTagArray = executableMemberDoc.tags();
            } else {
                bl = false;
            }
            if (throwsTagArray.length > 0) {
                throwsTag = throwsTagArray[throwsTagArray.length - 1];
            }
        }
        return this.getTagInsertPosition(compilationInfo, document, (Doc)executableMemberDoc, (Tag)throwsTag, bl, blArray);
    }

    private Position getReturnInsertPosition(CompilationInfo compilationInfo, Document document, Doc doc, boolean[] blArray) throws BadLocationException {
        Tag[] tagArray = doc.tags("@param");
        Tag tag = null;
        boolean bl = true;
        if (tagArray.length > 0) {
            tag = tagArray[tagArray.length - 1];
            bl = false;
        } else {
            tagArray = doc.tags();
            if (tagArray.length > 0) {
                tag = tagArray[0];
            }
        }
        return this.getTagInsertPosition(compilationInfo, document, doc, tag, bl, blArray);
    }

    private Position getParamInsertPosition(CompilationInfo compilationInfo, Document document, ExecutableElement executableElement, ExecutableMemberDoc executableMemberDoc, boolean[] blArray) throws BadLocationException {
        ParamTag[] paramTagArray = executableMemberDoc.paramTags();
        ParamTag paramTag = null;
        boolean bl = true;
        if (paramTagArray.length > 0) {
            int n = this.findParamIndex(executableElement.getParameters(), this.paramName);
            paramTag = n < paramTagArray.length ? paramTagArray[n] : paramTagArray[paramTagArray.length - 1];
            bl = n < paramTagArray.length;
        } else {
            paramTagArray = executableMemberDoc.typeParamTags();
            if (paramTagArray.length > 0) {
                paramTag = paramTagArray[paramTagArray.length - 1];
                bl = false;
            } else {
                paramTagArray = executableMemberDoc.tags();
                if (paramTagArray.length > 0) {
                    paramTag = paramTagArray[0];
                }
            }
        }
        return this.getTagInsertPosition(compilationInfo, document, (Doc)executableMemberDoc, (Tag)paramTag, bl, blArray);
    }

    private Position getTagInsertPosition(CompilationInfo compilationInfo, Document document, Doc doc, Tag tag, boolean bl, boolean[] blArray) throws BadLocationException {
        Position[] positionArray = null;
        if (tag != null) {
            positionArray = JavadocUtilities.findTagBounds(compilationInfo, document, tag, blArray);
            if (bl) {
                blArray[0] = false;
            }
        } else {
            positionArray = JavadocUtilities.findLastTokenBounds(compilationInfo, document, doc);
            bl = false;
            blArray[0] = true;
        }
        return positionArray == null ? null : (bl ? positionArray[0] : positionArray[1]);
    }

    private int findParamIndex(List<? extends Element> list, String string) {
        int n = 0;
        for (Element element : list) {
            if (string.contentEquals(element.getSimpleName())) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException("Unknown param: " + string);
    }

    private static enum Kind {
        PARAM,
        RETURN,
        THROWS,
        TYPEPARAM,
        DEPRECATED;

    }
}

