/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.spi;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.attach.spi.ModificationException;
import org.netbeans.modules.profiler.attach.spi.RunException;

public interface IntegrationProvider {
    public IntegrationHints getAfterInstallationHints(AttachSettings var1, boolean var2);

    public IntegrationHints getIntegrationReview(AttachSettings var1);

    public IntegrationHints getModificationHints(AttachSettings var1);

    public void setTargetJava(String var1);

    public String getTargetJava();

    public void setTargetJavaHome(String var1);

    public String getTargetJavaHome();

    public String getTitle();

    public void modify(AttachSettings var1) throws ModificationException;

    public void run(AttachSettings var1) throws RunException;

    public boolean supportsAutomation();

    public boolean supportsDirect();

    public boolean supportsDynamic();

    public boolean supportsLocal();

    public boolean supportsManual();

    public boolean supportsRemote();

    public static class IntegrationHints {
        private List hints;
        private List steps = new ArrayList(10);
        private List warnings;
        private boolean warningsFirst = true;

        public IntegrationHints() {
            this.hints = new ArrayList(10);
            this.warnings = new ArrayList(10);
        }

        public List getHints() {
            return this.copyLock(this.hints);
        }

        public List getSteps() {
            return this.copyLock(this.steps);
        }

        public List getWarnings() {
            return this.copyLock(this.warnings);
        }

        public void setWarningsFirst(boolean warningsFirst) {
            this.warningsFirst = warningsFirst;
        }

        public boolean isWarningsFirst() {
            return this.warningsFirst;
        }

        public void addHint(String hint) {
            this.hints.add(hint);
        }

        public void addStep(String step) {
            this.steps.add(step);
        }

        public void addStep(int stepIndex, String step) {
            this.steps.add(stepIndex, step);
        }

        public void addWarning(String warning) {
            this.warnings.add(warning);
        }

        public void clear() {
            this.hints.clear();
            this.steps.clear();
            this.warnings.clear();
        }

        public void removeHint(String hint) {
            this.hints.remove(hint);
        }

        public void removeStep(String step) {
            this.steps.remove(step);
        }

        public void removeWarning(String warning) {
            this.warnings.remove(warning);
        }

        private List copyLock(List source) {
            ArrayList immutable = new ArrayList();
            immutable.addAll(source);
            return immutable;
        }
    }
}

