/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.deprecated.pre61settings;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.modules.editor.deprecated.pre61settings.OrgNbEditorAccessor;
import org.netbeans.modules.editor.lib.KitsTracker;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.netbeans.modules.editor.settings.storage.spi.StorageFilter;
import org.netbeans.modules.editor.settings.storage.spi.TypedValue;

public final class EditorPreferencesInjector
extends StorageFilter<String, TypedValue>
implements PropertyChangeListener,
SettingsChangeListener {
    private static final Logger LOG = Logger.getLogger(EditorPreferencesInjector.class.getName());
    private static final Map<MimePath, Map<String, Object>> COMPLEX = new WeakHashMap<MimePath, Map<String, Object>>();
    private final ThreadLocal<Map> currentSettingsMap = new ThreadLocal();
    private final ThreadLocal<Boolean> ignoreInitializerChanges = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public EditorPreferencesInjector() {
        super("Preferences");
        OrgNbEditorAccessor.get().Settings_addPropertyChangeListener(this);
        OrgNbEditorAccessor.get().Settings_addSettingsChangeListener(this);
    }

    public void capturedSetValue(Class kitClass, String settingName, Object value) {
        Map map = this.currentSettingsMap.get();
        assert (map != null) : "The current settings map should not be null";
        map.put(settingName, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLoad(Map<String, TypedValue> preferences, MimePath mimePath, String profile, boolean defaults) {
        Class kitClass = null;
        if (mimePath.size() == 0) {
            kitClass = BaseKit.class;
        } else if (mimePath.size() == 1) {
            this.ignoreInitializerChanges.set(true);
            try {
                kitClass = KitsTracker.getInstance().findKitClass(mimePath.getPath());
            }
            finally {
                this.ignoreInitializerChanges.remove();
            }
        }
        if (kitClass == null) {
            return;
        }
        HashMap map = new HashMap();
        this.currentSettingsMap.set(map);
        OrgNbEditorAccessor.get().Settings_interceptSetValue(this);
        try {
            List[] lists = OrgNbEditorAccessor.get().Settings_getListsOfInitializers();
            for (int i = 0; i < lists.length; ++i) {
                for (Settings.Initializer initializer : lists[i]) {
                    try {
                        initializer.updateSettingsMap(kitClass, map);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, null, t);
                    }
                }
            }
        }
        finally {
            OrgNbEditorAccessor.get().Settings_interceptSetValue(null);
            this.currentSettingsMap.remove();
        }
        HashMap complexValueSettings = new HashMap();
        for (Object key : map.keySet()) {
            if (!(key instanceof String)) continue;
            String settingName = (String)key;
            if (preferences.containsKey(settingName)) {
                TypedValue v = preferences.get(settingName);
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Ignoring '" + settingName + "'=['" + v.getValue() + "', " + v.getJavaType() + "], because it's already defined");
                continue;
            }
            Object value = map.get(settingName);
            if (value == null) continue;
            if (value instanceof Boolean) {
                preferences.put(settingName, new TypedValue(((Boolean)value).toString(), Boolean.class.getName()));
                continue;
            }
            if (value instanceof Integer) {
                preferences.put(settingName, new TypedValue(((Integer)value).toString(), Integer.class.getName()));
                continue;
            }
            if (value instanceof Long) {
                preferences.put(settingName, new TypedValue(((Long)value).toString(), Long.class.getName()));
                continue;
            }
            if (value instanceof Float) {
                preferences.put(settingName, new TypedValue(((Float)value).toString(), Float.class.getName()));
                continue;
            }
            if (value instanceof Double) {
                preferences.put(settingName, new TypedValue(((Double)value).toString(), Double.class.getName()));
                continue;
            }
            if (value instanceof Insets) {
                preferences.put(settingName, new TypedValue(SettingsConversions.insetsToString((Insets)((Insets)value)), Insets.class.getName()));
                continue;
            }
            if (value instanceof Dimension) {
                preferences.put(settingName, new TypedValue(SettingsConversions.dimensionToString((Dimension)((Dimension)value)), Dimension.class.getName()));
                continue;
            }
            if (value instanceof Color) {
                preferences.put(settingName, new TypedValue(SettingsConversions.color2String((Color)((Color)value)), Color.class.getName()));
                continue;
            }
            if (value instanceof String) {
                preferences.put(settingName, new TypedValue((String)value, String.class.getName()));
                continue;
            }
            complexValueSettings.put(settingName, value);
            preferences.put(settingName, new TypedValue(this.getClass().getName() + ".getComplexSettingValue", "methodvalue"));
        }
        Map<MimePath, Map<String, Object>> map2 = COMPLEX;
        synchronized (map2) {
            if (COMPLEX.containsKey(mimePath) || !complexValueSettings.isEmpty()) {
                if (complexValueSettings.isEmpty()) {
                    COMPLEX.remove(mimePath);
                } else {
                    COMPLEX.put(mimePath, complexValueSettings);
                }
            }
        }
    }

    public void beforeSave(Map<String, TypedValue> map, MimePath mimePath, String profile, boolean defaults) {
        Iterator<String> i = map.keySet().iterator();
        while (i.hasNext()) {
            String settingName = i.next();
            TypedValue value = map.get(settingName);
            if (value.getJavaType() == null || !value.getJavaType().equals("methodvalue") || !value.getValue().equals(this.getClass().getName() + ".getComplexSettingValue")) continue;
            i.remove();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ((evt == null || "initializers".equals(evt.getPropertyName())) && !this.ignoreInitializerChanges.get().booleanValue()) {
            LOG.fine("Settings.Initializers changed");
            this.notifyChanges();
        }
    }

    @Override
    public void settingsChange(SettingsChangeEvent evt) {
        if (OrgNbEditorAccessor.get().isResetValuesEvent()) {
            LOG.fine("settingsChange(" + evt.getSettingName() + ")");
            this.notifyChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getComplexSettingValue(MimePath mimePath, String settingName) {
        List paths = null;
        if (mimePath.size() > 0) {
            try {
                List ret;
                Method m = MimePath.class.getDeclaredMethod("getInheritedPaths", String.class, String.class);
                m.setAccessible(true);
                paths = ret = (List)m.invoke((Object)mimePath, new Object[]{null, null});
                assert (paths.size() > 1) : "Wrong getInheritedPaths result size: " + paths.size();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Can't call org.netbeans.api.editor.mimelookup.MimePath.getInheritedPaths method.", e);
            }
        }
        if (paths == null) {
            paths = Collections.singletonList(mimePath.getPath());
        }
        Map<MimePath, Map<String, Object>> map = COMPLEX;
        synchronized (map) {
            ArrayList listValue = null;
            for (String path : paths) {
                Object value;
                Map<String, Object> settings = COMPLEX.get(MimePath.parse((String)path));
                if (settings == null || (value = settings.get(settingName)) == null) continue;
                if (value instanceof List) {
                    if (listValue == null) {
                        listValue = new ArrayList((List)value);
                        continue;
                    }
                    listValue.addAll((List)value);
                    continue;
                }
                if (listValue != null) continue;
                return value;
            }
            return listValue == null ? null : listValue;
        }
    }
}

