/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.Preferences;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.imports.ComputeImports;
import org.netbeans.modules.java.editor.imports.FixDuplicateImportStmts;
import org.netbeans.modules.java.editor.semantic.SemanticHighlighter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class JavaFixAllImports {
    private static final String PREFS_KEY = JavaFixAllImports.class.getName();
    private static final String KEY_REMOVE_UNUSED_IMPORTS = "removeUnusedImports";
    private static final JavaFixAllImports INSTANCE = new JavaFixAllImports();
    private static final RequestProcessor WORKER = new RequestProcessor(JavaFixAllImports.class.getName(), 1);

    public static JavaFixAllImports getDefault() {
        return INSTANCE;
    }

    private JavaFixAllImports() {
    }

    public void fixAllImports(FileObject fileObject) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        final JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final AtomicReference atomicReference = new AtomicReference();
        Task<WorkingCopy> task = new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) {
                try {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    if (atomicBoolean.get()) {
                        return;
                    }
                    ImportData importData = JavaFixAllImports.computeImports((CompilationInfo)workingCopy);
                    if (atomicBoolean.get()) {
                        return;
                    }
                    if (importData.shouldShowImportsPanel) {
                        if (!atomicBoolean.get()) {
                            atomicReference.set(importData);
                        }
                    } else {
                        Preferences preferences = NbPreferences.forModule(JavaFixAllImports.class).node(PREFS_KEY);
                        boolean bl = preferences.getBoolean(JavaFixAllImports.KEY_REMOVE_UNUSED_IMPORTS, true);
                        JavaFixAllImports.performFixImports(workingCopy, importData, importData.defaults, bl);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        };
        if (javaSource == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaFixAllImports.class, (String)"MSG_CannotFixImports"));
        } else {
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable((Task)task){
                final /* synthetic */ Task val$task;
                {
                    this.val$task = task;
                }

                @Override
                public void run() {
                    try {
                        javaSource.runModificationTask(this.val$task).commit();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }, (String)"Fix All Imports", (AtomicBoolean)atomicBoolean, (boolean)false);
            if (atomicReference.get() != null && !atomicBoolean.get()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JavaFixAllImports.showFixImportsDialog(javaSource, (ImportData)atomicReference.get());
                    }
                });
            }
        }
    }

    private static List<TreePathHandle> getImportsFromSamePackage(WorkingCopy workingCopy) {
        ImportVisitor importVisitor = new ImportVisitor((CompilationInfo)workingCopy);
        importVisitor.scan(workingCopy.getCompilationUnit(), null);
        return importVisitor.getImports();
    }

    public static CompilationUnitTree addImports(CompilationUnitTree compilationUnitTree, List<String> list, TreeMaker treeMaker, boolean bl) {
        String string;
        list = new ArrayList<String>(list);
        Collections.sort(list);
        ArrayList<? extends ImportTree> arrayList = new ArrayList<ImportTree>(compilationUnitTree.getImports());
        int n = list.size() - 1;
        int n2 = arrayList.size() - 1;
        while (n >= 0 && n2 >= 0) {
            string = list.get(n);
            boolean bl2 = bl ^ ((ImportTree)arrayList.get(n2)).isStatic();
            while (n2 >= 0 && (bl2 || ((ImportTree)arrayList.get(n2)).getQualifiedIdentifier().toString().compareTo(string) > 0)) {
                --n2;
            }
            if (n2 < 0) continue;
            arrayList.add(n2 + 1, treeMaker.Import((Tree)treeMaker.Identifier((CharSequence)string), bl));
            --n;
        }
        while (n >= 0) {
            string = list.get(n);
            arrayList.add(0, treeMaker.Import((Tree)treeMaker.Identifier((CharSequence)string), bl));
            --n;
        }
        return treeMaker.CompilationUnit(compilationUnitTree.getPackageName(), arrayList, compilationUnitTree.getTypeDecls(), compilationUnitTree.getSourceFile());
    }

    /*
     * WARNING - void declaration
     */
    private static void performFixImports(WorkingCopy workingCopy, ImportData importData, String[] stringArray, boolean bl) throws IOException {
        void var5_7;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            String string2 = importData.displayName2FQN.get(string);
            object = importData.fqn2TE.get(string2 != null ? string2 : string);
            if (object == null) continue;
            arrayList.add(object.getQualifiedName().toString());
        }
        CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
        int n = 0;
        if (bl) {
            List<TreePathHandle> list = SemanticHighlighter.computeUnusedImports((CompilationInfo)workingCopy);
            list.addAll(JavaFixAllImports.getImportsFromSamePackage(workingCopy));
            n = !list.isEmpty() ? 1 : 0;
            for (TreePathHandle treePathHandle : list) {
                object = treePathHandle.resolve((CompilationInfo)workingCopy);
                assert (object != null);
                CompilationUnitTree compilationUnitTree2 = workingCopy.getTreeMaker().removeCompUnitImport((CompilationUnitTree)var5_7, (ImportTree)((TreePath)object).getLeaf());
            }
        }
        CompilationUnitTree compilationUnitTree3 = JavaFixAllImports.addImports((CompilationUnitTree)var5_7, arrayList, workingCopy.getTreeMaker(), false);
        workingCopy.rewrite((Tree)workingCopy.getCompilationUnit(), (Tree)compilationUnitTree3);
        if (!importData.shouldShowImportsPanel) {
            String string;
            if (arrayList.isEmpty() && n == 0) {
                Toolkit.getDefaultToolkit().beep();
                string = NbBundle.getMessage(JavaFixAllImports.class, (String)"MSG_NothingToFix");
            } else {
                string = arrayList.isEmpty() && n != 0 ? NbBundle.getMessage(JavaFixAllImports.class, (String)"MSG_UnusedImportsRemoved") : NbBundle.getMessage(JavaFixAllImports.class, (String)"MSG_ImportsFixed");
            }
            StatusDisplayer.getDefault().setStatusText(string);
        }
    }

    private static ImportData computeImports(CompilationInfo compilationInfo) {
        ComputeImports.Pair<Map<String, List<TypeElement>>, Map<String, List<TypeElement>>> pair = new ComputeImports().computeCandidates(compilationInfo);
        Map map = (Map)pair.a;
        Map map2 = (Map)pair.b;
        int n = map2.size();
        ImportData importData = new ImportData(n);
        int n2 = 0;
        boolean bl = false;
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            importData.names[n2] = string = (String)iterator.next();
            List list = (List)map2.get(string);
            List list2 = (List)map.get(string);
            bl |= list.size() > 1;
            if (!list.isEmpty()) {
                importData.variants[n2] = new String[list.size()];
                importData.icons[n2] = new Icon[importData.variants[n2].length];
                int n3 = -1;
                int n4 = Integer.MAX_VALUE;
                for (TypeElement typeElement : list2) {
                    importData.variants[n2][++n3] = typeElement.getQualifiedName().toString();
                    importData.icons[n2][n3] = ElementIcons.getElementIcon((ElementKind)typeElement.getKind(), typeElement.getModifiers());
                    int n5 = Utilities.getImportanceLevel(importData.variants[n2][n3]);
                    if (n5 < n4) {
                        importData.defaults[n2] = importData.variants[n2][n3];
                        n4 = n5;
                    }
                    importData.fqn2TE.put(typeElement.getQualifiedName().toString(), typeElement);
                }
                for (TypeElement typeElement : list) {
                    if (list2.contains(typeElement)) continue;
                    String string2 = typeElement.getQualifiedName().toString();
                    String string3 = "<html><font color='#808080'><s>" + string2;
                    importData.variants[n2][++n3] = string3;
                    int n6 = Utilities.getImportanceLevel(string2);
                    if (n6 < n4) {
                        importData.defaults[n2] = importData.variants[n2][n3];
                        n4 = n6;
                    }
                    importData.fqn2TE.put(string2, typeElement);
                    importData.displayName2FQN.put(string3, string2);
                }
            } else {
                importData.variants[n2] = new String[1];
                importData.variants[n2][0] = NbBundle.getMessage(JavaFixAllImports.class, (String)"FixDupImportStmts_CannotResolve");
                importData.defaults[n2] = importData.variants[n2][0];
                importData.icons[n2] = new Icon[1];
                importData.icons[n2][0] = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/editor/resources/error-glyph.gif", (boolean)false);
            }
            ++n2;
        }
        importData.shouldShowImportsPanel = bl;
        return importData;
    }

    private static void showFixImportsDialog(final JavaSource javaSource, final ImportData importData) {
        final Preferences preferences = NbPreferences.forModule(JavaFixAllImports.class).node(PREFS_KEY);
        final FixDuplicateImportStmts fixDuplicateImportStmts = new FixDuplicateImportStmts();
        fixDuplicateImportStmts.initPanel(importData.names, importData.variants, importData.icons, importData.defaults, preferences.getBoolean(KEY_REMOVE_UNUSED_IMPORTS, true));
        final JButton jButton = new JButton("OK");
        final JButton jButton2 = new JButton("Cancel");
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)fixDuplicateImportStmts, NbBundle.getMessage(JavaFixAllImports.class, (String)"FixDupImportStmts_Title"), true, new Object[]{jButton, jButton2}, (Object)jButton, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        }, true);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton.setEnabled(false);
                final String[] stringArray = fixDuplicateImportStmts.getSelections();
                final boolean bl = fixDuplicateImportStmts.getRemoveUnusedImports();
                WORKER.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                                public void run(WorkingCopy workingCopy) throws Exception {
                                    jButton2.setEnabled(false);
                                    ((JDialog)dialog).setDefaultCloseOperation(0);
                                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                                    if (atomicBoolean.get()) {
                                        return;
                                    }
                                    JavaFixAllImports.performFixImports(workingCopy, importData, stringArray, bl);
                                }
                            }).commit();
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                        preferences.putBoolean(JavaFixAllImports.KEY_REMOVE_UNUSED_IMPORTS, bl);
                        dialog.setVisible(false);
                    }
                });
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                atomicBoolean.set(true);
                dialog.setVisible(false);
            }
        });
        dialog.setVisible(true);
        dialog.dispose();
    }

    static final class ImportData {
        public final String[] names;
        public final String[][] variants;
        public final Icon[][] icons;
        public final String[] defaults;
        public final Map<String, TypeElement> fqn2TE;
        public final Map<String, String> displayName2FQN;
        public boolean shouldShowImportsPanel;

        public ImportData(int n) {
            this.names = new String[n];
            this.variants = new String[n][];
            this.icons = new Icon[n][];
            this.defaults = new String[n];
            this.fqn2TE = new HashMap<String, TypeElement>();
            this.displayName2FQN = new HashMap<String, String>();
        }
    }

    private static class ImportVisitor
    extends TreePathScanner {
        private CompilationInfo info;
        private String currentPackage;
        private List<TreePathHandle> imports;

        private ImportVisitor(CompilationInfo compilationInfo) {
            this.info = compilationInfo;
            ExpressionTree expressionTree = compilationInfo.getCompilationUnit().getPackageName();
            this.currentPackage = expressionTree != null ? expressionTree.toString() : "";
            this.imports = new ArrayList<TreePathHandle>();
        }

        @Override
        public Object visitImport(ImportTree importTree, Object object) {
            ExpressionTree expressionTree;
            if (importTree.getQualifiedIdentifier().getKind() == Tree.Kind.MEMBER_SELECT && (expressionTree = ((MemberSelectTree)importTree.getQualifiedIdentifier()).getExpression()).toString().equals(this.currentPackage)) {
                this.imports.add(TreePathHandle.create((TreePath)this.getCurrentPath(), (CompilationInfo)this.info));
            }
            super.visitImport(importTree, null);
            return null;
        }

        List<TreePathHandle> getImports() {
            return this.imports;
        }
    }
}

