/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Utilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class InsertSemicolonAction
extends BaseAction {
    private final boolean withNewline;
    private final char what;

    protected InsertSemicolonAction(String name, char what, boolean withNewline) {
        super(name);
        this.withNewline = withNewline;
        this.what = what;
        this.putValue("ShortDescription", NbBundle.getMessage(InsertSemicolonAction.class, (String)name));
    }

    public InsertSemicolonAction(String name, boolean withNewline) {
        this(name, ';', withNewline);
    }

    public InsertSemicolonAction(boolean withNewLine) {
        this(withNewLine ? "complete-line-newline" : "complete-line", ';', withNewLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        if (!target.isEditable() || !target.isEnabled()) {
            target.getToolkit().beep();
            return;
        }
        final BaseDocument doc = (BaseDocument)target.getDocument();
        final Formatter formatter = doc.getFormatter();
        formatter.indentLock();
        try {
            final class R
            implements Runnable {
                R() {
                }

                @Override
                public void run() {
                    Caret caret = target.getCaret();
                    int dotpos = caret.getDot();
                    try {
                        int eoloffset = Utilities.getRowEnd((JTextComponent)target, (int)dotpos);
                        doc.insertString(eoloffset, "" + InsertSemicolonAction.this.what, null);
                        if (InsertSemicolonAction.this.withNewline) {
                            doc.insertString(dotpos, "-", null);
                            doc.remove(dotpos, 1);
                            int eolDot = Utilities.getRowEnd((JTextComponent)target, (int)caret.getDot());
                            int newDotPos = formatter.indentNewLine((Document)doc, eolDot);
                            caret.setDot(newDotPos);
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            doc.runAtomicAsUser((Runnable)new R());
        }
        finally {
            formatter.indentUnlock();
        }
    }
}

