/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.ui.ConstructorPanel;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ConstructorGenerator
implements CodeGenerator {
    private JTextComponent component;
    private ElementHandle<? extends Element> constructorHandle;
    private ElementNode.Description constructorDescription;
    private ElementNode.Description fieldsDescription;

    private ConstructorGenerator(JTextComponent jTextComponent, ElementHandle<? extends Element> elementHandle, ElementNode.Description description, ElementNode.Description description2) {
        this.component = jTextComponent;
        this.constructorHandle = elementHandle;
        this.constructorDescription = description;
        this.fieldsDescription = description2;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_constructor");
    }

    public void invoke() {
        List<ElementHandle<? extends Element>> list;
        List<ElementHandle<? extends Element>> list2;
        DialogDescriptor dialogDescriptor;
        ConstructorPanel constructorPanel;
        final int n = this.component.getCaretPosition();
        if (this.constructorDescription != null || this.fieldsDescription != null) {
            constructorPanel = new ConstructorPanel(this.constructorDescription, this.fieldsDescription);
            dialogDescriptor = GeneratorUtils.createDialogDescriptor(constructorPanel, NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_constructor"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() != dialogDescriptor.getDefaultValue()) {
                return;
            }
            list2 = this.constructorHandle == null ? constructorPanel.getInheritedConstructors() : null;
            list = constructorPanel.getVariablesToInitialize();
        } else {
            list = null;
            list2 = null;
        }
        constructorPanel = JavaSource.forDocument((Document)this.component.getDocument());
        if (constructorPanel != null) {
            try {
                dialogDescriptor = constructorPanel.runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy workingCopy) throws IOException {
                        workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath treePath = workingCopy.getTreeUtilities().pathFor(n);
                        treePath = Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath);
                        int n2 = GeneratorUtils.findClassMemberIndex(workingCopy, (ClassTree)treePath.getLeaf(), n);
                        ArrayList<VariableElement> arrayList = new ArrayList<VariableElement>();
                        if (list != null) {
                            for (Object object : list) {
                                VariableElement variableElement = (VariableElement)object.resolve((CompilationInfo)workingCopy);
                                if (variableElement == null) {
                                    return;
                                }
                                arrayList.add(variableElement);
                            }
                        }
                        if (list2 != null && !list2.isEmpty()) {
                            ArrayList arrayList2 = new ArrayList();
                            for (VariableElement variableElement : list2) {
                                ExecutableElement executableElement = (ExecutableElement)variableElement.resolve((CompilationInfo)workingCopy);
                                if (executableElement == null) {
                                    return;
                                }
                                arrayList2.add(executableElement);
                            }
                            GeneratorUtils.generateConstructors(workingCopy, treePath, arrayList, arrayList2, n2);
                        } else {
                            GeneratorUtils.generateConstructor(workingCopy, treePath, arrayList, ConstructorGenerator.this.constructorHandle != null ? (ExecutableElement)ConstructorGenerator.this.constructorHandle.resolve((CompilationInfo)workingCopy) : null, n2);
                        }
                    }
                });
                GeneratorUtils.guardedCommit(this.component, (ModificationResult)dialogDescriptor);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public static class Factory
    implements CodeGenerator.Factory {
        /*
         * WARNING - void declaration
         */
        public List<? extends CodeGenerator> create(Lookup lookup) {
            void var14_18;
            ArrayList<ElementNode.Description> arrayList;
            Object object;
            ArrayList<ConstructorGenerator> arrayList2 = new ArrayList<ConstructorGenerator>();
            JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
            CompilationController compilationController = (CompilationController)lookup.lookup(CompilationController.class);
            TreePath treePath = (TreePath)lookup.lookup(TreePath.class);
            TreePath treePath2 = treePath = treePath != null ? Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath) : null;
            if (jTextComponent == null || compilationController == null || treePath == null) {
                return arrayList2;
            }
            try {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            }
            catch (IOException iOException) {
                return arrayList2;
            }
            TypeElement typeElement = (TypeElement)compilationController.getTrees().getElement(treePath);
            if (typeElement == null || !typeElement.getKind().isClass() || NestingKind.ANONYMOUS.equals((Object)typeElement.getNestingKind())) {
                return arrayList2;
            }
            LinkedHashSet<VariableElement> linkedHashSet = new LinkedHashSet<VariableElement>();
            LinkedHashSet<VariableElement> linkedHashSet2 = new LinkedHashSet<VariableElement>();
            ArrayList<ExecutableElement> arrayList3 = new ArrayList<ExecutableElement>();
            ArrayList<ExecutableElement> arrayList4 = new ArrayList<ExecutableElement>();
            TypeMirror typeMirror = typeElement.getSuperclass();
            TypeElement typeElement2 = null;
            if (typeMirror.getKind() == TypeKind.DECLARED) {
                typeElement2 = (TypeElement)((DeclaredType)typeMirror).asElement();
                for (ExecutableElement object22 : ElementFilter.constructorsIn(typeElement2.getEnclosedElements())) {
                    object = compilationController.getElements().getPackageOf(typeElement);
                    arrayList = compilationController.getElements().getPackageOf(object22);
                    Object object2 = object22.getModifiers();
                    if (object != arrayList && !object2.contains((Object)Modifier.PUBLIC) && !object2.contains((Object)Modifier.PROTECTED) || object2.contains((Object)Modifier.PRIVATE)) continue;
                    arrayList4.add(object22);
                }
            }
            GeneratorUtils.scanForFieldsAndConstructors((CompilationInfo)compilationController, treePath, linkedHashSet, linkedHashSet2, arrayList3);
            ElementHandle elementHandle = null;
            Object var14_16 = null;
            if (typeElement.getKind() != ElementKind.ENUM && arrayList4.size() == 1) {
                elementHandle = ElementHandle.create((Element)((Element)arrayList4.get(0)));
            } else if (arrayList4.size() > 1) {
                object = new ArrayList();
                for (Object object2 : arrayList4) {
                    object.add(ElementNode.Description.create((Element)object2, null, true, false));
                }
                ElementNode.Description description = ElementNode.Description.create(typeElement2, (List<ElementNode.Description>)object, false, false);
            }
            object = null;
            if (!linkedHashSet2.isEmpty()) {
                arrayList = new ArrayList<ElementNode.Description>();
                for (VariableElement variableElement : linkedHashSet2) {
                    arrayList.add(ElementNode.Description.create(variableElement, null, true, false));
                }
                object = ElementNode.Description.create(typeElement, arrayList, false, false);
            }
            if (elementHandle != null || var14_18 != null || object != null) {
                arrayList2.add(new ConstructorGenerator(jTextComponent, elementHandle, (ElementNode.Description)var14_18, (ElementNode.Description)object));
            }
            return arrayList2;
        }
    }
}

