/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.versioning.spi.VCSVisibilityQuery;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.util.RequestProcessor;

public class CvsVisibilityQuery
extends VCSVisibilityQuery
implements VersioningListener {
    private static CvsVisibilityQuery instance;
    private static final String MARKER_CVS_REMOVED = "CVS/.nb-removed";
    private final RequestProcessor.Task refreshVisibilityTask;

    public CvsVisibilityQuery() {
        CvsVersioningSystem.getInstance().getStatusCache().addVersioningListener(this);
        instance = this;
        this.refreshVisibilityTask = Utils.createTask((Runnable)new Runnable(){

            @Override
            public void run() {
                CvsVisibilityQuery.this.fireVisibilityChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible(File file) {
        boolean bl;
        block3: {
            long t = System.currentTimeMillis();
            CvsVersioningSystem.LOG.log(Level.FINE, "isVisible {0}", new Object[]{file});
            boolean ret = true;
            try {
                bl = ret = file == null || file.isFile() || !CvsVisibilityQuery.isHiddenFolder(file);
                if (!CvsVersioningSystem.LOG.isLoggable(Level.FINE)) break block3;
            }
            catch (Throwable throwable) {
                if (CvsVersioningSystem.LOG.isLoggable(Level.FINE)) {
                    CvsVersioningSystem.LOG.log(Level.FINE, "isVisible returns {0} in {1} millis", new Object[]{ret, System.currentTimeMillis() - t});
                }
                throw throwable;
            }
            CvsVersioningSystem.LOG.log(Level.FINE, "isVisible returns {0} in {1} millis", new Object[]{ret, System.currentTimeMillis() - t});
        }
        return bl;
    }

    public void versioningEvent(VersioningEvent event) {
        if (event.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            File file = (File)event.getParams()[0];
            if (file == null) {
                return;
            }
            File parent = file.getParentFile();
            if (parent == null) {
                return;
            }
            File marker = new File(parent, MARKER_CVS_REMOVED);
            if (marker.exists()) {
                if (file.lastModified() > marker.lastModified() && !"CVS".equals(file.getName())) {
                    CvsVisibilityQuery.makeVisible(parent);
                }
                this.fireVisibilityChanged();
            }
        }
    }

    private static void makeVisible(File file) {
        if (file == null) {
            return;
        }
        new File(file, MARKER_CVS_REMOVED).delete();
        CvsVisibilityQuery.makeVisible(file.getParentFile());
    }

    static boolean isHiddenFolder(File file) {
        File marker = new File(file, MARKER_CVS_REMOVED);
        if (marker.exists()) {
            File[] files;
            for (File child : files = file.listFiles()) {
                if (child.lastModified() <= marker.lastModified() || "CVS".equals(child.getName())) continue;
                CvsVisibilityQuery.makeVisible(file);
                CvsVisibilityQuery.refreshVisibility();
                return false;
            }
            return true;
        }
        return false;
    }

    private static void refreshVisibility() {
        if (instance != null) {
            CvsVisibilityQuery.instance.refreshVisibilityTask.schedule(100);
        }
    }

    static void hideFolder(File file) throws IOException {
        new File(file, MARKER_CVS_REMOVED).createNewFile();
        CvsVisibilityQuery.refreshVisibility();
    }
}

