/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.servicetag;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.netbeans.modules.servicetag.LinuxSystemEnvironment;
import org.netbeans.modules.servicetag.SolarisSystemEnvironment;
import org.netbeans.modules.servicetag.WindowsSystemEnvironment;

class SystemEnvironment {
    private String hostname;
    private String hostId;
    private String osName;
    private String osVersion;
    private String osArchitecture;
    private String systemModel;
    private String systemManufacturer;
    private String cpuManufacturer;
    private String serialNumber;
    private static SystemEnvironment sysEnv = null;

    public static synchronized SystemEnvironment getSystemEnvironment() {
        if (sysEnv == null) {
            String os = System.getProperty("os.name");
            sysEnv = os.equals("SunOS") ? new SolarisSystemEnvironment() : (os.equals("Linux") ? new LinuxSystemEnvironment() : (os.startsWith("Windows") ? new WindowsSystemEnvironment() : new SystemEnvironment()));
        }
        return sysEnv;
    }

    SystemEnvironment() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            this.hostname = "Unknown host";
        }
        this.hostId = "";
        this.osName = System.getProperty("os.name");
        this.osVersion = System.getProperty("os.version");
        this.osArchitecture = System.getProperty("os.arch");
        this.systemModel = "";
        this.systemManufacturer = "";
        this.cpuManufacturer = "";
        this.serialNumber = "";
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public void setOsArchitecture(String osArchitecture) {
        this.osArchitecture = osArchitecture;
    }

    public void setSystemModel(String systemModel) {
        this.systemModel = systemModel;
    }

    public void setSystemManufacturer(String systemManufacturer) {
        this.systemManufacturer = systemManufacturer;
    }

    public void setCpuManufacturer(String cpuManufacturer) {
        this.cpuManufacturer = cpuManufacturer;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setHostId(String hostId) {
        if (hostId == null || hostId.equals("null")) {
            hostId = "";
        }
        if (hostId.length() > 16) {
            hostId = hostId.substring(0, 16);
        }
        this.hostId = hostId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getOsArchitecture() {
        return this.osArchitecture;
    }

    public String getSystemModel() {
        return this.systemModel;
    }

    public String getSystemManufacturer() {
        return this.systemManufacturer;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getHostId() {
        return this.hostId;
    }

    public String getCpuManufacturer() {
        return this.cpuManufacturer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCommandOutput(String ... command) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        Process p = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            p = pb.start();
            p.waitFor();
            if (p.exitValue() == 0) {
                br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(line);
                }
            }
            String string = sb.toString();
            return string;
        }
        catch (InterruptedException ie) {
            if (p != null) {
                p.destroy();
            }
            String string = "";
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        finally {
            if (p != null) {
                try {
                    p.getErrorStream().close();
                }
                catch (IOException e) {}
                try {
                    p.getInputStream().close();
                }
                catch (IOException e) {}
                try {
                    p.getOutputStream().close();
                }
                catch (IOException e) {}
                p = null;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFileContent(String filename) {
        File f = new File(filename);
        if (!f.exists()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

