/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.servicetag;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;

class BrowserSupport {
    private static Boolean isBrowseSupported;

    BrowserSupport() {
    }

    private static void initX() {
        if (isBrowseSupported != null) {
            return;
        }
        final AtomicBoolean result = new AtomicBoolean();
        Thread xthread = new Thread(){

            @Override
            public void run() {
                result.set(Desktop.isDesktopSupported());
            }
        };
        xthread.setDaemon(true);
        xthread.start();
        try {
            xthread.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        isBrowseSupported = result.get() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
    }

    static boolean isSupported() {
        BrowserSupport.initX();
        return isBrowseSupported;
    }

    static void browse(URI uri) throws IOException {
        if (uri == null) {
            throw new NullPointerException("null uri");
        }
        if (!BrowserSupport.isSupported()) {
            throw new UnsupportedOperationException("Browse operation is not supported");
        }
        Desktop.getDesktop().browse(uri);
    }
}

