/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JScrollPane;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.maven.graph.ArtifactGraphEdge;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.DependencyGraphScene;

public class FruchtermanReingoldLayout
extends SceneLayout {
    private double forceConstant;
    private double temp;
    private int iterations = 700;
    private final int magicSizeMultiplier = 10;
    private final int magicSizeConstant = 200;
    private Rectangle bounds;
    protected int m_fidx;
    private static final double MIN = 1.0E-6;
    private static final double ALPHA = 0.1;
    private DependencyGraphScene scene;
    private JScrollPane panel;

    public FruchtermanReingoldLayout(DependencyGraphScene dependencyGraphScene, JScrollPane jScrollPane) {
        super((Scene)dependencyGraphScene);
        this.scene = dependencyGraphScene;
        this.init();
        this.panel = jScrollPane;
    }

    public void performLayout() {
        Object object2;
        this.performLayout(true);
        this.scene.validate();
        Rectangle rectangle = new Rectangle(0, 0, 1, 1);
        for (Object object2 : this.scene.getChildren()) {
            rectangle = rectangle.union(object2.convertLocalToScene(object2.getBounds()));
        }
        Dimension dimension = rectangle.getSize();
        object2 = this.panel.getViewportBorderBounds().getSize();
        double d = Math.min((float)object2.width / (float)dimension.width, (float)object2.height / (float)dimension.height);
        this.scene.setZoomFactor(Math.min(d, 1.0));
        this.scene.validate();
    }

    private void performLayout(boolean bl) {
        for (int i = 0; i < this.iterations; ++i) {
            int n = 0;
            while (true) {
                for (Object object : this.scene.getNodes()) {
                    if (((ArtifactGraphNode)object).isFixed()) continue;
                    this.calcRepulsion((ArtifactGraphNode)object);
                }
                for (Object object : this.scene.getEdges()) {
                    this.calcAttraction((ArtifactGraphEdge)object);
                }
                for (Object object : this.scene.getNodes()) {
                    if (((ArtifactGraphNode)object).isFixed()) continue;
                    this.calcPositions((ArtifactGraphNode)object);
                }
                if (this.areAllFixed() || n > 2) break;
                ++n;
            }
            this.doRelayoutNonFixed();
            this.resetFixed();
            this.cool(i);
        }
        if (bl) {
            this.finish();
        }
    }

    public void rePerformLayout(int n) {
        int n2 = this.scene.getNodes().size();
        this.iterations = n;
        this.bounds = this.scene.getBounds();
        this.temp = this.bounds.getWidth() / 1000.0;
        this.forceConstant = 0.25 * Math.sqrt(this.bounds.getHeight() * this.bounds.getWidth() / (double)n2);
        this.performLayout(false);
    }

    private void init() {
        int n = this.scene.getNodes().size();
        this.bounds = new Rectangle(200 + 10 * n, 200 + 10 * n);
        this.temp = this.bounds.getWidth() / 10.0;
        this.forceConstant = 0.75 * Math.sqrt(this.bounds.getHeight() * this.bounds.getWidth() / (double)n);
        ArtifactGraphNode artifactGraphNode = this.scene.getRootGraphNode();
        artifactGraphNode.locX = this.bounds.getCenterX();
        artifactGraphNode.locY = this.bounds.getCenterY();
        artifactGraphNode.setFixed(true);
        this.layoutCirculary(this.scene.getNodes(), artifactGraphNode);
    }

    private void finish() {
        for (ArtifactGraphNode artifactGraphNode : this.scene.getNodes()) {
            Widget widget = this.scene.findWidget(artifactGraphNode);
            Point point = new Point();
            point.setLocation(artifactGraphNode.locX, artifactGraphNode.locY);
            widget.setPreferredLocation(point);
        }
    }

    public void calcPositions(ArtifactGraphNode artifactGraphNode) {
        double d = Math.max(1.0E-6, Math.sqrt(artifactGraphNode.dispX * artifactGraphNode.dispX + artifactGraphNode.dispY * artifactGraphNode.dispY));
        double d2 = artifactGraphNode.dispX / d * Math.min(d, this.temp);
        double d3 = artifactGraphNode.dispY / d * Math.min(d, this.temp);
        artifactGraphNode.locX += d2;
        artifactGraphNode.locY += d3;
        if (this.isThereFreeSpaceNonFixedSpace(artifactGraphNode)) {
            artifactGraphNode.setFixed(true);
        }
    }

    public void calcAttraction(ArtifactGraphEdge artifactGraphEdge) {
        ArtifactGraphNode artifactGraphNode = (ArtifactGraphNode)this.scene.getEdgeSource(artifactGraphEdge);
        ArtifactGraphNode artifactGraphNode2 = (ArtifactGraphNode)this.scene.getEdgeTarget(artifactGraphEdge);
        assert (artifactGraphNode != null && artifactGraphNode2 != null) : "wrong edge=" + artifactGraphEdge;
        double d = artifactGraphNode.locX - artifactGraphNode2.locX;
        double d2 = artifactGraphNode.locX - artifactGraphNode2.locY;
        double d3 = Math.max(1.0E-6, Math.sqrt(d * d + d2 * d2));
        double d4 = d3 * d3 / this.forceConstant;
        double d5 = d / d3 * d4;
        double d6 = d2 / d3 * d4;
        artifactGraphNode.dispX -= d5;
        artifactGraphNode.dispY -= d6;
        artifactGraphNode2.dispX += d5;
        artifactGraphNode2.dispY += d6;
    }

    public void calcRepulsion(ArtifactGraphNode artifactGraphNode) {
        artifactGraphNode.dispX = 0.0;
        artifactGraphNode.dispY = 0.0;
        for (ArtifactGraphNode artifactGraphNode2 : this.scene.getNodes()) {
            if (artifactGraphNode == artifactGraphNode2) continue;
            double d = artifactGraphNode.locX - artifactGraphNode2.locX;
            double d2 = artifactGraphNode.locY - artifactGraphNode2.locY;
            double d3 = Math.max(1.0E-6, Math.sqrt(d * d + d2 * d2));
            double d4 = this.forceConstant * this.forceConstant / d3;
            artifactGraphNode.dispX += d / d3 * d4;
            artifactGraphNode.dispY += d2 / d3 * d4;
        }
    }

    private void cool(int n) {
        this.temp *= 1.0 - (double)n / (double)this.iterations;
    }

    private void layoutCirculary(Collection<ArtifactGraphNode> collection, ArtifactGraphNode artifactGraphNode) {
        Point point = new Point();
        point.setLocation(artifactGraphNode.locX, artifactGraphNode.locY);
        double d = 0.6283185307179586;
        double d2 = 150.0;
        double d3 = 0.0;
        Iterator<ArtifactGraphNode> iterator = collection.iterator();
        ArtifactGraphNode artifactGraphNode2 = iterator.next();
        while (true) {
            AffineTransform affineTransform;
            Point2D point2D;
            Point point2;
            if (this.isThereFreeSpace(point2 = new Point((int)(point2D = (affineTransform = AffineTransform.getRotateInstance(d3)).transform(new Point2D.Double(0.0, d2), null)).getX() + point.x, (int)point2D.getY() + point.y), artifactGraphNode2)) {
                artifactGraphNode2.locX = point2.getX();
                artifactGraphNode2.locY = point2.getY();
                artifactGraphNode2.dispX = 0.0;
                artifactGraphNode2.dispY = 0.0;
                if (iterator.hasNext()) {
                    artifactGraphNode2 = iterator.next();
                } else {
                    return;
                }
            }
            if (!((d3 += d) > 5.969026041820607)) continue;
            d2 += 90.0;
            d3 -= Math.PI * 2;
            d = d * 3.0 / 4.0;
        }
    }

    private boolean isThereFreeSpace(Point point, ArtifactGraphNode artifactGraphNode) {
        Rectangle rectangle = this.scene.findWidget(artifactGraphNode).getBounds();
        rectangle = new Rectangle(point.x, point.y, rectangle != null ? rectangle.width : 0, rectangle != null ? rectangle.height : 0);
        for (ArtifactGraphNode artifactGraphNode2 : this.scene.getNodes()) {
            Rectangle rectangle2 = this.scene.findWidget(artifactGraphNode2).getBounds();
            Point point2 = new Point();
            point2.setLocation(artifactGraphNode2.locX, artifactGraphNode2.locY);
            if (!rectangle.intersects(rectangle2 = new Rectangle(point2, rectangle2.getSize()))) continue;
            return false;
        }
        return true;
    }

    private boolean areAllFixed() {
        for (ArtifactGraphNode artifactGraphNode : this.scene.getNodes()) {
            if (artifactGraphNode.isFixed()) continue;
            return false;
        }
        return true;
    }

    private void resetFixed() {
        for (ArtifactGraphNode artifactGraphNode : this.scene.getNodes()) {
            artifactGraphNode.setFixed(false);
        }
        this.scene.getRootGraphNode().setFixed(true);
    }

    private boolean isThereFreeSpaceNonFixedSpace(ArtifactGraphNode artifactGraphNode) {
        Rectangle rectangle = this.scene.findWidget(artifactGraphNode).getBounds();
        Point point = new Point();
        point.setLocation(artifactGraphNode.locX, artifactGraphNode.locY);
        rectangle = new Rectangle(point, rectangle.getSize());
        for (ArtifactGraphNode artifactGraphNode2 : this.scene.getNodes()) {
            Rectangle rectangle2 = this.scene.findWidget(artifactGraphNode2).getBounds();
            Point point2 = new Point();
            point2.setLocation(artifactGraphNode2.locX, artifactGraphNode2.locY);
            rectangle2 = new Rectangle(point2, rectangle2.getSize());
            if (!artifactGraphNode2.isFixed() || !rectangle.intersects(rectangle2)) continue;
            return false;
        }
        return true;
    }

    private void doRelayoutNonFixed() {
        for (ArtifactGraphNode artifactGraphNode : this.scene.getNodes()) {
            if (artifactGraphNode.isFixed()) continue;
            this.relayoutNonFixed(artifactGraphNode);
        }
    }

    private void relayoutNonFixed(ArtifactGraphNode artifactGraphNode) {
        Point point = new Point();
        point.setLocation(artifactGraphNode.locX, artifactGraphNode.locY);
        double d = 0.6283185307179586;
        double d2 = 30.0;
        double d3 = 0.0;
        artifactGraphNode.setFixed(false);
        while (true) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(d3);
            Point2D point2D = affineTransform.transform(new Point2D.Double(0.0, d2), null);
            Point point2 = new Point((int)point2D.getX() + point.x, (int)point2D.getY() + point.y);
            artifactGraphNode.locX = point2.getX();
            artifactGraphNode.locY = point2.getY();
            if (this.isThereFreeSpaceNonFixedSpace(artifactGraphNode)) {
                artifactGraphNode.setFixed(true);
                return;
            }
            if (!((d3 += d) > 5.969026041820607)) continue;
            d2 += 30.0;
            d3 -= Math.PI * 2;
            d = d * 3.0 / 4.0;
        }
    }
}

