/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.netbeans.api.visual.animator.Animator;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.widget.Scene;

class CenteredZoomAnimator
extends Animator {
    private double sourceZoom;
    private double targetZoom;
    private Point center;
    private Point sceneCenter;

    public CenteredZoomAnimator(SceneAnimator sceneAnimator) {
        super(sceneAnimator);
    }

    public void setZoomFactor(double zoomFactor, Point center) {
        this.sourceZoom = this.getScene().getZoomFactor();
        this.targetZoom = zoomFactor;
        this.center = center;
        Rectangle sceneB = this.getScene().getBounds();
        this.sceneCenter = new Point((int)sceneB.getCenterX(), (int)sceneB.getCenterY());
        this.start();
    }

    public double getTargetZoom() {
        return this.targetZoom;
    }

    public Point getCenter() {
        return this.center;
    }

    public void tick(double progress) {
        double nextZoom = progress >= 1.0 ? this.targetZoom : this.sourceZoom + progress * (this.targetZoom - this.sourceZoom);
        Scene scene = this.getScene();
        JComponent view = scene.getView();
        if (view != null) {
            Point viewLocation = view.getVisibleRect().getLocation();
            Dimension viewSize = view.getVisibleRect().getSize();
            Point oldCenter = scene.convertSceneToView(this.center);
            scene.setZoomFactor(nextZoom);
            scene.validate();
            Point newCenter = scene.convertSceneToView(this.center);
            Rectangle viewBounds = view.getVisibleRect();
            Point visibleCenter = new Point((int)viewBounds.getCenterX(), (int)viewBounds.getCenterY());
            newCenter.x = (int)((long)newCenter.x + Math.round((double)(newCenter.x - visibleCenter.x) * progress));
            newCenter.y = (int)((long)newCenter.y + Math.round((double)(newCenter.y - visibleCenter.y) * progress));
            view.scrollRectToVisible(new Rectangle(newCenter.x - oldCenter.x + viewLocation.x, newCenter.y - oldCenter.y + viewLocation.y, viewSize.width, viewSize.height));
        } else {
            scene.setZoomFactor(nextZoom);
        }
    }
}

