/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.TextProperties;
import com.sun.perseus.j2d.TextRenderingProperties;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.CompositeGraphicsNodeProxy;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.ElementNodeProxy;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.Font;
import com.sun.perseus.model.FontFace;
import com.sun.perseus.model.Glyph;
import com.sun.perseus.model.GlyphLayout;
import com.sun.perseus.model.GlyphProxy;
import com.sun.perseus.model.Group;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.StringTraitAnim;
import com.sun.perseus.model.TextProxy;
import com.sun.perseus.model.TraitAnim;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGRect;

public class Text
extends Group {
    protected String content;
    protected float[] x = new float[]{0.0f};
    protected float[] y = new float[]{0.0f};
    protected float[] rotate;
    protected GlyphLayout firstChunk;
    protected GlyphLayout lastChunk;
    protected float[] helperDashArray;

    public Text(DocumentNode ownerDocument) {
        super(ownerDocument);
    }

    public String getLocalName() {
        return "text";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new Text(doc);
    }

    ElementNodeProxy buildProxy() {
        return new TextProxy(this);
    }

    public void setX(float[] newX) {
        if (Text.equal(newX, this.x)) {
            return;
        }
        this.modifyingNode();
        if (newX == null || newX.length == 0) {
            this.x = new float[1];
            this.x[0] = 0.0f;
        } else {
            this.x = newX;
        }
        this.clearLayoutsQuiet();
        this.modifiedNode();
    }

    public void setY(float[] newY) {
        if (Text.equal(newY, this.y)) {
            return;
        }
        this.modifyingNode();
        if (newY == null || newY.length == 0) {
            this.y = new float[1];
            this.y[0] = 0.0f;
        } else {
            this.y = newY;
        }
        this.clearLayoutsQuiet();
        this.modifiedNode();
    }

    public void setRotate(float[] newRotate) {
        if (Text.equal(newRotate, this.rotate)) {
            return;
        }
        this.modifyingNode();
        this.rotate = newRotate;
        this.clearLayoutsQuiet();
        this.modifiedNode();
    }

    public float[] getX() {
        return this.x;
    }

    public float[] getY() {
        return this.y;
    }

    public float[] getRotate() {
        return this.rotate;
    }

    public boolean getPaintNeedsLoad() {
        return true;
    }

    void nodeHookedInDocumentTree() {
        super.nodeHookedInDocumentTree();
    }

    void nodeUnhookedFromDocumentTree() {
        super.nodeUnhookedFromDocumentTree();
    }

    public SVGRect getBBox() {
        return this.addNodeBBox(null, null);
    }

    public SVGRect getScreenBBox() {
        if (!this.inDocumentTree()) {
            return null;
        }
        return this.addNodeBBox(null, this.txf);
    }

    Box addNodeBBox(Box bbox, Transform t) {
        this.checkLayout();
        return this.addNodeBBox(bbox, t, this.firstChunk);
    }

    Box addNodeBBox(Box bbox, Transform t, GlyphLayout fc) {
        GlyphLayout c = fc;
        while (c != null) {
            this.ownerDocument.bboxChunkTxf.setTransform(t);
            c.applyTransform(this, this.ownerDocument.bboxChunkTxf);
            bbox = c.addBBox(bbox, this.ownerDocument.bboxChunkTxf);
            c = c.nextSibling;
        }
        return bbox;
    }

    public boolean hasNodeRendering() {
        return true;
    }

    public void appendTextChild(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        if (this.content == null) {
            this.setContent(text);
        } else {
            this.setContent(this.content + text);
        }
    }

    public void setContent(String newContent) {
        if (Text.equal(newContent, this.content)) {
            return;
        }
        this.modifyingNode();
        this.content = newContent;
        this.clearLayouts(false);
        this.modifiedNode();
    }

    public String getContent() {
        return this.content;
    }

    public ModelNode nodeHitAt(float[] pt) {
        if (this.canRenderState != 0) {
            return null;
        }
        this.checkLayout();
        if (this.isHitVP(pt, this, this.getInverseTransformState(), this.lastChunk)) {
            return this;
        }
        return null;
    }

    ModelNode proxyNodeHitAt(float[] pt, ElementNodeProxy proxy) {
        if (this.canRenderState != 0) {
            return null;
        }
        TextProxy tp = (TextProxy)proxy;
        tp.checkLayout();
        if (this.isHitVP(pt, tp, tp.inverseTxf, tp.lastChunk)) {
            return proxy;
        }
        return null;
    }

    protected boolean isHitVP(float[] pt, TextRenderingProperties trp, Transform itx, GlyphLayout lc) {
        if (!trp.getVisibility()) {
            return false;
        }
        GlyphLayout c = lc;
        while (c != null) {
            this.ownerDocument.hitChunkTxf.setTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            c.applyInverseTransform(trp, this.ownerDocument.hitChunkTxf);
            this.ownerDocument.hitChunkTxf.mMultiply(itx);
            if (c.isHitVP(pt, this, this.ownerDocument.hitChunkTxf)) {
                return true;
            }
            c = c.prevSibling;
        }
        return false;
    }

    public void paint(RenderGraphics rg) {
        if (this.canRenderState != 0) {
            return;
        }
        this.checkLayout();
        this.paintRendered(rg, this, this.txf, this.firstChunk);
    }

    public void paintRendered(RenderGraphics rg, TextRenderingProperties trc, Transform tx, GlyphLayout fc) {
        if (!trc.getVisibility()) {
            return;
        }
        rg.setPaintTarget(this);
        rg.setPaintTransform(tx);
        rg.setFontSize(trc.getFontSize());
        rg.setTextAnchor(trc.getTextAnchor());
        if (trc.getFill() != null) {
            rg.setFillRule(trc.getFillRule());
            rg.setFill(trc.getFill());
            rg.setFillOpacity(trc.getFillOpacity());
            this.fillText(rg, tx, fc);
        }
        if (trc.getStroke() != null) {
            rg.setStrokeWidth(trc.getStrokeWidth() / trc.getFontSize());
            float[] dashArray = trc.getStrokeDashArray();
            float[] trDashArray = null;
            float trDashOffset = 0.0f;
            if (dashArray != null) {
                float fontSize = trc.getFontSize();
                if (this.helperDashArray == null || this.helperDashArray.length != dashArray.length) {
                    this.helperDashArray = new float[dashArray.length];
                }
                trDashArray = this.helperDashArray;
                for (int i = 0; i < dashArray.length; ++i) {
                    trDashArray[i] = dashArray[i] / fontSize;
                }
                trDashOffset = trc.getStrokeDashOffset() / fontSize;
            }
            rg.setStrokeDashArray(trDashArray);
            rg.setStrokeDashOffset(trDashOffset);
            rg.setStroke(trc.getStroke());
            rg.setStrokeOpacity(trc.getStrokeOpacity());
            rg.setStrokeLineCap(trc.getStrokeLineCap());
            rg.setStrokeLineJoin(trc.getStrokeLineJoin());
            rg.setStrokeMiterLimit(trc.getStrokeMiterLimit());
            this.drawText(rg, tx, fc);
        }
    }

    void fillText(RenderGraphics rg, Transform tx, GlyphLayout fc) {
        GlyphLayout c = fc;
        while (c != null) {
            this.ownerDocument.paintChunkTxf.setTransform(tx);
            c.applyTransform(rg, this.ownerDocument.paintChunkTxf);
            c.fillText(rg, this.ownerDocument.paintChunkTxf);
            c = c.nextSibling;
        }
    }

    void drawText(RenderGraphics rg, Transform tx, GlyphLayout fc) {
        GlyphLayout c = fc;
        while (c != null) {
            this.ownerDocument.paintChunkTxf.setTransform(tx);
            c.applyTransform(rg, this.ownerDocument.paintChunkTxf);
            c.drawText(rg, this.ownerDocument.paintChunkTxf);
            c = c.nextSibling;
        }
    }

    protected void nodeRendered() {
    }

    public void clearLayouts() {
        this.clearLayouts(true);
    }

    protected void clearLayouts(boolean notif) {
        if (notif) {
            this.modifyingNode();
        }
        this.clearLayoutsQuiet();
        if (notif) {
            this.modifiedNode();
        }
    }

    protected void clearLayoutsQuiet() {
        this.firstChunk = null;
        this.lastChunk = null;
        ElementNodeProxy p = this.firstProxy;
        while (p != null) {
            ((TextProxy)p).clearLayoutsQuiet();
            p = p.nextProxy;
        }
    }

    void checkLayout() {
        if (this.firstChunk == null) {
            GlyphLayout cur = this.firstChunk = this.layoutText(this);
            while (cur.nextSibling != null) {
                cur = cur.nextSibling;
            }
            this.lastChunk = cur;
        }
    }

    public boolean hasDescendants() {
        return super.hasDescendants() || this.content != null && !"".equals(this.content);
    }

    protected int applyXMLSpace(char[] s) {
        switch (this.getXMLSpace()) {
            case 1: 
            case 2: {
                return this.applyXMLSpaceDefault(s);
            }
        }
        return this.applyXMLSpacePreserve(s);
    }

    protected int applyXMLSpaceDefault(char[] s) {
        int i;
        int j = 0;
        for (i = 0; i < s.length; ++i) {
            if (s[i] == '\n') continue;
            if (s[i] == '\t') {
                s[i] = 32;
            }
            s[j++] = s[i];
        }
        int length = j;
        for (i = 0; i < length && s[i] == ' '; ++i) {
        }
        j = 0;
        s[j++] = s[i++];
        while (i < length) {
            if (s[i] != ' ') {
                s[j++] = s[i];
            } else if (s[j - 1] != ' ') {
                s[j++] = 32;
            }
            ++i;
        }
        length = j;
        if (s[j - 1] == ' ') {
            length = j - 1;
        }
        return length;
    }

    protected int applyXMLSpacePreserve(char[] s) {
        for (int i = 0; i < s.length; ++i) {
            if (s[i] != '\n' && s[i] != '\t') continue;
            s[i] = 32;
        }
        return s.length;
    }

    public GlyphLayout layoutText(TextProperties tp) {
        GlyphLayout startChunk;
        GlyphLayout chunk = startChunk = new GlyphLayout(this.ownerDocument);
        chunk.x = this.x[0];
        chunk.y = this.y[0];
        if (this.content == null || "".equals(this.content)) {
            return startChunk;
        }
        char[] s = this.content.toCharArray();
        int length = this.applyXMLSpace(s);
        FontFace.Match defaultMatch = this.ownerDocument.resolveFontFaces(tp);
        FontFace.Match firstMatch = defaultMatch.next;
        FontFace.Match curMatch = null;
        Glyph missingGlyph = defaultMatch.fontFace.getMissingGlyph();
        int cur = 0;
        Glyph glyph = null;
        GlyphProxy proxy = null;
        GlyphProxy prevProxy = null;
        float curAdv = 0.0f;
        float fontSize = tp.getFontSize();
        while (cur < length) {
            if (cur > 0 && (cur < this.x.length || cur < this.y.length)) {
                GlyphLayout prevChunk = chunk;
                chunk = new GlyphLayout(this.ownerDocument);
                prevProxy = null;
                prevChunk.advance = curAdv;
                curAdv = 0.0f;
                chunk.x = cur < this.x.length ? this.x[cur] : prevChunk.x + fontSize * prevChunk.advance;
                chunk.y = cur < this.y.length ? this.y[cur] : prevChunk.y;
                prevChunk.nextSibling = chunk;
                chunk.prevSibling = prevChunk;
            }
            glyph = null;
            curMatch = firstMatch;
            while (curMatch != null && (glyph = curMatch.fontFace.canDisplay(s, cur)) == null) {
                curMatch = curMatch.next;
            }
            if (glyph == null && (glyph = defaultMatch.fontFace.canDisplay(s, cur)) == null) {
                glyph = missingGlyph;
            }
            proxy = new GlyphProxy(glyph);
            chunk.add(proxy);
            if (prevProxy != null) {
                float adjust = ((Font)proxy.proxied.parent).getHKern(prevProxy.proxied, proxy.proxied);
                curAdv -= adjust;
            }
            proxy.setX(curAdv);
            if (this.rotate != null && cur < this.rotate.length) {
                proxy.setRotate(this.rotate[cur]);
            }
            cur += glyph.getLength();
            curAdv += glyph.getTextHorizontalAdvanceX();
            prevProxy = proxy;
        }
        chunk.advance = curAdv;
        return startChunk;
    }

    protected void recomputeTransformState(Transform parentTransform) {
        this.txf = this.appendTransform(parentTransform, this.txf);
        this.computeCanRenderTransformBit(this.txf);
        this.inverseTxf = null;
    }

    protected void propagatePropertyState(int propertyIndex, Object parentPropertyValue) {
        if (this.firstProxy != null) {
            ElementNodeProxy proxy = this.firstProxy;
            while (proxy != null) {
                ((CompositeGraphicsNodeProxy)proxy).proxiedPropertyStateChange(propertyIndex, parentPropertyValue);
                proxy = proxy.nextProxy;
            }
        }
    }

    protected void propagateFloatPropertyState(int propertyIndex, float parentPropertyValue) {
        if (this.firstProxy != null) {
            ElementNodeProxy proxy = this.firstProxy;
            while (proxy != null) {
                ((CompositeGraphicsNodeProxy)proxy).proxiedFloatPropertyStateChange(propertyIndex, parentPropertyValue);
                proxy = proxy.nextProxy;
            }
        }
    }

    protected void propagatePackedPropertyState(int propertyIndex, int parentPropertyValue) {
        if (this.firstProxy != null) {
            ElementNodeProxy proxy = this.firstProxy;
            while (proxy != null) {
                ((CompositeGraphicsNodeProxy)proxy).proxiedPackedPropertyStateChange(propertyIndex, parentPropertyValue);
                proxy = proxy.nextProxy;
            }
        }
    }

    boolean supportsTrait(String traitName) {
        if ("x" == traitName || "y" == traitName || "rotate" == traitName || "#text" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("x" == name) {
            return this.toStringTrait(this.getX());
        }
        if ("y" == name) {
            return this.toStringTrait(this.getY());
        }
        if ("rotate" == name) {
            if (this.rotate == null) {
                return "";
            }
            System.err.println(">>>>>>>>>>>>>>>>>> getTraitImpl(" + name + ") : '" + this.toStringTrait(this.rotate) + "'");
            return this.toStringTrait(this.rotate);
        }
        if ("#text" == name) {
            if (this.content == null) {
                return "";
            }
            return this.getContent();
        }
        return super.getTraitImpl(name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("x" == name) {
            return this.getX()[0];
        }
        if ("y" == name) {
            return this.getY()[0];
        }
        return super.getFloatTraitImpl(name);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("x" == traitName || "y" == traitName || "rotate" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        if ("#text" == traitName) {
            return new StringTraitAnim(this, "#!null/ns@!", traitName);
        }
        return super.createTraitAnimImpl(traitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("x" == name) {
            this.setX(this.toTraitFloatArray(value));
        } else if ("y" == name) {
            this.setY(this.toTraitFloatArray(value));
        } else if ("rotate" == name) {
            this.setRotate(this.toTraitFloatArray(value));
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("x" == traitName || "y" == traitName) {
            return this.toAnimatedFloatArray(this.parseFloatArrayTrait(traitName, value));
        }
        if ("rotate" == traitName) {
            float[][] v = this.toAnimatedFloatArray(this.parseFloatArrayTrait(traitName, value));
            return v;
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("x" == name) {
            this.setX(this.parseFloatArrayTrait(name, value));
        } else if ("y" == name) {
            this.setY(this.parseFloatArrayTrait(name, value));
        } else if ("rotate" == name) {
            float[] rt = this.parseFloatArrayTrait(name, value);
            this.setRotate(rt);
        } else if ("#text" == name) {
            if (value == null) {
                throw this.illegalTraitValue(name, value);
            }
            this.setContent(value);
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        if ("x" == name) {
            this.setX(new float[]{value});
        } else if ("y" == name) {
            this.setY(new float[]{value});
        } else {
            super.setFloatTraitImpl(name, value);
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("x" == name || "y" == name) {
            float[] v = new float[value.length];
            for (int i = 0; i < value.length; ++i) {
                v[i] = value[i][0];
            }
            return this.toStringTrait(v);
        }
        if ("rotate" == name) {
            float[] v = new float[value.length];
            for (int i = 0; i < value.length; ++i) {
                v[i] = value[i][0];
            }
            return this.toStringTrait(v);
        }
        return super.toStringTrait(name, value);
    }

    public String toString() {
        String xStr = "x[";
        for (int i = 0; i < this.x.length; ++i) {
            xStr = xStr + this.x[i] + ", ";
        }
        xStr = xStr.substring(0, xStr.length() - 2);
        xStr = xStr + "]";
        String yStr = "y[";
        for (int i = 0; i < this.y.length; ++i) {
            yStr = yStr + this.y[i] + ", ";
        }
        yStr = yStr.substring(0, yStr.length() - 2);
        yStr = yStr + "]";
        return super.toString() + "[\"" + this.content + "\"] " + xStr + " " + yStr;
    }

    void setComputedDisplay(boolean newDisplay) {
        super.setComputedDisplay(newDisplay);
    }

    void setComputedVisibility(boolean newVisibility) {
        super.setComputedVisibility(newVisibility);
    }

    void setComputedFill(PaintServer newFill) {
        this.fill = newFill;
    }

    void setComputedStroke(PaintServer newStroke) {
        this.stroke = newStroke;
    }

    void setComputedStrokeWidth(float newStrokeWidth) {
        this.strokeWidth = newStrokeWidth;
    }

    void setComputedStrokeLineJoin(int newStrokeLineJoin) {
        super.setComputedStrokeLineJoin(newStrokeLineJoin);
    }

    void setComputedStrokeLineCap(int newStrokeLineCap) {
        super.setComputedStrokeLineCap(newStrokeLineCap);
    }

    void setComputedStrokeMiterLimit(float newStrokeMiterLimit) {
        this.strokeMiterLimit = newStrokeMiterLimit;
    }

    void setComputedStrokeDashArray(float[] newStrokeDashArray) {
        this.strokeDashArray = newStrokeDashArray;
    }

    void setComputedStrokeDashOffset(float newStrokeDashOffset) {
        this.strokeDashOffset = newStrokeDashOffset;
    }

    void setComputedFillOpacity(float newFillOpacity) {
        super.setComputedFillOpacity(newFillOpacity);
    }

    void setComputedStrokeOpacity(float newStrokeOpacity) {
        super.setComputedStrokeOpacity(newStrokeOpacity);
    }

    void setComputedFontSize(float newFontSize) {
        this.fontSize = newFontSize;
        this.computeCanRenderFontSizeBit(newFontSize);
    }

    void setComputedFontFamily(String[] newFontFamily) {
        this.fontFamily = newFontFamily;
        this.clearLayoutsQuiet();
    }

    void setComputedTextAnchor(int newTextAnchor) {
        super.setComputedTextAnchor(newTextAnchor);
    }

    void setComputedFontWeight(int newFontWeight) {
        super.setComputedFontWeight(newFontWeight);
        this.clearLayoutsQuiet();
    }

    void setComputedFontStyle(int newFontStyle) {
        super.setComputedFontStyle(newFontStyle);
        this.clearLayoutsQuiet();
    }
}

