/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.Curve;
import com.sun.perseus.j2d.Path;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class PathShape
implements Shape {
    Path path;
    int windingRule;

    PathShape(Path path, int windingRule) {
        this.path = path;
        this.windingRule = windingRule;
    }

    public Rectangle getBounds() {
        Box bounds = this.path.getBounds();
        return new Rectangle((int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height);
    }

    public Rectangle2D getBounds2D() {
        Box bounds = this.path.getBounds();
        return new Rectangle2D.Float(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public boolean contains(double x, double y) {
        int cross = Curve.crossingsForPath(this.getPathIterator(null), x, y);
        if (this.windingRule == 1) {
            return cross != 0;
        }
        return (cross & 1) != 0;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.contains(x, y) || this.contains(x + w, y) || this.contains(x + w, y + h) || this.contains(x, y + h) || this.contains(x + w / 2.0, y + h / 2.0);
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.contains(x, y) && this.contains(x + w, y) && this.contains(x + w, y + h) && this.contains(x, y + h) && this.contains(x + w / 2.0, y + h / 2.0);
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new Iterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        PathIterator iterator = this.getPathIterator(at);
        return new FlatteningPathIterator(iterator, flatness);
    }

    class Iterator
    implements PathIterator {
        AffineTransform at;
        int nextSegment = 0;
        int offset = 0;
        int command = 0;

        Iterator(AffineTransform at) {
            this.at = at;
        }

        public int getWindingRule() {
            return PathShape.this.windingRule;
        }

        public boolean isDone() {
            return this.nextSegment == PathShape.this.path.nSegments;
        }

        public void next() {
            this.offset += Path.COMMAND_OFFSET[this.command];
            ++this.nextSegment;
            if (!this.isDone()) {
                this.command = PathShape.this.path.commands[this.nextSegment];
            }
        }

        public int currentSegment(float[] coords) {
            float[] data = PathShape.this.path.data;
            int nbPts = 0;
            int type = 0;
            switch (this.command) {
                case 0: {
                    coords[0] = data[this.offset];
                    coords[1] = data[this.offset + 1];
                    type = 0;
                    nbPts = 1;
                    break;
                }
                case 1: {
                    coords[0] = data[this.offset];
                    coords[1] = data[this.offset + 1];
                    type = 1;
                    nbPts = 1;
                    break;
                }
                case 2: {
                    coords[0] = data[this.offset];
                    coords[1] = data[this.offset + 1];
                    coords[2] = data[this.offset + 2];
                    coords[3] = data[this.offset + 3];
                    type = 2;
                    nbPts = 2;
                    break;
                }
                case 3: {
                    coords[0] = data[this.offset];
                    coords[1] = data[this.offset + 1];
                    coords[2] = data[this.offset + 2];
                    coords[3] = data[this.offset + 3];
                    coords[4] = data[this.offset + 4];
                    coords[5] = data[this.offset + 5];
                    type = 3;
                    nbPts = 3;
                    break;
                }
                case 4: {
                    type = 4;
                    break;
                }
            }
            if (this.at != null && nbPts > 0) {
                this.at.transform(coords, 0, coords, 0, nbPts);
            }
            return type;
        }

        public int currentSegment(double[] coords) {
            float[] data = PathShape.this.path.data;
            int type = 0;
            switch (this.command) {
                case 0: {
                    coords[0] = data[this.offset];
                    coords[1] = data[this.offset + 1];
                    type = 0;
                    break;
                }
                case 1: {
                    coords[0] = data[this.offset];
                    coords[1] = data[this.offset + 1];
                    type = 1;
                    break;
                }
                case 2: {
                    coords[0] = data[this.offset];
                    coords[1] = data[this.offset + 1];
                    coords[2] = data[this.offset + 2];
                    coords[3] = data[this.offset + 3];
                    type = 2;
                    break;
                }
                case 3: {
                    coords[0] = data[this.offset];
                    coords[1] = data[this.offset + 1];
                    coords[2] = data[this.offset + 2];
                    coords[3] = data[this.offset + 3];
                    coords[4] = data[this.offset + 4];
                    coords[5] = data[this.offset + 5];
                    type = 3;
                    break;
                }
                case 4: {
                    type = 4;
                    break;
                }
            }
            if (this.at != null) {
                this.at.transform(coords, 0, coords, 0, 1);
            }
            return type;
        }
    }
}

