/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.awt;

import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ModelEvent;
import com.sun.perseus.model.ModelNode;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class ComponentEventDispatcher {
    protected DocumentNode documentNode;
    protected ModelNode lastMouseTarget;
    public static final String[] MOUSE_EVENT_TYPES = new String[]{"click", "mousedown", "mouseup", "mousemove", "mouseover", "mouseout"};

    public ComponentEventDispatcher(DocumentNode documentNode) {
        if (documentNode == null) {
            throw new IllegalArgumentException();
        }
        this.documentNode = documentNode;
    }

    public void dispatchMouseEvent(MouseEvent event) {
        int i;
        float[] pt = new float[]{event.getX(), event.getY()};
        ModelNode target = this.documentNode.nodeHitAt(pt);
        if (target == null) {
            target = this.documentNode;
        }
        if (this.lastMouseTarget != target) {
            ModelEvent e;
            if (this.lastMouseTarget != null) {
                e = new ModelEvent("mouseout", this.lastMouseTarget);
                this.documentNode.dispatchEvent(e);
            }
            e = new ModelEvent("mouseover", target);
            this.documentNode.dispatchEvent(e);
            this.lastMouseTarget = target;
        }
        if ((i = event.getID() - 500) < 0 || i >= MOUSE_EVENT_TYPES.length) {
            return;
        }
        String type = MOUSE_EVENT_TYPES[i];
        ModelEvent evt = new ModelEvent(type, target);
        this.documentNode.dispatchEvent(evt);
    }

    public void dispatchKeyEvent(KeyEvent event) {
        String type = "keydown";
        switch (event.getID()) {
            case 401: {
                type = "keydown";
                break;
            }
            case 402: {
                type = "keyup";
                break;
            }
            default: {
                type = "keypress";
            }
        }
        ModelEvent evt = new ModelEvent(type, this.documentNode, event.getKeyChar());
        this.documentNode.dispatchEvent(evt);
    }
}

