/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.model.lang.syntax;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.asm.model.lang.AsmOffsetable;

public class AsmModelStream
implements Iterable<AsmOffsetable> {
    private final List<AsmOffsetable> elements;

    public AsmModelStream(List<AsmOffsetable> in) {
        this.elements = Collections.unmodifiableList(in);
    }

    @Override
    public Iterator<AsmOffsetable> iterator() {
        return this.elements.iterator();
    }

    public AsmOffsetable get(int index) {
        return this.elements.get(index);
    }

    public int size() {
        return this.elements.size();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AsmModelStream) {
            return ((Object)this.elements).equals(((AsmModelStream)obj).elements);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.elements).hashCode();
    }

    public void forEach(ElementVisitor visitor, AsmFilter filter) {
        for (AsmOffsetable el : this) {
            if (filter.accept(el) && !visitor.visit(el)) break;
        }
    }

    public void forEach(ElementVisitor visitor) {
        this.forEach(visitor, TrueFilter.instance);
    }

    public static final class TrueFilter
    implements AsmFilter {
        public static final AsmFilter instance = new TrueFilter();

        @Override
        public boolean accept(AsmOffsetable el) {
            return true;
        }

        private TrueFilter() {
        }
    }

    public static class ClazzFilter
    implements AsmFilter {
        private Class<?> cl;

        @Override
        public boolean accept(AsmOffsetable el) {
            return el.getClass() == this.cl;
        }

        public ClazzFilter(Class<?> cl) {
            this.cl = cl;
        }
    }

    public static interface AsmFilter {
        public boolean accept(AsmOffsetable var1);
    }

    static interface ElementVisitor {
        public boolean visit(AsmOffsetable var1);
    }
}

