/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.taskdefs.optional.junit.BaseTest;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;

public class JUnitTest
extends BaseTest
implements Cloneable {
    private String name = null;
    private boolean methodsSpecified = false;
    private String methodsList = null;
    private String[] methods = null;
    private String outfile = null;
    private long runs;
    private long failures;
    private long errors;
    private long runTime;
    private Properties props = null;

    public JUnitTest() {
    }

    public JUnitTest(String name) {
        this.name = name;
    }

    public JUnitTest(String name, boolean haltOnError, boolean haltOnFailure, boolean filtertrace) {
        this(name, haltOnError, haltOnFailure, filtertrace, null);
    }

    public JUnitTest(String name, boolean haltOnError, boolean haltOnFailure, boolean filtertrace, String[] methods) {
        this.name = name;
        this.haltOnError = haltOnError;
        this.haltOnFail = haltOnFailure;
        this.filtertrace = filtertrace;
        this.methods = methods;
        this.methodsSpecified = methods != null;
    }

    public void setMethods(String value) {
        this.methodsList = value;
        this.methodsSpecified = value != null;
        this.methods = null;
    }

    void setMethods(String[] value) {
        this.methods = value;
        this.methodsSpecified = value != null;
        this.methodsList = null;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setOutfile(String value) {
        this.outfile = value;
    }

    boolean hasMethodsSpecified() {
        return this.methodsSpecified;
    }

    String[] getMethods() {
        if (this.methodsSpecified && this.methods == null) {
            this.resolveMethods();
        }
        return this.methods;
    }

    String getMethodsString() {
        if (this.methodsList == null && this.methodsSpecified) {
            if (this.methods.length == 0) {
                this.methodsList = "";
            } else if (this.methods.length == 1) {
                this.methodsList = this.methods[0];
            } else {
                StringBuffer buf = new StringBuffer(this.methods.length * 16);
                buf.append(this.methods[0]);
                for (int i = 1; i < this.methods.length; ++i) {
                    buf.append(',').append(this.methods[i]);
                }
                this.methodsList = buf.toString();
            }
        }
        return this.methodsList;
    }

    void resolveMethods() {
        if (this.methods == null && this.methodsSpecified) {
            try {
                this.methods = JUnitTest.parseTestMethodNamesList(this.methodsList);
            }
            catch (IllegalArgumentException ex) {
                throw new BuildException("Invalid specification of test methods: \"" + this.methodsList + "\"; expected: comma-separated list of valid Java identifiers", (Throwable)ex);
            }
        }
    }

    public static String[] parseTestMethodNamesList(String methodNames) throws IllegalArgumentException {
        if (methodNames == null) {
            throw new IllegalArgumentException("methodNames is <null>");
        }
        int length = (methodNames = methodNames.trim()).length();
        if (length == 0) {
            return new String[0];
        }
        if (methodNames.charAt(length - 1) == ',' && (length = (methodNames = methodNames.substring(0, length - 1).trim()).length()) == 0) {
            throw new IllegalArgumentException("Empty method name");
        }
        char[] chars = methodNames.toCharArray();
        if (chars[0] == ',') {
            throw new IllegalArgumentException("Empty method name");
        }
        int wordCount = 1;
        for (int i = 1; i < chars.length; ++i) {
            if (chars[i] != ',') continue;
            ++wordCount;
        }
        String[] result = new String[wordCount];
        boolean stateBeforeWord = true;
        int stateInsideWord = 2;
        int stateAfterWord = 3;
        int state = 1;
        int wordStartIndex = -1;
        int wordIndex = 0;
        block10: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (state) {
                case 1: {
                    if (c == ',') {
                        throw new IllegalArgumentException("Empty method name");
                    }
                    if (c == ' ') continue block10;
                    if (Character.isJavaIdentifierStart(c)) {
                        wordStartIndex = i;
                        state = 2;
                        continue block10;
                    }
                    throw new IllegalArgumentException("Illegal start of method name: " + c);
                }
                case 2: {
                    if (c == ',') {
                        result[wordIndex++] = new String(methodNames.substring(wordStartIndex, i));
                        state = 1;
                        continue block10;
                    }
                    if (c == ' ') {
                        result[wordIndex++] = new String(methodNames.substring(wordStartIndex, i));
                        state = 3;
                        continue block10;
                    }
                    if (Character.isJavaIdentifierPart(c)) continue block10;
                    throw new IllegalArgumentException("Illegal character in method name: " + c);
                }
                case 3: {
                    if (c == ',') {
                        state = 1;
                        continue block10;
                    }
                    if (c == ' ') continue block10;
                    throw new IllegalArgumentException("Space in method name");
                }
            }
        }
        switch (state) {
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                result[wordIndex++] = new String(methodNames.substring(wordStartIndex, chars.length));
                break;
            }
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getOutfile() {
        return this.outfile;
    }

    public void setCounts(long runs, long failures, long errors) {
        this.runs = runs;
        this.failures = failures;
        this.errors = errors;
    }

    public void setRunTime(long runTime) {
        this.runTime = runTime;
    }

    public long runCount() {
        return this.runs;
    }

    public long failureCount() {
        return this.failures;
    }

    public long errorCount() {
        return this.errors;
    }

    public long getRunTime() {
        return this.runTime;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Hashtable p) {
        this.props = new Properties();
        Enumeration e = p.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            this.props.put(key, p.get(key));
        }
    }

    public boolean shouldRun(Project p) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper((Project)p);
        return ph.testIfCondition(this.getIfCondition()) && ph.testUnlessCondition(this.getUnlessCondition());
    }

    public FormatterElement[] getFormatters() {
        Object[] fes = new FormatterElement[this.formatters.size()];
        this.formatters.copyInto(fes);
        return fes;
    }

    void addFormattersTo(Vector v) {
        int count = this.formatters.size();
        for (int i = 0; i < count; ++i) {
            v.addElement(this.formatters.elementAt(i));
        }
    }

    public Object clone() {
        try {
            JUnitTest t = (JUnitTest)super.clone();
            t.props = this.props == null ? null : (Properties)this.props.clone();
            t.formatters = (Vector)this.formatters.clone();
            return t;
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }
}

