/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Utilities;

public final class Dependency
implements Serializable {
    static final long serialVersionUID = 9548259318L;
    public static final int TYPE_MODULE = 1;
    public static final int TYPE_PACKAGE = 2;
    public static final int TYPE_JAVA = 3;
    @Deprecated
    public static final int TYPE_IDE = 4;
    public static final int TYPE_REQUIRES = 5;
    public static final int TYPE_NEEDS = 6;
    public static final int TYPE_RECOMMENDS = 7;
    public static final int COMPARE_SPEC = 1;
    public static final int COMPARE_IMPL = 2;
    public static final int COMPARE_ANY = 3;
    @Deprecated
    public static final String IDE_NAME = System.getProperty("org.openide.major.version", "IDE");
    @Deprecated
    public static final SpecificationVersion IDE_SPEC = Dependency.makeSpec(System.getProperty("org.openide.specification.version"));
    @Deprecated
    public static final String IDE_IMPL = System.getProperty("org.openide.version");
    public static final String JAVA_NAME = "Java";
    public static final SpecificationVersion JAVA_SPEC = Dependency.makeSpec(System.getProperty("java.specification.version"));
    public static final String JAVA_IMPL = System.getProperty("java.version");
    public static final String VM_NAME = "VM";
    public static final SpecificationVersion VM_SPEC = Dependency.makeSpec(System.getProperty("java.vm.specification.version"));
    public static final String VM_IMPL = System.getProperty("java.vm.version");
    private final int type;
    private final int comparison;
    private final String name;
    private final String version;

    private Dependency(int type, String name, int comparison, String version) {
        this.type = type;
        this.name = name.intern();
        this.comparison = comparison;
        this.version = version != null ? version.intern() : null;
    }

    private static void checkCodeName(String codeName, boolean slashOK) throws IllegalArgumentException {
        String base;
        int slash = codeName.indexOf(47);
        if (slash == -1) {
            base = codeName;
        } else {
            if (!slashOK) {
                throw new IllegalArgumentException("No slash permitted in: " + codeName);
            }
            base = codeName.substring(0, slash);
            String rest = codeName.substring(slash + 1);
            int dash = rest.indexOf(45);
            try {
                int release;
                if (dash == -1) {
                    release = Integer.parseInt(rest);
                    if (release < 0) {
                        throw new IllegalArgumentException("Negative release number: " + codeName);
                    }
                } else {
                    release = Integer.parseInt(rest.substring(0, dash));
                    int releaseMax = Integer.parseInt(rest.substring(dash + 1));
                    if (release < 0) {
                        throw new IllegalArgumentException("Negative release number: " + codeName);
                    }
                    if (releaseMax <= release) {
                        throw new IllegalArgumentException("Release number range must be increasing: " + codeName);
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e.toString());
            }
        }
        StringTokenizer tok = new StringTokenizer(base, ".", true);
        if (tok.countTokens() % 2 == 0) {
            throw new NumberFormatException("Even number of pieces: " + base);
        }
        boolean expectingPath = true;
        while (tok.hasMoreTokens()) {
            if (expectingPath) {
                expectingPath = false;
                String nt = tok.nextToken();
                if (Utilities.isJavaIdentifier((String)nt) || "enum".equals(nt)) continue;
                throw new IllegalArgumentException("Bad package component in " + base);
            }
            if (!".".equals(tok.nextToken())) {
                throw new NumberFormatException("Expected dot in code name: " + base);
            }
            expectingPath = true;
        }
    }

    public static Set<Dependency> create(int type, String body) throws IllegalArgumentException {
        if (body == null) {
            return Collections.emptySet();
        }
        HashSet<Dependency> deps = new HashSet<Dependency>(5);
        StringTokenizer tok = new StringTokenizer(body, ",");
        if (!tok.hasMoreTokens()) {
            throw new IllegalArgumentException("No deps given: \"" + body + "\"");
        }
        HashMap<DependencyKey, Dependency> depsByKey = new HashMap<DependencyKey, Dependency>(11);
        while (tok.hasMoreTokens()) {
            Dependency nue;
            DependencyKey key;
            String version;
            int comparison;
            String onedep = tok.nextToken();
            StringTokenizer tok2 = new StringTokenizer(onedep, " \t\n\r");
            if (!tok2.hasMoreTokens()) {
                throw new IllegalArgumentException("No name in dependency: " + onedep);
            }
            String name = tok2.nextToken();
            if (tok2.hasMoreTokens()) {
                String compthing = tok2.nextToken();
                if (compthing.equals(">")) {
                    comparison = 1;
                } else if (compthing.equals("=")) {
                    comparison = 2;
                } else {
                    throw new IllegalArgumentException("Strange comparison string: " + compthing);
                }
                if (!tok2.hasMoreTokens()) {
                    throw new IllegalArgumentException("Comparison string without version: " + onedep);
                }
                version = tok2.nextToken();
                if (tok2.hasMoreTokens()) {
                    throw new IllegalArgumentException("Trailing garbage in dependency: " + onedep);
                }
                if (comparison == 1) {
                    try {
                        new SpecificationVersion(version);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException(nfe.toString());
                    }
                }
            } else {
                comparison = 3;
                version = null;
            }
            if (type == 1) {
                Dependency.checkCodeName(name, true);
                if (name.indexOf(45) != -1 && comparison == 2) {
                    throw new IllegalArgumentException("Cannot have an implementation dependency on a ranged release version: " + onedep);
                }
            } else if (type == 2) {
                int idx = name.indexOf(91);
                if (idx != -1) {
                    if (idx > 0) {
                        Dependency.checkCodeName(name.substring(0, idx), false);
                    }
                    if (name.charAt(name.length() - 1) != ']') {
                        throw new IllegalArgumentException("No close bracket on package dep: " + name);
                    }
                    Dependency.checkCodeName(name.substring(idx + 1, name.length() - 1), false);
                } else {
                    Dependency.checkCodeName(name, false);
                }
                if (idx == 0 && comparison != 3) {
                    throw new IllegalArgumentException("Cannot use a version comparison on a package dependency when only a sample class is given");
                }
                if (idx > 0 && name.substring(idx + 1, name.length() - 1).indexOf(46) != -1) {
                    throw new IllegalArgumentException("Cannot have a sample class with dots when package is specified");
                }
            } else if (type == 3) {
                if (!name.equals(JAVA_NAME) && !name.equals(VM_NAME)) {
                    throw new IllegalArgumentException("Java dependency must be on \"Java\" or \"VM\": " + name);
                }
                if (comparison == 3) {
                    throw new IllegalArgumentException("Must give a comparison for a Java dep: " + body);
                }
            } else if (type == 4) {
                if (!name.equals("IDE")) {
                    boolean ok2;
                    int slash = name.indexOf("/");
                    if (slash == -1) {
                        ok2 = false;
                    } else {
                        if (!name.substring(0, slash).equals("IDE")) {
                            boolean ok2 = false;
                        }
                        try {
                            int v = Integer.parseInt(name.substring(slash + 1));
                            ok2 = v >= 0;
                        }
                        catch (NumberFormatException e) {
                            ok2 = false;
                        }
                    }
                    if (!ok2) {
                        throw new IllegalArgumentException("Invalid IDE dependency: " + name);
                    }
                }
                if (comparison == 3) {
                    throw new IllegalArgumentException("Must give a comparison for an IDE dep: " + body);
                }
            } else if (type == 5) {
                if (comparison != 3) {
                    throw new IllegalArgumentException("Cannot give a comparison for a token requires dep: " + body);
                }
                Dependency.checkCodeName(name, false);
            } else if (type == 6) {
                if (comparison != 3) {
                    throw new IllegalArgumentException("Cannot give a comparison for a token needs dep: " + body);
                }
                Dependency.checkCodeName(name, false);
            } else if (type == 7) {
                if (comparison != 3) {
                    throw new IllegalArgumentException("Cannot give a comparison for a token needs dep: " + body);
                }
                Dependency.checkCodeName(name, false);
            } else {
                throw new IllegalArgumentException("unknown type");
            }
            if (depsByKey.containsKey(key = new DependencyKey(nue = new Dependency(type, name, comparison, version)))) {
                throw new IllegalArgumentException("Dependency " + nue + " duplicates the similar dependency " + depsByKey.get(key));
            }
            deps.add(nue);
            depsByKey.put(key, nue);
        }
        return deps;
    }

    public final int getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final int getComparison() {
        return this.comparison;
    }

    public final String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (o.getClass() != Dependency.class) {
            return false;
        }
        Dependency d = (Dependency)o;
        return this.type == d.type && this.comparison == d.comparison && this.name.equals(d.name) && Utilities.compareObjects((Object)this.version, (Object)d.version);
    }

    public int hashCode() {
        return 0xBC7E3 ^ this.type ^ this.name.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        if (this.type == 1) {
            buf.append("module ");
        } else if (this.type == 2) {
            buf.append("package ");
        } else if (this.type == 5) {
            buf.append("requires ");
        } else if (this.type == 6) {
            buf.append("needs ");
        } else if (this.type == 7) {
            buf.append("recommends ");
        }
        buf.append(this.name);
        if (this.comparison == 2) {
            buf.append(" = ");
            buf.append(this.version);
        } else if (this.comparison == 1) {
            buf.append(" > ");
            buf.append(this.version);
        }
        return buf.toString();
    }

    private static SpecificationVersion makeSpec(String vers) {
        if (vers != null) {
            try {
                return new SpecificationVersion(vers);
            }
            catch (NumberFormatException nfe) {
                System.err.println("WARNING: invalid specification version: " + vers);
                while (true) {
                    vers = vers.substring(0, vers.length() - 1);
                    try {
                        return new SpecificationVersion(vers);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (vers.length() > 0) continue;
                    }
                    break;
                }
            }
        }
        return new SpecificationVersion("0");
    }

    private static final class DependencyKey {
        private final int type;
        private final String name;

        public DependencyKey(Dependency d) {
            this.type = d.getType();
            switch (this.type) {
                case 1: 
                case 4: {
                    String codeName = d.getName();
                    int idx = codeName.lastIndexOf(47);
                    if (idx == -1) {
                        this.name = codeName;
                        break;
                    }
                    this.name = codeName.substring(0, idx);
                    break;
                }
                case 2: {
                    String pkgName = d.getName();
                    int idx = pkgName.indexOf(91);
                    if (idx != -1) {
                        if (idx == 0) {
                            this.name = pkgName;
                            break;
                        }
                        this.name = pkgName.substring(0, idx);
                        break;
                    }
                    this.name = pkgName;
                    break;
                }
                default: {
                    this.name = d.getName();
                }
            }
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof DependencyKey && ((DependencyKey)o).name.equals(this.name) && ((DependencyKey)o).type == this.type;
        }

        public String toString() {
            return "DependencyKey[" + this.name + "," + this.type + "]";
        }
    }
}

