/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl.hints;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.modules.java.hints.introduce.CopyFinder;
import org.netbeans.modules.java.hints.jackpot.impl.MessageImpl;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.impl.Utilities;
import org.netbeans.modules.java.hints.jackpot.impl.pm.BulkSearch;
import org.netbeans.modules.java.hints.jackpot.impl.pm.Pattern;
import org.netbeans.modules.java.hints.jackpot.spi.Hacks;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescription;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class HintsInvoker {
    private final Map<String, Long> timeLog = new HashMap<String, Long>();
    private final CompilationInfo info;
    private final int caret;
    private final int from;
    private final int to;
    private final AtomicBoolean cancel;
    private static final boolean logTimeSpentInHints = Boolean.getBoolean("java.HintsInvoker.time.in.hints");
    private final Map<String, Long> hint2SpentTime = new HashMap<String, Long>();

    public HintsInvoker(CompilationInfo compilationInfo, AtomicBoolean atomicBoolean) {
        this(compilationInfo, -1, atomicBoolean);
    }

    public HintsInvoker(CompilationInfo compilationInfo, int n, AtomicBoolean atomicBoolean) {
        this(compilationInfo, n, -1, -1, atomicBoolean);
    }

    public HintsInvoker(CompilationInfo compilationInfo, int n, int n2, AtomicBoolean atomicBoolean) {
        this(compilationInfo, -1, n, n2, atomicBoolean);
    }

    private HintsInvoker(CompilationInfo compilationInfo, int n, int n2, int n3, AtomicBoolean atomicBoolean) {
        this.info = compilationInfo;
        this.caret = n;
        this.from = n2;
        this.to = n3;
        this.cancel = atomicBoolean;
    }

    public List<ErrorDescription> computeHints(CompilationInfo compilationInfo) {
        return this.computeHints(compilationInfo, new TreePath(compilationInfo.getCompilationUnit()));
    }

    private List<ErrorDescription> computeHints(CompilationInfo compilationInfo, TreePath treePath) {
        Map.Entry<HintMetadata, Collection<? extends HintDescription>> entry2;
        LinkedList linkedList = new LinkedList();
        for (Map.Entry<HintMetadata, Collection<? extends HintDescription>> entry2 : RulesManager.getInstance().allHints.entrySet()) {
            Preferences preferences;
            HintMetadata hintMetadata = entry2.getKey();
            if (!HintsSettings.isEnabled(hintMetadata)) continue;
            if (this.caret != -1) {
                if (hintMetadata.kind == HintMetadata.Kind.SUGGESTION || hintMetadata.kind == HintMetadata.Kind.SUGGESTION_NON_GUI) {
                    linkedList.addAll((Collection)entry2.getValue());
                    continue;
                }
                preferences = RulesManager.getPreferences(hintMetadata.id, HintsSettings.getCurrentProfileId());
                if (HintsSettings.getSeverity(hintMetadata, preferences) != AbstractHint.HintSeverity.CURRENT_LINE_WARNING) continue;
                linkedList.addAll((Collection)entry2.getValue());
                continue;
            }
            if (hintMetadata.kind != HintMetadata.Kind.HINT && hintMetadata.kind != HintMetadata.Kind.HINT_NON_GUI || HintsSettings.getSeverity(hintMetadata, preferences = RulesManager.getPreferences(hintMetadata.id, HintsSettings.getCurrentProfileId())) == AbstractHint.HintSeverity.CURRENT_LINE_WARNING) continue;
            linkedList.addAll((Collection)entry2.getValue());
        }
        HashMap hashMap = new HashMap();
        entry2 = new HashMap();
        RulesManager.sortOut(linkedList, hashMap, (Map<HintDescription.PatternDescription, List<HintDescription>>)((Object)entry2));
        long l = System.currentTimeMillis();
        RulesManager.computeElementBasedHintsXXX(compilationInfo, this.cancel, hashMap, (Map<HintDescription.PatternDescription, List<HintDescription>>)((Object)entry2));
        long l2 = System.currentTimeMillis();
        this.timeLog.put("Computing Element Based Hints", l2 - l);
        List<ErrorDescription> list = this.compute(compilationInfo, treePath, hashMap, (Map<HintDescription.PatternDescription, List<HintDescription>>)((Object)entry2), new LinkedList());
        this.dumpTimeSpentInHints();
        return list;
    }

    public List<ErrorDescription> computeHints(CompilationInfo compilationInfo, Map<Tree.Kind, List<HintDescription>> map, Map<HintDescription.PatternDescription, List<HintDescription>> map2) {
        return this.computeHints(compilationInfo, map, map2, new LinkedList());
    }

    public List<ErrorDescription> computeHints(CompilationInfo compilationInfo, Map<Tree.Kind, List<HintDescription>> map, Map<HintDescription.PatternDescription, List<HintDescription>> map2, Collection<? super MessageImpl> collection) {
        return this.compute(compilationInfo, new TreePath(compilationInfo.getCompilationUnit()), map, map2, collection);
    }

    List<ErrorDescription> compute(CompilationInfo compilationInfo, TreePath treePath, Map<Tree.Kind, List<HintDescription>> map, Map<HintDescription.PatternDescription, List<HintDescription>> map2, Collection<? super MessageImpl> collection) {
        if (this.caret != -1) {
            TreePath treePath2 = compilationInfo.getTreeUtilities().pathFor(this.caret);
            return this.computeSuggestions(compilationInfo, treePath2, map, map2, collection);
        }
        if (this.from != -1 && this.to != -1) {
            return this.computeHintsInSpan(compilationInfo, map, map2, collection);
        }
        return this.computeHints(compilationInfo, treePath, map, map2, collection);
    }

    List<ErrorDescription> computeHints(CompilationInfo compilationInfo, TreePath treePath, Map<Tree.Kind, List<HintDescription>> map, Map<HintDescription.PatternDescription, List<HintDescription>> map2, Collection<? super MessageImpl> collection) {
        LinkedList<ErrorDescription> linkedList = new LinkedList<ErrorDescription>();
        long l = 0L;
        for (Map.Entry<Tree.Kind, List<HintDescription>> entry : map.entrySet()) {
            l += (long)entry.getValue().size();
        }
        this.timeLog.put("[C] Kind Based Hints", l);
        if (!map.isEmpty()) {
            long l2 = System.currentTimeMillis();
            new ScannerImpl(compilationInfo, this.cancel, map).scan(treePath, linkedList);
            long l3 = System.currentTimeMillis();
            this.timeLog.put("Kind Based Hints", l3 - l2);
        }
        this.timeLog.put("[C] Pattern Based Hints", Long.valueOf(map2.size()));
        long l4 = System.currentTimeMillis();
        Map<String, List<HintDescription.PatternDescription>> map3 = HintsInvoker.computePatternTests(map2);
        long l5 = System.currentTimeMillis();
        BulkSearch.BulkPattern bulkPattern = BulkSearch.getDefault().create(compilationInfo, map3.keySet());
        long l6 = System.currentTimeMillis();
        this.timeLog.put("Bulk Pattern preparation", l6 - l5);
        long l7 = System.currentTimeMillis();
        Map<String, Collection<TreePath>> map4 = BulkSearch.getDefault().match(compilationInfo, treePath, bulkPattern, this.timeLog);
        long l8 = System.currentTimeMillis();
        this.timeLog.put("Bulk Search", l8 - l7);
        linkedList.addAll(this.doComputeHints(compilationInfo, map4, map3, map2, collection));
        long l9 = System.currentTimeMillis();
        this.timeLog.put("Pattern Based Hints", l9 - l4);
        return linkedList;
    }

    List<ErrorDescription> computeHintsInSpan(CompilationInfo compilationInfo, Map<Tree.Kind, List<HintDescription>> map, Map<HintDescription.PatternDescription, List<HintDescription>> map2, Collection<? super MessageImpl> collection) {
        TreePath treePath = compilationInfo.getTreeUtilities().pathFor((this.from + this.to) / 2);
        while (treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf());
            int n2 = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf());
            if (n <= this.from && n2 >= this.to) break;
            treePath = treePath.getParentPath();
        }
        LinkedList<ErrorDescription> linkedList = new LinkedList<ErrorDescription>();
        if (!map.isEmpty()) {
            long l = System.currentTimeMillis();
            new ScannerImpl(compilationInfo, this.cancel, map).scan(treePath, linkedList);
            long l2 = System.currentTimeMillis();
            this.timeLog.put("Kind Based Hints", l2 - l);
        }
        if (!map2.isEmpty()) {
            long l = System.currentTimeMillis();
            Map<String, List<HintDescription.PatternDescription>> map3 = HintsInvoker.computePatternTests(map2);
            long l3 = System.currentTimeMillis();
            BulkSearch.BulkPattern bulkPattern = BulkSearch.getDefault().create(compilationInfo, map3.keySet());
            Map<String, Collection<TreePath>> map4 = BulkSearch.getDefault().match(compilationInfo, treePath, bulkPattern, this.timeLog);
            long l4 = System.currentTimeMillis();
            this.timeLog.put("Bulk Search", l4 - l3);
            linkedList.addAll(this.doComputeHints(compilationInfo, map4, map3, map2, collection));
            long l5 = System.currentTimeMillis();
            this.timeLog.put("Pattern Based Hints", l5 - l);
        }
        if (treePath != null) {
            linkedList.addAll(this.computeSuggestions(compilationInfo, treePath, map, map2, collection));
        }
        return linkedList;
    }

    List<ErrorDescription> computeSuggestions(CompilationInfo compilationInfo, TreePath treePath, Map<Tree.Kind, List<HintDescription>> map, Map<HintDescription.PatternDescription, List<HintDescription>> map2, Collection<? super MessageImpl> collection) {
        Object object;
        long l;
        LinkedList<ErrorDescription> linkedList = new LinkedList<ErrorDescription>();
        if (!map.isEmpty()) {
            l = System.currentTimeMillis();
            for (object = treePath; object != null; object = ((TreePath)object).getParentPath()) {
                new ScannerImpl(compilationInfo, this.cancel, map).scanDoNotGoDeeper((TreePath)object, linkedList);
            }
            long l2 = System.currentTimeMillis();
            this.timeLog.put("Kind Based Suggestions", l2 - l);
        }
        if (!map2.isEmpty()) {
            l = System.currentTimeMillis();
            object = HintsInvoker.computePatternTests(map2);
            HashSet<TreePath> hashSet = new HashSet<TreePath>();
            for (TreePath treePath2 = treePath; treePath2 != null; treePath2 = treePath2.getParentPath()) {
                hashSet.add(treePath2);
            }
            HashMap<String, Collection<TreePath>> hashMap = new HashMap<String, Collection<TreePath>>();
            for (String string : object.keySet()) {
                hashMap.put(string, hashSet);
            }
            linkedList.addAll(this.doComputeHints(compilationInfo, hashMap, (Map<String, List<HintDescription.PatternDescription>>)object, map2, collection));
            long l3 = System.currentTimeMillis();
            this.timeLog.put("Pattern Based Hints", l3 - l);
        }
        return linkedList;
    }

    public List<ErrorDescription> doComputeHints(CompilationInfo compilationInfo, Map<String, Collection<TreePath>> map, Map<String, List<HintDescription.PatternDescription>> map2, Map<HintDescription.PatternDescription, List<HintDescription>> map3) throws IllegalStateException {
        return this.doComputeHints(compilationInfo, map, map2, map3, new LinkedList());
    }

    public static Map<String, List<HintDescription.PatternDescription>> computePatternTests(Map<HintDescription.PatternDescription, List<HintDescription>> map) {
        HashMap<String, List<HintDescription.PatternDescription>> hashMap = new HashMap<String, List<HintDescription.PatternDescription>>();
        for (Map.Entry<HintDescription.PatternDescription, List<HintDescription>> entry : map.entrySet()) {
            String string = entry.getKey().getPattern();
            LinkedList<HintDescription.PatternDescription> linkedList = (LinkedList<HintDescription.PatternDescription>)hashMap.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList<HintDescription.PatternDescription>();
                hashMap.put(string, linkedList);
            }
            linkedList.add(entry.getKey());
        }
        return hashMap;
    }

    private List<ErrorDescription> doComputeHints(CompilationInfo compilationInfo, Map<String, Collection<TreePath>> map, Map<String, List<HintDescription.PatternDescription>> map2, Map<HintDescription.PatternDescription, List<HintDescription>> map3, Collection<? super MessageImpl> collection) throws IllegalStateException {
        LinkedList<ErrorDescription> linkedList = new LinkedList<ErrorDescription>();
        for (Map.Entry<String, Collection<TreePath>> entry : map.entrySet()) {
            for (HintDescription.PatternDescription patternDescription : map2.get(entry.getKey())) {
                HashMap<String, TypeMirror> hashMap = new HashMap<String, TypeMirror>();
                for (Map.Entry<String, String> entry2 : patternDescription.getConstraints().entrySet()) {
                    hashMap.put(entry2.getKey(), Hacks.parseFQNType(compilationInfo, entry2.getValue()));
                }
                Pattern pattern = Pattern.compile(compilationInfo, entry.getKey(), hashMap, patternDescription.getImports());
                TreePath object2 = new TreePath(compilationInfo.getCompilationUnit());
                TreePath treePath = new TreePath(object2, pattern.getPattern());
                for (TreePath treePath2 : entry.getValue()) {
                    CopyFinder.VariableAssignments variableAssignments = CopyFinder.computeVariables(compilationInfo, treePath, treePath2, this.cancel, pattern.getConstraints());
                    if (variableAssignments == null) continue;
                    HashSet<? extends String> hashSet = new HashSet<String>(Utilities.findSuppressedWarnings(compilationInfo, treePath2));
                    for (HintDescription hintDescription : map3.get(patternDescription)) {
                        Collection<? extends ErrorDescription> collection2;
                        HintMetadata hintMetadata = hintDescription.getMetadata();
                        HintContext hintContext = new HintContext(compilationInfo, hintMetadata, treePath2, variableAssignments.variables, variableAssignments.multiVariables, variableAssignments.variables2Names, collection);
                        if (!Collections.disjoint(hashSet, hintMetadata.suppressWarnings) || (collection2 = this.runHint(hintDescription, hintContext)) == null) continue;
                        linkedList.addAll(collection2);
                    }
                }
            }
        }
        return linkedList;
    }

    public Map<String, Long> getTimeLog() {
        return this.timeLog;
    }

    static boolean isInGuarded(CompilationInfo compilationInfo, TreePath treePath) {
        if (compilationInfo == null) {
            return false;
        }
        try {
            Document document = compilationInfo.getDocument();
            if (document instanceof GuardedDocument) {
                int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf());
                int n2 = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf());
                GuardedDocument guardedDocument = (GuardedDocument)document;
                MarkBlockChain markBlockChain = guardedDocument.getGuardedBlockChain();
                if (markBlockChain.compareBlock(n, n2) == 4129) {
                    return true;
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends ErrorDescription> runHint(HintDescription hintDescription, HintContext hintContext) {
        long l = System.nanoTime();
        try {
            Collection<? extends ErrorDescription> collection = hintDescription.getWorker().createErrors(hintContext);
            return collection;
        }
        finally {
            long l2 = System.nanoTime();
            this.reportSpentTime(hintDescription.getMetadata().id, l2 - l);
        }
    }

    private void reportSpentTime(String string, long l) {
        if (!logTimeSpentInHints) {
            return;
        }
        Long l2 = this.hint2SpentTime.get(string);
        if (l2 == null) {
            l2 = 0L;
        }
        this.hint2SpentTime.put(string, l2 + l);
    }

    private void dumpTimeSpentInHints() {
        if (!logTimeSpentInHints) {
            return;
        }
        ArrayList<Map.Entry<String, Long>> arrayList = new ArrayList<Map.Entry<String, Long>>(this.hint2SpentTime.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> entry, Map.Entry<String, Long> entry2) {
                return (int)Math.signum(entry.getValue() - entry2.getValue());
            }
        });
        for (Map.Entry entry : arrayList) {
            System.err.println((String)entry.getKey() + "=" + String.format("%3.2f", (double)((Long)entry.getValue()).longValue() / 1000000.0));
        }
    }

    private final class ScannerImpl
    extends CancellableTreePathScanner<Void, List<ErrorDescription>> {
        private final Stack<Set<String>> suppresWarnings;
        private final CompilationInfo info;
        private final FileObject file;
        private final ProcessingEnvironment env;
        private final Map<Tree.Kind, List<HintDescription>> hints;

        public ScannerImpl(CompilationInfo compilationInfo, AtomicBoolean atomicBoolean, Map<Tree.Kind, List<HintDescription>> map) {
            super(atomicBoolean);
            this.suppresWarnings = new Stack();
            this.info = compilationInfo;
            this.file = null;
            this.env = null;
            this.hints = map;
        }

        public ScannerImpl(FileObject fileObject, ProcessingEnvironment processingEnvironment, Map<Tree.Kind, List<HintDescription>> map) {
            super(new AtomicBoolean());
            this.suppresWarnings = new Stack();
            this.info = null;
            this.file = fileObject;
            this.env = processingEnvironment;
            this.hints = map;
        }

        private void runAndAdd(TreePath treePath, List<HintDescription> list, List<ErrorDescription> list2) {
            if (list != null && !HintsInvoker.isInGuarded(this.info, treePath)) {
                block0: for (HintDescription hintDescription : list) {
                    if (this.isCanceled()) {
                        return;
                    }
                    HintMetadata hintMetadata = hintDescription.getMetadata();
                    for (String string : hintMetadata.suppressWarnings) {
                        if (this.suppresWarnings.empty() || !this.suppresWarnings.peek().contains(string)) continue;
                        continue block0;
                    }
                    HintContext hintContext = new HintContext(this.info, hintMetadata, treePath, Collections.<String, TreePath>emptyMap(), Collections.<String, Collection<TreePath>>emptyMap(), Collections.<String, String>emptyMap());
                    Collection collection = HintsInvoker.this.runHint(hintDescription, hintContext);
                    if (collection == null) continue;
                    list2.addAll(collection);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void scan(Tree tree, List<ErrorDescription> list) {
            if (tree == null) {
                return null;
            }
            TreePath treePath = new TreePath(this.getCurrentPath(), tree);
            Tree.Kind kind = tree.getKind();
            boolean bl = this.pushSuppressWarrnings(treePath);
            try {
                this.runAndAdd(treePath, this.hints.get((Object)kind), list);
                if (this.isCanceled()) {
                    Void void_ = null;
                    return void_;
                }
                Void void_ = (Void)super.scan(tree, list);
                return void_;
            }
            finally {
                if (bl) {
                    this.suppresWarnings.pop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void scan(TreePath treePath, List<ErrorDescription> list) {
            Tree.Kind kind = treePath.getLeaf().getKind();
            boolean bl = this.pushSuppressWarrnings(treePath);
            try {
                this.runAndAdd(treePath, this.hints.get((Object)kind), list);
                if (this.isCanceled()) {
                    Void void_ = null;
                    return void_;
                }
                Void void_ = (Void)super.scan(treePath, list);
                return void_;
            }
            finally {
                if (bl) {
                    this.suppresWarnings.pop();
                }
            }
        }

        public void scanDoNotGoDeeper(TreePath treePath, List<ErrorDescription> list) {
            Tree.Kind kind = treePath.getLeaf().getKind();
            this.runAndAdd(treePath, this.hints.get((Object)kind), list);
        }

        private boolean pushSuppressWarrnings(TreePath treePath) {
            switch (treePath.getLeaf().getKind()) {
                case CLASS: 
                case METHOD: 
                case VARIABLE: {
                    Set<String> set = this.suppresWarnings.size() == 0 ? null : this.suppresWarnings.peek();
                    HashSet<String> hashSet = set == null ? new HashSet<String>() : new HashSet<String>(set);
                    Element element = this.getTrees().getElement(treePath);
                    if (element != null) {
                        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                            String string = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
                            if (!"java.lang.SuppressWarnings".equals(string)) continue;
                            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                                Object object;
                                if (!"value".equals(entry.getKey().getSimpleName().toString()) || !((object = entry.getValue().getValue()) instanceof List)) continue;
                                for (Object e : (List)object) {
                                    Object object2;
                                    if (!(e instanceof AnnotationValue) || !((object2 = ((AnnotationValue)e).getValue()) instanceof String)) continue;
                                    hashSet.add((String)object2);
                                }
                            }
                        }
                    }
                    this.suppresWarnings.push(hashSet);
                    return true;
                }
            }
            return false;
        }

        private Trees getTrees() {
            return this.info != null ? this.info.getTrees() : Trees.instance(this.env);
        }
    }
}

