/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.util.ImageUtilities;

class ErrorLabel
extends JLabel {
    public static final String PROP_IS_VALID = "isValid";
    private Document document;
    private Validator validator;
    private boolean isValid = true;

    public ErrorLabel(Document doc, Validator validator) {
        this.setText(null);
        this.setIcon(null);
        assert (null != doc);
        assert (null != validator);
        this.document = doc;
        this.validator = validator;
        this.revalidateText();
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                ErrorLabel.this.revalidateText();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                ErrorLabel.this.revalidateText();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                ErrorLabel.this.revalidateText();
            }
        });
    }

    public boolean isInputTextValid() {
        return this.isValid;
    }

    protected void revalidateText() {
        boolean oldStatus = this.isValid;
        String errMessage = null;
        try {
            errMessage = this.validator.validate(this.document.getText(0, this.document.getLength()));
        }
        catch (BadLocationException ex) {
            return;
        }
        this.isValid = errMessage == null;
        this.setText(errMessage);
        this.setIcon(null == errMessage || "".equals(errMessage) ? null : this.getErrorIcon());
        this.firePropertyChange(PROP_IS_VALID, oldStatus, this.isValid);
    }

    protected Icon getErrorIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/editor/resources/error-glyph.gif", (boolean)false);
    }

    public static interface Validator {
        public String validate(String var1);
    }
}

