/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.modules.java.hints.infrastructure.Pair;
import org.netbeans.modules.java.hints.jackpot.spi.CustomizerProvider;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescription;
import org.netbeans.modules.java.hints.jackpot.spi.HintDescriptionFactory;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.jackpot.spi.HintProvider;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.java.hints.spi.Rule;
import org.netbeans.modules.java.hints.spi.TreeRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

public class RulesManager
implements FileChangeListener {
    public static Logger LOG = Logger.getLogger("org.netbeans.modules.java.hints");
    private static final String INSTANCE_EXT = ".instance";
    private static final String NON_GUI = "nonGUI";
    private static final String RULES_FOLDER = "org-netbeans-modules-java-hints/rules/";
    private static final String ERRORS = "errors";
    private static final String HINTS = "hints";
    private static final String SUGGESTIONS = "suggestions";
    private final Map<String, Map<String, List<ErrorRule>>> mimeType2Errors = new HashMap<String, Map<String, List<ErrorRule>>>();
    private final Map<HintMetadata, Collection<? extends HintDescription>> metadata = new HashMap<HintMetadata, Collection<? extends HintDescription>>();
    private static RulesManager INSTANCE;
    private final RequestProcessor.Task refreshHints = new RequestProcessor(RulesManager.class.getName()).create(new Runnable(){

        @Override
        public void run() {
            RulesManager.this.doInit();
        }
    });

    private RulesManager() {
        this.doInit();
    }

    public static synchronized RulesManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RulesManager();
        }
        return INSTANCE;
    }

    public synchronized Map<String, List<ErrorRule>> getErrors(String string) {
        Map<String, List<ErrorRule<Object>>> map = this.mimeType2Errors.get(string);
        if (map == null) {
            map = Collections.emptyMap();
        }
        return map;
    }

    private synchronized void doInit() {
        this.initErrors();
        this.initHints();
        this.initSuggestions();
    }

    private void initErrors() {
        FileObject fileObject = FileUtil.getConfigFile((String)"org-netbeans-modules-java-hints/rules/errors");
        List<Pair<Rule, FileObject>> list = this.readRules(fileObject);
        RulesManager.categorizeErrorRules(list, this.mimeType2Errors, fileObject);
    }

    private void initHints() {
        FileObject fileObject = FileUtil.getConfigFile((String)"org-netbeans-modules-java-hints/rules/hints");
        List<Pair<Rule, FileObject>> list = this.readRules(fileObject);
        RulesManager.categorizeTreeRules(list, HintMetadata.Kind.HINT, HintMetadata.Kind.HINT_NON_GUI, this.metadata);
    }

    private void initSuggestions() {
        FileObject fileObject = FileUtil.getConfigFile((String)"org-netbeans-modules-java-hints/rules/suggestions");
        List<Pair<Rule, FileObject>> list = this.readRules(fileObject);
        RulesManager.categorizeTreeRules(list, HintMetadata.Kind.SUGGESTION, HintMetadata.Kind.SUGGESTION_NON_GUI, this.metadata);
    }

    private List<Pair<Rule, FileObject>> readRules(FileObject fileObject) {
        LinkedList<Pair<Rule, FileObject>> linkedList = new LinkedList<Pair<Rule, FileObject>>();
        if (fileObject == null) {
            return linkedList;
        }
        LinkedList<FileObject> linkedList2 = new LinkedList<FileObject>();
        linkedList2.offer(fileObject);
        while (!linkedList2.isEmpty()) {
            FileObject fileObject2 = (FileObject)linkedList2.poll();
            fileObject2.removeFileChangeListener((FileChangeListener)this);
            fileObject2.addFileChangeListener((FileChangeListener)this);
            if (fileObject2.isFolder()) {
                linkedList2.addAll(Arrays.asList(fileObject2.getChildren()));
                continue;
            }
            if (!fileObject2.isData()) continue;
            String string = fileObject2.getNameExt().toLowerCase();
            if (!fileObject2.canRead()) continue;
            Rule rule = null;
            if (string.endsWith(INSTANCE_EXT)) {
                rule = RulesManager.instantiateRule(fileObject2);
            }
            if (rule == null) continue;
            linkedList.add(new Pair<Rule, FileObject>(rule, fileObject2));
        }
        return linkedList;
    }

    private static void categorizeErrorRules(List<Pair<Rule, FileObject>> list, Map<String, Map<String, List<ErrorRule>>> map, FileObject fileObject) {
        map.clear();
        for (Pair<Rule, FileObject> pair : list) {
            Rule rule = pair.getA();
            FileObject fileObject2 = pair.getB();
            String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2.getParent());
            if (string.length() == 0) {
                string = "text/x-java";
            }
            if (rule instanceof ErrorRule) {
                Map<String, List<ErrorRule>> map2 = map.get(string);
                if (map2 == null) {
                    map2 = new HashMap<String, List<ErrorRule>>();
                    map.put(string, map2);
                }
                RulesManager.addRule((ErrorRule)rule, map2);
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fileObject2.getPath() + "is not instance of ErrorRule");
        }
    }

    private static void categorizeTreeRules(List<Pair<Rule, FileObject>> list, HintMetadata.Kind kind, HintMetadata.Kind kind2, Map<HintMetadata, Collection<? extends HintDescription>> map) {
        for (Pair<Rule, FileObject> pair : list) {
            Rule rule = pair.getA();
            FileObject fileObject = pair.getB();
            if (rule instanceof TreeRule) {
                HintMetadata hintMetadata;
                Object object;
                TreeRule treeRule = (TreeRule)rule;
                Object object2 = fileObject.getAttribute(NON_GUI);
                boolean bl = true;
                if (object2 != null && object2 instanceof Boolean && ((Boolean)object2).booleanValue()) {
                    bl = false;
                }
                FileObject fileObject2 = fileObject.getParent();
                if (rule instanceof AbstractHint) {
                    object = (AbstractHint)rule;
                    hintMetadata = HintMetadata.create(object.getId(), bl ? object.getDisplayName() : "", bl ? ((AbstractHint)object).getDescription() : "", fileObject2.getName(), HintsSettings.HINTS_ACCESSOR.isEnabledDefault((AbstractHint)object), bl ? kind : kind2, HintsSettings.HINTS_ACCESSOR.severiryDefault((AbstractHint)object), new CustomizerProviderImpl((AbstractHint)object), Arrays.asList(HintsSettings.HINTS_ACCESSOR.getSuppressBy((AbstractHint)object)));
                } else {
                    hintMetadata = HintMetadata.create(treeRule.getId(), bl ? treeRule.getDisplayName() : "", bl ? treeRule.getDisplayName() : "", fileObject2.getName(), true, bl ? kind : kind2, AbstractHint.HintSeverity.WARNING, Arrays.asList(new String[0]));
                }
                object = new LinkedList();
                for (Tree.Kind kind3 : treeRule.getTreeKinds()) {
                    object.add(HintDescriptionFactory.create().setTriggerKind(kind3).setMetadata(hintMetadata).setWorker(new WorkerImpl(treeRule)).produce());
                }
                map.put(hintMetadata, (Collection<? extends HintDescription>)object);
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fileObject.getPath() + "is not instance of TreeRule");
        }
    }

    private static void addRule(TreeRule treeRule, Map<Tree.Kind, List<TreeRule>> map) {
        for (Tree.Kind kind : treeRule.getTreeKinds()) {
            List<TreeRule> list = map.get((Object)kind);
            if (list == null) {
                list = new LinkedList<TreeRule>();
                map.put(kind, list);
            }
            list.add(treeRule);
        }
    }

    private static void addRule(ErrorRule errorRule, Map<String, List<ErrorRule>> map) {
        for (String string : errorRule.getCodes()) {
            List<ErrorRule> list = map.get(string);
            if (list == null) {
                list = new LinkedList<ErrorRule>();
                map.put(string, list);
            }
            list.add(errorRule);
        }
    }

    private static Rule instantiateRule(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            Object object = instanceCookie.instanceCreate();
            if (object instanceof Rule) {
                return (Rule)object;
            }
            return null;
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, null, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.INFO, null, classNotFoundException);
        }
        return null;
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.hintsChanged();
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.hintsChanged();
    }

    public void fileChanged(FileEvent fileEvent) {
        this.hintsChanged();
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.hintsChanged();
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.hintsChanged();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        this.hintsChanged();
    }

    private void hintsChanged() {
        this.refreshHints.cancel();
        this.refreshHints.schedule(50);
    }

    public static final class HintProviderImpl
    implements HintProvider {
        public Map<HintMetadata, Collection<? extends HintDescription>> computeHints() {
            return RulesManager.getInstance().metadata;
        }
    }

    private static class WorkerImpl
    implements HintDescription.Worker {
        private final TreeRule tr;

        public WorkerImpl(TreeRule treeRule) {
            this.tr = treeRule;
        }

        @Override
        public Collection<? extends ErrorDescription> createErrors(HintContext hintContext) {
            List<ErrorDescription> list = this.tr.run(hintContext.getInfo(), hintContext.getPath());
            if (list == null) {
                return list;
            }
            LinkedList<ErrorDescription> linkedList = new LinkedList<ErrorDescription>();
            for (ErrorDescription errorDescription : list) {
                if (errorDescription == null) continue;
                List<Fix> list2 = ErrorDescriptionFactory.resolveDefaultFixes(hintContext, errorDescription.getFixes().getFixes().toArray(new Fix[0]));
                ErrorDescription errorDescription2 = org.netbeans.spi.editor.hints.ErrorDescriptionFactory.createErrorDescription((Severity)errorDescription.getSeverity(), (String)errorDescription.getDescription(), list2, (FileObject)errorDescription.getFile(), (int)errorDescription.getRange().getBegin().getOffset(), (int)errorDescription.getRange().getEnd().getOffset());
                linkedList.add(errorDescription2);
            }
            return linkedList;
        }
    }

    private static final class CustomizerProviderImpl
    implements CustomizerProvider {
        private final AbstractHint hint;

        public CustomizerProviderImpl(AbstractHint abstractHint) {
            this.hint = abstractHint;
        }

        @Override
        public JComponent getCustomizer(Preferences preferences) {
            return this.hint.getCustomizer(preferences);
        }
    }
}

