/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ThisInAnonymous {
    private static final String THIS_KEYWORD = "this";
    private static final Set<ElementKind> LOCAL_CLASS_CONTAINERS = EnumSet.of(ElementKind.METHOD, ElementKind.CONSTRUCTOR);

    public static ErrorDescription hint(HintContext hintContext) {
        TreePath treePath = hintContext.getVariables().get("$this");
        if (treePath.getLeaf().getKind() != Tree.Kind.IDENTIFIER || !((IdentifierTree)treePath.getLeaf()).getName().contentEquals(THIS_KEYWORD)) {
            return null;
        }
        TreePath treePath2 = ThisInAnonymous.getParentClass(hintContext.getPath());
        Element element = hintContext.getInfo().getTrees().getElement(treePath2);
        String string = ThisInAnonymous.getKey(element);
        if (string != null) {
            Element element2 = hintContext.getInfo().getTrees().getElement(ThisInAnonymous.getParentClass(treePath2.getParentPath()));
            if (element2 == null || !element2.getKind().isClass() && !element2.getKind().isInterface()) {
                return null;
            }
            FixImpl fixImpl = new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)hintContext.getInfo()), (ElementHandle<TypeElement>)ElementHandle.create((Element)((TypeElement)element2)), hintContext.getInfo().getFileObject());
            String string2 = NbBundle.getMessage(ThisInAnonymous.class, (String)string);
            return ErrorDescriptionFactory.forName(hintContext, treePath, string2, fixImpl);
        }
        return null;
    }

    private static TreePath getParentClass(TreePath treePath) {
        while (treePath.getLeaf().getKind() != Tree.Kind.CLASS) {
            treePath = treePath.getParentPath();
        }
        return treePath;
    }

    private static String getKey(Element element) {
        ElementKind elementKind = element.getKind();
        if (elementKind == ElementKind.CLASS) {
            if (element.getSimpleName().length() == 0) {
                return "ERR_ThisInAnonymous";
            }
            if (LOCAL_CLASS_CONTAINERS.contains((Object)element.getEnclosingElement().getKind())) {
                return "ERR_ThisInAnonymousLocal";
            }
        }
        return null;
    }

    private static final class FixImpl
    implements Fix,
    Task<WorkingCopy> {
        private final TreePathHandle thisHandle;
        private final ElementHandle<TypeElement> parentClassElementHandle;
        private final FileObject file;

        public FixImpl(TreePathHandle treePathHandle, ElementHandle<TypeElement> elementHandle, FileObject fileObject) {
            this.thisHandle = treePathHandle;
            this.parentClassElementHandle = elementHandle;
            this.file = fileObject;
        }

        public String getText() {
            return NbBundle.getMessage(ThisInAnonymous.class, (String)"FIX_ThisInAnonymous");
        }

        public ChangeInfo implement() throws Exception {
            ModificationResult modificationResult = JavaSource.forFileObject((FileObject)this.file).runModificationTask((Task)this);
            modificationResult.commit();
            return null;
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            TreePath treePath = this.thisHandle.resolve((CompilationInfo)workingCopy);
            TypeElement typeElement = (TypeElement)this.parentClassElementHandle.resolve((CompilationInfo)workingCopy);
            assert (treePath != null);
            assert (typeElement != null);
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            workingCopy.rewrite(treePath.getLeaf(), (Tree)treeMaker.MemberSelect(treeMaker.QualIdent((Element)typeElement), (CharSequence)ThisInAnonymous.THIS_KEYWORD));
        }
    }
}

