/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.UiUtils;
import org.netbeans.installer.utils.helper.NbiThread;
import org.netbeans.installer.utils.helper.swing.NbiButton;
import org.netbeans.installer.utils.helper.swing.NbiLabel;
import org.netbeans.installer.utils.helper.swing.NbiProgressBar;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.utils.progress.ProgressListener;
import org.netbeans.installer.wizard.components.WizardComponent;
import org.netbeans.installer.wizard.containers.SwingContainer;
import org.netbeans.installer.wizard.ui.SwingUi;
import org.netbeans.installer.wizard.ui.WizardUi;

public abstract class WizardAction
extends WizardComponent {
    private WizardUi wizardUi;
    private boolean finished = false;
    private boolean canceled = false;
    private static final String RESOURCE_CANCEL_DIALOG_TITLE = "WA.cancel.dialog.title";
    private static final String RESOURCE_CANCEL_DIALOG_TEXT = "WA.cancel.dialog.text";
    private static final String RESOURCE_INTERRUPTED_EXCEPTION = "WA.error.interrupted.exception";
    private static final String RESOURCE_CANCELING_PROGRESS_TITLE = "WA.canceling.progress.title";

    protected WizardAction() {
    }

    public final void executeForward() {
        new NbiThread(){

            public void run() {
                WizardAction.this.finished = false;
                WizardAction.this.execute();
                WizardAction.this.finished = true;
                if (!WizardAction.this.canceled) {
                    WizardAction.this.getWizard().next();
                }
            }
        }.start();
    }

    public final void executeBackward() {
    }

    public final boolean canExecuteBackward() {
        return false;
    }

    public WizardActionUi getWizardUi() {
        if (this.wizardUi == null) {
            this.wizardUi = new WizardActionUi(this);
        }
        return (WizardActionUi)this.wizardUi;
    }

    public void initialize() {
    }

    public abstract void execute();

    public boolean isCancelable() {
        return true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() {
        this.canceled = true;
        while (!this.finished) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                ErrorManager.notifyDebug(RESOURCE_INTERRUPTED_EXCEPTION, e);
            }
        }
    }

    public static class WizardActionSwingUi
    extends WizardComponent.WizardComponentSwingUi {
        private WizardAction action;
        private NbiLabel titleLabel;
        private NbiLabel detailLabel;
        private NbiProgressBar progressBar;

        public WizardActionSwingUi(WizardAction action, SwingContainer container) {
            super(action, container);
            this.action = action;
            this.initComponents();
        }

        public void initializeContainer() {
            super.initializeContainer();
            this.container.getHelpButton().setEnabled(false);
            this.container.getHelpButton().setVisible(false);
            this.container.getBackButton().setEnabled(false);
            this.container.getBackButton().setVisible(false);
            this.container.getNextButton().setEnabled(false);
            this.container.getNextButton().setVisible(true);
            this.container.getCancelButton().setVisible(true);
            this.container.getCancelButton().setEnabled(this.action.isCancelable());
        }

        public void evaluateCancelButtonClick() {
            if (this.action.isCancelable()) {
                String canceldialogText;
                String cancelDialogTitle = ResourceUtils.getString(WizardAction.class, WizardAction.RESOURCE_CANCEL_DIALOG_TITLE);
                if (!UiUtils.showYesNoDialog(cancelDialogTitle, canceldialogText = ResourceUtils.getString(WizardAction.class, WizardAction.RESOURCE_CANCEL_DIALOG_TEXT))) {
                    return;
                }
                this.container.getCancelButton().setEnabled(false);
                this.titleLabel.setText(ResourceUtils.getString(WizardAction.class, WizardAction.RESOURCE_CANCELING_PROGRESS_TITLE));
                new NbiThread(){

                    public void run() {
                        WizardActionSwingUi.this.action.cancel();
                        WizardActionSwingUi.this.action.getWizard().getFinishHandler().cancel();
                    }
                }.start();
            }
        }

        public NbiButton getDefaultEnterButton() {
            return this.container.getCancelButton();
        }

        public void progressUpdated(Progress progress) {
            if (progress != null) {
                if (this.titleLabel != null) {
                    this.titleLabel.setText(progress.getTitle());
                }
                if (this.detailLabel != null) {
                    this.detailLabel.setText(progress.getDetail());
                }
                if (this.progressBar != null) {
                    this.progressBar.setValue(progress.getPercentage());
                }
            }
        }

        private void initComponents() {
            this.titleLabel = new NbiLabel();
            this.titleLabel.setFocusable(true);
            this.progressBar = new NbiProgressBar();
            this.detailLabel = new NbiLabel(true);
            this.detailLabel.setFocusable(true);
            this.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 15, 2, new Insets(11, 11, 0, 11), 0, 0));
            this.add((Component)this.progressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(4, 11, 0, 11), 0, 0));
            this.add((Component)this.detailLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 19, 2, new Insets(4, 11, 0, 11), 0, 0));
        }
    }

    public static class WizardActionUi
    extends WizardComponent.WizardComponentUi
    implements ProgressListener {
        protected WizardAction action;
        protected Progress progress;

        public WizardActionUi(WizardAction action) {
            super(action);
            this.action = action;
        }

        public SwingUi getSwingUi(SwingContainer container) {
            if (this.swingUi == null) {
                this.swingUi = new WizardActionSwingUi(this.action, container);
            }
            return super.getSwingUi(container);
        }

        public void setProgress(Progress progress) {
            if (this.progress != null) {
                this.progress.removeProgressListener(this);
            }
            this.progress = progress;
            this.progress.addProgressListener(this);
        }

        public void progressUpdated(Progress progress) {
            if (this.swingUi != null) {
                ((WizardActionSwingUi)this.swingUi).progressUpdated(progress);
            }
        }
    }
}

