/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.cli;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.cli.CLIArgumentsList;
import org.netbeans.installer.utils.cli.CLIOption;
import org.netbeans.installer.utils.cli.options.BundlePropertiesOption;
import org.netbeans.installer.utils.cli.options.CreateBundleOption;
import org.netbeans.installer.utils.cli.options.ForceInstallOption;
import org.netbeans.installer.utils.cli.options.ForceUninstallOption;
import org.netbeans.installer.utils.cli.options.IgnoreLockOption;
import org.netbeans.installer.utils.cli.options.LocaleOption;
import org.netbeans.installer.utils.cli.options.LookAndFeelOption;
import org.netbeans.installer.utils.cli.options.NoSpaceCheckOption;
import org.netbeans.installer.utils.cli.options.PlatformOption;
import org.netbeans.installer.utils.cli.options.PropertiesOption;
import org.netbeans.installer.utils.cli.options.RecordOption;
import org.netbeans.installer.utils.cli.options.RegistryOption;
import org.netbeans.installer.utils.cli.options.SilentOption;
import org.netbeans.installer.utils.cli.options.StateOption;
import org.netbeans.installer.utils.cli.options.SuggestInstallOption;
import org.netbeans.installer.utils.cli.options.SuggestUninstallOption;
import org.netbeans.installer.utils.cli.options.TargetOption;
import org.netbeans.installer.utils.cli.options.UserdirOption;
import org.netbeans.installer.utils.exceptions.CLIOptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLIHandler {
    public static final String OPTIONS_LIST = "data/clioptions.list";
    private CLIArgumentsList args;

    public CLIHandler(String[] arguments) {
        this.args = new CLIArgumentsList(arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proceed() {
        if (this.args.hasNext()) {
            LogManager.log("... parsing arguments : " + this.args.toString());
            List<CLIOption> list = this.getOptions();
            block4: while (this.args.hasNext()) {
                String currentArg = this.args.next();
                for (CLIOption option : list) {
                    Object v0;
                    if (!option.canExecute(currentArg)) continue;
                    try {
                        try {
                            option.init();
                            option.validateOptions(this.args);
                            option.execute(this.args);
                            v0 = null;
                        }
                        catch (CLIOptionException e) {
                            ErrorManager.notifyWarning(e.getMessage());
                            v0 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v0 = null;
                    }
                    Object var7_7 = v0;
                    option.finish();
                    continue block4;
                }
            }
        } else {
            LogManager.log("... no command line arguments were specified");
        }
    }

    private List<CLIOption> getOptions() {
        ArrayList<CLIOption> list = new ArrayList<CLIOption>();
        this.loadDefaultOptions(list);
        this.loadAdditionalOptions(list);
        return list;
    }

    private void loadDefaultOptions(List<CLIOption> list) {
        list.add(new BundlePropertiesOption());
        list.add(new CreateBundleOption());
        list.add(new ForceInstallOption());
        list.add(new ForceUninstallOption());
        list.add(new IgnoreLockOption());
        list.add(new LocaleOption());
        list.add(new LookAndFeelOption());
        list.add(new NoSpaceCheckOption());
        list.add(new PlatformOption());
        list.add(new PropertiesOption());
        list.add(new RecordOption());
        list.add(new RegistryOption());
        list.add(new SilentOption());
        list.add(new StateOption());
        list.add(new SuggestInstallOption());
        list.add(new SuggestUninstallOption());
        list.add(new TargetOption());
        list.add(new UserdirOption());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadAdditionalOptions(List<CLIOption> list) {
        block18: {
            InputStream is = ResourceUtils.getResource(OPTIONS_LIST);
            if (is != null) {
                String[] lines;
                LogManager.log(3, "... loading additional CLI option classes, if necessary");
                String str = StringUtils.readStream(is);
                for (String classname : lines = StringUtils.splitByLines(str)) {
                    if (classname.trim().length() <= 0) continue;
                    if (classname.trim().startsWith("#")) {
                        LogManager.log(4, "... skipping line : " + classname);
                        continue;
                    }
                    try {
                        Class<?> cl = Class.forName(classname);
                        Object obj = cl.newInstance();
                        if (obj instanceof CLIOption) {
                            LogManager.log(3, "... adding CLI class : " + obj.getClass().getName());
                            list.add((CLIOption)obj);
                            continue;
                        }
                        LogManager.log(2, "... the requested class is not instance of CLIOption:");
                        LogManager.log(2, "...... classname  : " + classname);
                        LogManager.log(2, "...... CLIOption : " + CLIOption.class.getName());
                    }
                    catch (ClassNotFoundException e) {
                        LogManager.log(2, (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        LogManager.log(2, (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        LogManager.log(2, (Throwable)e);
                    }
                    catch (NoClassDefFoundError e) {
                        LogManager.log(2, (Throwable)e);
                    }
                    catch (UnsupportedClassVersionError e) {
                        LogManager.log(2, (Throwable)e);
                    }
                }
                Object var12_17 = null;
                try {
                    is.close();
                }
                catch (IOException e2) {
                    LogManager.log(4, (Throwable)e2);
                }
                break block18;
                {
                    catch (IOException e) {
                        LogManager.log(2, (Throwable)e);
                        Object var12_18 = null;
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            LogManager.log(4, (Throwable)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var12_19 = null;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        LogManager.log(4, (Throwable)e2);
                    }
                    throw throwable;
                }
            }
        }
    }
}

