/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.product.filters;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.RegistryNode;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.product.filters.RegistryFilter;
import org.netbeans.installer.utils.helper.DetailedStatus;
import org.netbeans.installer.utils.helper.Feature;
import org.netbeans.installer.utils.helper.Platform;
import org.netbeans.installer.utils.helper.Status;
import org.netbeans.installer.utils.helper.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductFilter
implements RegistryFilter {
    private String uid;
    private List<Platform> platforms = new LinkedList<Platform>();
    private Version versionLower;
    private Version versionUpper;
    private Status status;
    private DetailedStatus detailedStatus;
    private Feature feature;
    private Boolean visible;

    public ProductFilter() {
    }

    public ProductFilter(boolean visible) {
        this();
        this.visible = visible;
    }

    public ProductFilter(Platform platform) {
        this();
        this.platforms.add(platform);
    }

    public ProductFilter(String uid, Platform platform) {
        this();
        this.uid = uid;
        this.platforms.add(platform);
    }

    public ProductFilter(String uid, Version version, Platform platform) {
        this();
        this.uid = uid;
        this.versionLower = version;
        this.versionUpper = version;
        this.platforms.add(platform);
    }

    public ProductFilter(String uid, Version version, List<Platform> platforms) {
        this();
        this.uid = uid;
        this.versionLower = version;
        this.versionUpper = version;
        this.platforms.addAll(platforms);
    }

    public ProductFilter(String uid, Version versionLower, Version versionUpper, Platform platform) {
        this();
        this.uid = uid;
        this.versionLower = versionLower;
        this.versionUpper = versionUpper;
        this.platforms.add(platform);
    }

    public ProductFilter(Status status) {
        this(status, Registry.getInstance().getTargetPlatform());
    }

    public ProductFilter(Status status, Platform platform) {
        this();
        this.status = status;
        this.platforms.add(platform);
    }

    public ProductFilter(DetailedStatus detailedStatus) {
        this(detailedStatus, Registry.getInstance().getTargetPlatform());
    }

    public ProductFilter(DetailedStatus detailedStatus, Platform platform) {
        this();
        this.detailedStatus = detailedStatus;
        this.platforms.add(platform);
    }

    public ProductFilter(Feature feature, Platform platform) {
        this();
        this.feature = feature;
        this.platforms.add(platform);
    }

    @Override
    public boolean accept(RegistryNode node) {
        if (node instanceof Product) {
            Product product = (Product)node;
            if (this.uid != null && !product.getUid().equals(this.uid)) {
                return false;
            }
            if (!(this.versionLower == null || this.versionUpper == null || product.getVersion().newerOrEquals(this.versionLower) && product.getVersion().olderOrEquals(this.versionUpper))) {
                return false;
            }
            if (this.platforms.size() > 0) {
                boolean intersects = false;
                for (Platform platform : this.platforms) {
                    for (Platform productPlatform : product.getPlatforms()) {
                        if (!platform.isCompatibleWith(productPlatform) && !productPlatform.isCompatibleWith(platform)) continue;
                        intersects = true;
                    }
                    if (!intersects) continue;
                    break;
                }
                if (!intersects) {
                    return false;
                }
            }
            if (this.status != null && product.getStatus() != this.status) {
                return false;
            }
            if (this.detailedStatus != null && product.getDetailedStatus() != this.detailedStatus) {
                return false;
            }
            if (this.feature != null) {
                for (String id : product.getFeatures()) {
                    if (!this.feature.getId().equals(id)) continue;
                    return false;
                }
            }
            return this.visible == null || product.isVisible() == this.visible.booleanValue();
        }
        return false;
    }
}

