/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

class TypesFilter {
    private Set<String> enabledProviders = new HashSet<String>();
    private int countLimit = 100;

    public TypesFilter() {
        this.addDefaultTypes();
    }

    private TypesFilter(TypesFilter src) {
        this.countLimit = src.countLimit;
        this.enabledProviders.addAll(src.enabledProviders);
    }

    public boolean isEnabled(String type) {
        return this.enabledProviders.contains(type);
    }

    public void setEnabled(String type, boolean enabled) {
        if (enabled) {
            this.enabledProviders.add(type);
        } else {
            this.enabledProviders.remove(type);
        }
    }

    public boolean isTaskCountLimitReached(int taskCount) {
        return taskCount >= this.countLimit;
    }

    public void setTaskCountLimit(int limit) {
        this.countLimit = limit;
    }

    public int getTaskCountLimit() {
        return this.countLimit;
    }

    public TypesFilter clone() {
        return new TypesFilter(this);
    }

    void clear() {
        this.enabledProviders.clear();
    }

    void load(Preferences prefs, String prefix) throws BackingStoreException {
        this.countLimit = prefs.getInt(prefix + "_countLimit", 100);
        this.enabledProviders.clear();
        String enabled = prefs.get(prefix + "_enabled", "");
        if (enabled.trim().length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(enabled, "\n");
            while (tokenizer.hasMoreTokens()) {
                this.enabledProviders.add(tokenizer.nextToken());
            }
        } else {
            this.addDefaultTypes();
        }
    }

    void save(Preferences prefs, String prefix) throws BackingStoreException {
        prefs.putInt(prefix + "_countLimit", this.countLimit);
        StringBuffer buffer = new StringBuffer();
        Iterator<String> type = this.enabledProviders.iterator();
        while (type.hasNext()) {
            buffer.append(type.next());
            if (!type.hasNext()) continue;
            buffer.append("\n");
        }
        prefs.put(prefix + "_enabled", buffer.toString());
    }

    private void addDefaultTypes() {
        this.enabledProviders.add("org.netbeans.modules.java.source.tasklist.JavaTaskProvider");
        this.enabledProviders.add("org.netbeans.modules.tasklist.todo.TodoTaskScanner");
        this.enabledProviders.add("org.netbeans.modules.csl.core.GsfTaskProvider");
        this.enabledProviders.add("org.netbeans.modules.bugtracking.tasklist.TaskListProvider");
        this.enabledProviders.add("org.netbeans.modules.javafx.source.tasklist.JavaFXErrorTaskListProvider");
    }
}

