/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.nativeaccess;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.awt.Shape;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.core.nativeaccess.transparency.WindowUtils;
import org.netbeans.core.windows.nativeaccess.NativeWindowSystem;

public class NativeWindowSystemImpl
extends NativeWindowSystem {
    private static final Logger LOG = Logger.getLogger(NativeWindowSystemImpl.class.getName());

    public NativeWindowSystemImpl() {
        this.extractNativeLibrary();
    }

    public boolean isWindowAlphaSupported() {
        if (!NativeWindowSystemImpl.is32Bit()) {
            return false;
        }
        boolean res = false;
        try {
            res = WindowUtils.isWindowAlphaSupported();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (UnsatisfiedLinkError e) {
            LOG.log(Level.FINE, null, e);
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, null, e);
        }
        return res;
    }

    private static boolean is32Bit() {
        String osarch = System.getProperty("os.arch");
        for (String x : new String[]{"x86", "i386", "i486", "i586", "i686"}) {
            if (!x.equals(osarch)) continue;
            return true;
        }
        return false;
    }

    public void setWindowAlpha(Window w, float alpha) {
        try {
            WindowUtils.setWindowAlpha(w, alpha);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, null, e);
        }
    }

    public void setWindowMask(Window w, Shape mask) {
        try {
            WindowUtils.setWindowMask(w, mask);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, null, e);
        }
    }

    public void setWindowMask(Window w, Icon mask) {
        try {
            WindowUtils.setWindowMask(w, mask);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractNativeLibrary() {
        String userDir = System.getProperty("netbeans.user");
        if (null == userDir) {
            return;
        }
        File jnaDir = new File(new File(new File(userDir, "var"), "cache"), "jna");
        if (!jnaDir.exists() && !jnaDir.mkdirs()) {
            return;
        }
        if (!jnaDir.canWrite()) {
            return;
        }
        String libname = System.mapLibraryName("jnidispatch");
        String arch = System.getProperty("os.arch");
        String name = System.getProperty("os.name");
        File jnaLib = new File(jnaDir, libname);
        if (jnaLib.exists() && jnaLib.canRead()) {
            System.setProperty("jna.boot.library.path", jnaDir.getAbsolutePath());
            return;
        }
        String resourceName = NativeWindowSystemImpl.getNativeLibraryResourcePath(arch, name) + "/" + libname;
        URL url = Native.class.getResource(resourceName);
        if (url == null && Platform.isMac() && resourceName.endsWith(".dylib")) {
            resourceName = resourceName.substring(0, resourceName.lastIndexOf(".dylib")) + ".jnilib";
            url = Native.class.getResource(resourceName);
        }
        if (url == null) {
            return;
        }
        if (!url.getProtocol().toLowerCase().equals("file")) {
            InputStream is = Native.class.getResourceAsStream(resourceName);
            if (is == null) {
                return;
            }
            FileOutputStream fos = null;
            try {
                int count;
                fos = new FileOutputStream(jnaLib);
                byte[] buf = new byte[1024];
                while ((count = is.read(buf, 0, buf.length)) > 0) {
                    fos.write(buf, 0, count);
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (jnaLib.exists() && jnaLib.canRead()) {
            System.setProperty("jna.boot.library.path", jnaDir.getAbsolutePath());
        }
    }

    static String getNativeLibraryResourcePath(String arch, String name) {
        String osPrefix;
        arch = arch.toLowerCase();
        if (Platform.isWindows()) {
            if ("i386".equals(arch)) {
                arch = "x86";
            }
            osPrefix = "win32-" + arch;
        } else if (Platform.isMac()) {
            osPrefix = "darwin";
        } else if (Platform.isLinux()) {
            if ("x86".equals(arch)) {
                arch = "i386";
            } else if ("x86_64".equals(arch)) {
                arch = "amd64";
            }
            osPrefix = "linux-" + arch;
        } else if (Platform.isSolaris()) {
            osPrefix = "sunos-" + arch;
        } else {
            int space;
            osPrefix = name.toLowerCase();
            if ("x86".equals(arch)) {
                arch = "i386";
            }
            if ("x86_64".equals(arch)) {
                arch = "amd64";
            }
            if ("powerpc".equals(arch)) {
                arch = "ppc";
            }
            if ((space = osPrefix.indexOf(" ")) != -1) {
                osPrefix = osPrefix.substring(0, space);
            }
            osPrefix = osPrefix + "-" + arch;
        }
        return "/com/sun/jna/" + osPrefix;
    }
}

