/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.io.UnsupportedEncodingException;
import org.apache.tomcat.util.BuffTool;

public class MsgBuffer {
    byte[] buff;
    int len;
    int pos;
    int maxlen;

    public MsgBuffer(int size) {
        this.buff = new byte[size];
        this.maxlen = size;
    }

    public MsgBuffer(byte[] b) {
        this.buff = b;
        this.maxlen = b.length;
    }

    public void appendByte(byte val) {
        this.buff[this.pos] = val;
        ++this.pos;
    }

    public void appendBytes(byte[] b, int off, int len) {
        BuffTool.addInt(this.buff, this.pos, len);
        this.pos += 2;
        if (this.pos + len > this.buff.length) {
            System.out.println("Buffer overflow " + this.buff.length + " " + this.pos + " " + len);
        }
        System.arraycopy(b, off, this.buff, this.pos, len);
        this.buff[this.pos + len] = 0;
        this.pos += len;
        ++this.pos;
    }

    public void appendInt(int val) {
        BuffTool.addInt(this.buff, this.pos, val);
        this.pos += 2;
    }

    public void appendString(String val) {
        this.pos = BuffTool.addString(this.buff, this.pos, val);
    }

    public int checkIn() {
        this.pos = 4;
        int mark = BuffTool.getInt(this.buff, 0);
        this.len = BuffTool.getInt(this.buff, 2);
        if (mark != 4660) {
            System.out.println("BAD packet " + mark);
            this.dump("In: ");
            return -1;
        }
        return this.len;
    }

    public void dump(String msg) {
        System.out.println(String.valueOf(msg) + ": " + this.buff + " " + this.pos + "/" + this.len + "/" + this.maxlen);
        int j = 0;
        while (j < this.len + 16) {
            this.hexLine(j);
            j += 16;
        }
        System.out.println();
    }

    public void end() {
        this.len = this.pos;
        this.setInt(2, this.len - 4);
    }

    public byte[] getBuff() {
        return this.buff;
    }

    public byte getByte() {
        byte res = this.buff[this.pos];
        ++this.pos;
        return res;
    }

    public int getBytes(byte[] dest) {
        int ll = this.getInt();
        if (ll > this.buff.length) {
            System.out.println("XXX Assert failed, buff too small ");
        }
        if (ll == 65535 || ll == -1) {
            System.out.println("null string " + ll);
            return 0;
        }
        System.arraycopy(this.buff, this.pos, dest, 0, ll);
        this.pos += ll;
        ++this.pos;
        return ll;
    }

    public int getInt() {
        int res = BuffTool.getInt(this.buff, this.pos);
        this.pos += 2;
        return res;
    }

    public int getLen() {
        return this.len;
    }

    public int getMaxLen() {
        return this.maxlen;
    }

    public String getString() throws UnsupportedEncodingException {
        int ll = this.getInt();
        if (ll == 65535 || ll == -1) {
            return null;
        }
        String s = BuffTool.getString(this.buff, this.pos, ll);
        this.pos += ll;
        ++this.pos;
        return s;
    }

    private String hex(int x) {
        String h = Integer.toHexString(x);
        if (h.length() == 1) {
            h = "0" + h;
        }
        return h.substring(h.length() - 2);
    }

    private void hexLine(int start) {
        int i = start;
        while (i < start + 16) {
            System.out.print(String.valueOf(this.hex(this.buff[i])) + " ");
            ++i;
        }
        System.out.print(" | ");
        int i2 = start;
        while (i2 < start + 16) {
            if (Character.isLetterOrDigit((char)this.buff[i2])) {
                System.out.print(new Character((char)this.buff[i2]));
            } else {
                System.out.print(".");
            }
            ++i2;
        }
        System.out.println();
    }

    public byte peekByte() {
        return this.buff[this.pos];
    }

    public int peekInt() {
        return BuffTool.getInt(this.buff, this.pos);
    }

    public void reset() {
        this.len = 4;
        this.pos = 4;
        this.buff[0] = 65;
        this.buff[1] = 66;
    }

    public void setBuff(byte[] b) {
        this.buff = b;
        this.maxlen = b.length;
    }

    public void setInt(int bpos, int val) {
        BuffTool.addInt(this.buff, bpos, val);
    }
}

