/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.completion;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.web.common.api.FileReferenceCompletion;
import org.netbeans.modules.web.common.api.ValueCompletion;
import org.openide.filesystems.FileObject;

public abstract class AttrValuesCompletion {
    private static final Map<String, Map<String, ValueCompletion<HtmlCompletionItem>>> SUPPORTS = new HashMap<String, Map<String, ValueCompletion<HtmlCompletionItem>>>();
    public static final ValueCompletion<HtmlCompletionItem> FILE_NAME_SUPPORT = new FilenameSupport();
    private static final ValueCompletion<HtmlCompletionItem> CONTENT_TYPE_SUPPORT = new ContentTypeSupport();

    private static void putSupport(String tag, String attr, ValueCompletion<HtmlCompletionItem> support) {
        Map<String, ValueCompletion<HtmlCompletionItem>> map = SUPPORTS.get(tag);
        if (map == null) {
            map = new HashMap<String, ValueCompletion<HtmlCompletionItem>>();
            SUPPORTS.put(tag, map);
        }
        map.put(attr, support);
    }

    public static Map<String, ValueCompletion<HtmlCompletionItem>> getSupportsForTag(String tag) {
        return SUPPORTS.get(tag.toLowerCase(Locale.ENGLISH));
    }

    public static ValueCompletion<HtmlCompletionItem> getSupport(String tag, String attr) {
        Map<String, ValueCompletion<HtmlCompletionItem>> map = AttrValuesCompletion.getSupportsForTag(tag);
        if (map == null) {
            return null;
        }
        return map.get(attr.toLowerCase(Locale.ENGLISH));
    }

    static {
        AttrValuesCompletion.putSupport("a", "href", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("area", "href", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("link", "href", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("base", "href", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("script", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("img", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("img", "longdesc", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("img", "usemap", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("input", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("frame", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("iframe", "src", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("body", "background", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("input", "usemap", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("object", "classid", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("object", "codebase", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("object", "data", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("object", "usemap", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("applet", "codebase", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("q", "cite", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("blackquote", "cite", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("ins", "cite", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("del", "cite", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("form", "action", FILE_NAME_SUPPORT);
        AttrValuesCompletion.putSupport("script", "type", CONTENT_TYPE_SUPPORT);
        AttrValuesCompletion.putSupport("style", "type", CONTENT_TYPE_SUPPORT);
        AttrValuesCompletion.putSupport("link", "type", CONTENT_TYPE_SUPPORT);
    }

    public static class FilenameSupport
    extends FileReferenceCompletion<HtmlCompletionItem> {
        public HtmlCompletionItem createFileItem(int anchor, String name, Color color, ImageIcon icon) {
            return HtmlCompletionItem.createFileCompletionItem(name, anchor, color, icon);
        }

        public HtmlCompletionItem createGoUpItem(int anchor, Color color, ImageIcon icon) {
            return HtmlCompletionItem.createGoUpFileCompletionItem(anchor, color, icon);
        }
    }

    public static class ContentTypeSupport
    implements ValueCompletion {
        public static String[] TYPICAL_CONTENT_TYPES = new String[]{"text/css", "text/javascript"};

        public List<HtmlCompletionItem> getItems(FileObject file, int offset, String valuePart) {
            ArrayList<HtmlCompletionItem> items = new ArrayList<HtmlCompletionItem>();
            for (int i = 0; i < TYPICAL_CONTENT_TYPES.length; ++i) {
                if (!TYPICAL_CONTENT_TYPES[i].startsWith(valuePart)) continue;
                items.add(HtmlCompletionItem.createAttributeValue(TYPICAL_CONTENT_TYPES[i], offset));
            }
            return items;
        }
    }
}

