/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api.gsf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.Registry;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.editor.ext.html.parser.SyntaxParserResult;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.HtmlVersion;
import org.netbeans.modules.html.editor.gsf.HtmlParserResultAccessor;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class HtmlParserResult
extends ParserResult {
    public static final String FALLBACK_DTD_PROPERTY_NAME = "fallbackDTD";
    private SyntaxParserResult result;
    private List<Error> errors;
    private boolean isValid = true;

    private HtmlParserResult(Snapshot snapshot, SyntaxParserResult result) {
        super(snapshot);
        this.result = result;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public HtmlVersion getHtmlVersion() {
        String publicId = this.result.getPublicID();
        if (publicId == null) {
            FileObject fo = this.getSnapshot().getSource().getFileObject();
            if (fo != null) {
                if ("text/xhtml".equals(fo.getMIMEType())) {
                    return HtmlVersion.XHTML10;
                }
                if (this.result.getDeclaredNamespaces().containsKey(HtmlVersion.XHTML10.getDefaultNamespace())) {
                    return HtmlVersion.XHTML10;
                }
            }
            return HtmlVersion.UNKNOWN;
        }
        return HtmlVersion.findHtmlVersion(publicId);
    }

    public DTD dtd() {
        return this.result.getDTD();
    }

    public AstNode root() {
        return this.root(this.getHtmlVersion().getDefaultNamespace());
    }

    public AstNode root(String namespace) {
        DTD dtd = null;
        if (namespace == null || namespace != null && namespace.equals(this.getHtmlVersion().getDefaultNamespace())) {
            dtd = this.getFallbackDTD(this.getHtmlVersion());
        }
        return this.result.getASTRoot(namespace, dtd);
    }

    private DTD getFallbackDTD(HtmlVersion version) {
        String fallbackPublicID = version == HtmlVersion.UNKNOWN ? HtmlVersion.HTML41.getFallbackPublicId() : version.getFallbackPublicId();
        return Registry.getDTD((String)fallbackPublicID, null);
    }

    public Map<String, AstNode> roots() {
        HashMap<String, AstNode> roots = new HashMap<String, AstNode>();
        for (String uri : this.getNamespaces().keySet()) {
            roots.put(uri, this.root(uri));
        }
        if (!roots.containsValue(this.root())) {
            roots.put(null, this.root());
        }
        return roots;
    }

    public Map<String, String> getNamespaces() {
        return this.result.getDeclaredNamespaces();
    }

    public AstNode findLeaf(int offset) {
        return this.findLeaf(offset, false);
    }

    public AstNode findLeaf(int offset, boolean exclusiveStartOffset) {
        AstNode mostLeaf = AstNodeUtils.findDescendant((AstNode)this.root(), (int)offset, (boolean)exclusiveStartOffset);
        for (String uri : this.getNamespaces().keySet()) {
            AstNode root = this.root(uri);
            AstNode leaf = AstNodeUtils.findDescendant((AstNode)root, (int)offset, (boolean)exclusiveStartOffset);
            if (mostLeaf == null) {
                mostLeaf = leaf;
                continue;
            }
            if (leaf.logicalStartOffset() <= mostLeaf.logicalStartOffset()) continue;
            mostLeaf = leaf;
        }
        return mostLeaf;
    }

    public AstNode findLeafTag(int offset, boolean useLogicalRanges, boolean forward) {
        AstNode mostLeaf = AstNodeUtils.findDescendantTag((AstNode)this.root(), (int)offset, (boolean)useLogicalRanges, (boolean)forward);
        for (String uri : this.getNamespaces().keySet()) {
            AstNode root = this.root(uri);
            AstNode leaf = AstNodeUtils.findDescendantTag((AstNode)root, (int)offset, (boolean)useLogicalRanges, (boolean)forward);
            if (leaf == null) continue;
            if (mostLeaf == null) {
                mostLeaf = leaf;
                continue;
            }
            if (leaf.logicalStartOffset() <= mostLeaf.logicalStartOffset()) continue;
            mostLeaf = leaf;
        }
        return mostLeaf;
    }

    public List<SyntaxElement> elementsList() {
        return this.result.getElements();
    }

    public synchronized List<? extends Error> getDiagnostics() {
        if (this.errors == null) {
            this.errors = new ArrayList<Error>(this.findErrors());
        }
        return this.errors;
    }

    protected void invalidate() {
        this.isValid = false;
    }

    private List<Error> findErrors() {
        final ArrayList<Error> _errors = new ArrayList<Error>();
        AstNodeVisitor errorsCollector = new AstNodeVisitor(){

            public void visit(AstNode node) {
                if (node.type() == AstNode.NodeType.OPEN_TAG || node.type() == AstNode.NodeType.ENDTAG || node.type() == AstNode.NodeType.UNKNOWN_TAG) {
                    for (AstNode.Description desc : node.getDescriptions()) {
                        if (desc.getType() < 1) continue;
                        DefaultError error = new DefaultError(desc.getKey(), desc.getText(), desc.getText(), HtmlParserResult.this.getSnapshot().getSource().getFileObject(), desc.getFrom(), desc.getTo(), false, desc.getType() == 1 ? Severity.WARNING : Severity.ERROR);
                        error.setParameters(new Object[]{node});
                        _errors.add(error);
                    }
                }
            }
        };
        ArrayList<AstNode> roots = new ArrayList<AstNode>();
        roots.addAll(this.roots().values());
        roots.add(this.root(SyntaxParserResult.UNDECLARED_TAGS_NAMESPACE));
        for (AstNode root : roots) {
            AstNodeUtils.visitChildren((AstNode)root, (AstNodeVisitor)errorsCollector);
        }
        return _errors;
    }

    public static AstNode getBoundAstNode(Error e) {
        if (e instanceof DefaultError && e.getParameters() != null && e.getParameters().length > 0 && e.getParameters()[0] instanceof AstNode) {
            return (AstNode)e.getParameters()[0];
        }
        return null;
    }

    static {
        HtmlParserResultAccessor.set(new Accessor());
    }

    private static class Accessor
    extends HtmlParserResultAccessor {
        private Accessor() {
        }

        @Override
        public HtmlParserResult createInstance(Snapshot snapshot, SyntaxParserResult result) {
            return new HtmlParserResult(snapshot, result);
        }
    }
}

