/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultButtonModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.GetSourcesFromKenaiAction;
import org.netbeans.modules.kenai.ui.SourceAccessorImpl;
import org.netbeans.modules.kenai.ui.project.RefreshableContentPanel;
import org.netbeans.modules.kenai.ui.project.kenaiProjectTopComponent;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SourcesInformationPanel
extends JPanel
implements RefreshableContentPanel {
    public static final int MAX_ENTRIES = 20;
    private final String WAIT_STRING = String.format("<html><table cellpadding=\"0\" border=\"0\" cellspacing=\"0\"><tr><td width=\"30\"><img src=\"%s\"></td><td>%s</td></tr></table></html>", SourcesInformationPanel.class.getResource("/org/netbeans/modules/kenai/ui/resources/wait.gif"), NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_WAIT"));
    private List<String> registeredButtonID = new LinkedList<String>();
    private HashMap<String, KenaiFeature> repoMap = new HashMap();
    private JTextPane srcFeedPane;

    public SourcesInformationPanel(JScrollBar vbar) {
        this.initComponents();
        this.srcFeedPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    SourcesInformationPanel.this.srcFeedPane.setCursor(Cursor.getPredefinedCursor(12));
                    if (e.getDescription().startsWith("http://") || e.getDescription().startsWith("https://")) {
                        SourcesInformationPanel.this.srcFeedPane.setToolTipText(e.getDescription());
                    }
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    SourcesInformationPanel.this.srcFeedPane.setCursor(Cursor.getDefaultCursor());
                    SourcesInformationPanel.this.srcFeedPane.setToolTipText("");
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(e.getURL());
                    return;
                }
            }
        });
    }

    private void registerHTMLButton(HTMLDocument htm, String elementID, ActionListener action) {
        Element e = htm.getElement(elementID);
        if (e != null) {
            AttributeSet attr = e.getAttributes();
            Enumeration<?> enu = attr.getAttributeNames();
            while (enu.hasMoreElements()) {
                Object name = enu.nextElement();
                Object value = attr.getAttribute(name);
                if (!"model".equals(name.toString())) continue;
                DefaultButtonModel model = (DefaultButtonModel)value;
                model.setActionCommand(elementID);
                model.addActionListener(action);
            }
        }
    }

    private String addRepoHeaderWithButton(KenaiFeature repo, String htmlID, int order) {
        String _appString = "";
        if (repo.getService().equals("subversion") || repo.getService().equals("mercurial")) {
            String repotype = "MSG_MERCURIAL";
            if (repo.getService().equals("subversion")) {
                repotype = "MSG_SUBVERSION";
            }
            _appString = _appString + String.format("<a name=\"repo%d\"></a><table cellpadding=\"0\" border=\"0\" cellspacing=\"0\"><tr><td><h3>%s (%s)</h3></td><td width=\"200\" align=\"right\"><input type=\"reset\" id=\"%s\" value=\"%s\"></td></tr></table>", order, repo.getDisplayName(), NbBundle.getMessage(SourcesInformationPanel.class, (String)repotype), htmlID, NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_GET_THIS_REPO"));
        } else {
            String repotype = "MSG_UNKNOWN_SCM";
            if (repo.getService().equals("git")) {
                repotype = "MSG_GIT";
            }
            _appString = _appString + String.format("<a name=\"repo%d\"></a><h3>%s (%s)</h3>", order, repo.getDisplayName(), NbBundle.getMessage(SourcesInformationPanel.class, (String)repotype));
        }
        return _appString;
    }

    private void initComponents() {
        this.srcFeedPane = new JTextPane();
        this.setLayout(new BorderLayout());
        this.srcFeedPane.setContentType(NbBundle.getMessage(SourcesInformationPanel.class, (String)"SourcesInformationPanel.srcFeedPane.contentType"));
        this.srcFeedPane.setEditable(false);
        this.srcFeedPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SourcesInformationPanel.this.srcFeedPaneFocusGained(evt);
            }
        });
        this.add((Component)this.srcFeedPane, "Center");
    }

    private void srcFeedPaneFocusGained(FocusEvent evt) {
        this.srcFeedPane.getCaret().setVisible(false);
    }

    public String loadRepoFeeds(KenaiProject proj) throws DOMException {
        this.registeredButtonID.clear();
        this.repoMap.clear();
        String _appString = "<div class=\"section\">";
        try {
            KenaiFeature repo;
            int k;
            KenaiFeature[] repos = proj.getFeatures(KenaiService.Type.SOURCE);
            if (repos.length == 0) {
                return String.format("<div class=\"section\"><i>%s</i></div>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_NO_REPOS"));
            }
            if (repos.length > 1) {
                _appString = _appString + String.format("<h3>%s</h3>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_REPO_LIST"));
                for (k = 0; k < repos.length; ++k) {
                    if (Thread.interrupted()) {
                        return this.WAIT_STRING;
                    }
                    repo = repos[k];
                    String repotype = "MSG_UNKNOWN_SCM";
                    if (repo.getService().equals("subversion")) {
                        repotype = "MSG_SUBVERSION";
                    } else if (repo.getService().equals("git")) {
                        repotype = "MSG_GIT";
                    } else if (repo.getService().equals("mercurial")) {
                        repotype = "MSG_MERCURIAL";
                    }
                    _appString = _appString + String.format("<div class=\"item\">-&nbsp;%s <i>(%s)</i></div>", repo.getDisplayName(), NbBundle.getMessage(SourcesInformationPanel.class, (String)repotype));
                }
            }
            for (k = 0; k < repos.length; ++k) {
                if (Thread.interrupted()) {
                    return this.WAIT_STRING;
                }
                repo = repos[k];
                if (repo == null) continue;
                DocumentBuilder dbf = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                String base = proj.getKenai().getUrl().toString().replaceFirst("https://", "http://");
                String urlStr = base + repo.getWebLocation().getPath().replaceAll("/show$", "/history.atom");
                int entriesCount = 0;
                NodeList entries = null;
                String htmlID = repo.getName().replaceAll("[^a-zA-Z0-9]", "_") + "_" + k + "__" + proj.getName().replace('-', '_');
                this.repoMap.put(htmlID, repo);
                this.registeredButtonID.add(htmlID);
                try {
                    new URL(urlStr).openStream();
                    if (Thread.interrupted()) {
                        return this.WAIT_STRING;
                    }
                    Document doc = dbf.parse(urlStr);
                    entries = doc.getElementsByTagName("entry");
                    entriesCount = entries.getLength();
                }
                catch (FileNotFoundException e) {
                    _appString = _appString + "<br>" + this.addRepoHeaderWithButton(repo, htmlID, k);
                    _appString = _appString + String.format("<i>%s</i><br>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_REPO_NOT_ON_KENAI"));
                    _appString = _appString + String.format("<p>&nbsp;&nbsp;&nbsp;&nbsp;%s&nbsp;<a href=\"%s\">%s</a></p>", kenaiProjectTopComponent.linkImageHTML, repo.getWebLocation(), repo.getWebLocation());
                    _appString = _appString + "<br><div style=\"height: 0px; font-size: 0px; border-width: 1px; border-style: solid; border-color: silver\"></div><br>";
                    continue;
                }
                catch (IOException e) {
                    _appString = _appString + "<br>" + this.addRepoHeaderWithButton(repo, htmlID, k);
                    _appString = _appString + String.format("<i>%s</i><br>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_CANNOT_OPEN_FEED", (Object)urlStr));
                    _appString = _appString + String.format("<p>&nbsp;&nbsp;&nbsp;&nbsp;%s&nbsp;<a href=\"%s\">%s</a></p>", kenaiProjectTopComponent.linkImageHTML, repo.getWebLocation(), repo.getWebLocation());
                    _appString = _appString + "<br><div style=\"height: 0px; font-size: 0px; border-width: 1px; border-style: solid; border-color: silver\"></div><br>";
                    continue;
                }
                if (Thread.interrupted()) {
                    return this.WAIT_STRING;
                }
                _appString = _appString + this.addRepoHeaderWithButton(repo, htmlID, k);
                if (Thread.interrupted()) {
                    return this.WAIT_STRING;
                }
                _appString = _appString + "<table cellspacing=\"0\" border=\"0\" cellpadding=\"0\">";
                _appString = _appString + String.format("<tr><td colspan=\"4\"><h4>%s</h4></td></tr>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_RECENT_CHANGES"));
                if (entriesCount > 0 && entries != null) {
                    _appString = _appString + "<tr>";
                    for (int i = 0; i < entriesCount && i < 20; ++i) {
                        if (Thread.interrupted()) {
                            return this.WAIT_STRING;
                        }
                        Node entry = entries.item(i);
                        NodeList entryProps = entry.getChildNodes();
                        String title = null;
                        String updated = "";
                        String content = String.format("<i>%s</i>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_NO_COMMIT_MSG"));
                        String href = null;
                        for (int j = 0; j < entryProps.getLength(); ++j) {
                            Node firstChild;
                            if (Thread.interrupted()) {
                                return this.WAIT_STRING;
                            }
                            Node elem = entryProps.item(j);
                            if (elem.getNodeName().equals("title")) {
                                firstChild = elem.getFirstChild();
                                if (firstChild == null) continue;
                                title = firstChild.getNodeValue();
                                continue;
                            }
                            if (elem.getNodeName().equals("updated")) {
                                updated = elem.getFirstChild().getNodeValue();
                                continue;
                            }
                            if (elem.getNodeName().equals("link")) {
                                href = elem.getAttributes().getNamedItem("href").getNodeValue();
                                if (href.startsWith(base)) continue;
                                href = base + href;
                                continue;
                            }
                            if (!elem.getNodeName().equals("content") || (firstChild = elem.getFirstChild()) == null) continue;
                            content = firstChild.getNodeValue();
                        }
                        if (title == null || href == null) continue;
                        _appString = _appString + String.format("<td style=\"padding-top: 4px;\" valign=\"top\">%s</td><td valign=\"top\" style=\"padding-left: 3px;\"><a title=\"test\" href=\"%s\">%s</a></td><td style=\"padding-left: 4px\" valign=\"top\"><i>%s:</i></td><td style=\"padding-left: 4px\" valign=\"top\">%s</td></tr>", kenaiProjectTopComponent.linkImageHTML, href, title, updated.replaceAll("[a-zA-Z]", "&nbsp;"), content);
                    }
                } else {
                    _appString = _appString + String.format("<tr><td colspan=\"4\"><i>%s</i></td></tr>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_NO_CHANGES"));
                }
                _appString = _appString + "</table><br><div style=\"height: 0px; font-size: 0px; border-width: 1px; border-style: solid; border-color: silver\"></div><br>";
            }
            _appString = _appString + "</div>";
            return _appString;
        }
        catch (KenaiException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        catch (ParserConfigurationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    @Override
    public void resetContent(final KenaiProject instProj) {
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { background-color: white; font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; padding: 10px;}";
        StyleSheet styleSheet = ((HTMLDocument)this.srcFeedPane.getDocument()).getStyleSheet();
        styleSheet.addRule(bodyRule);
        styleSheet.addRule("div.section {margin-bottom: 10px;}");
        styleSheet.addRule("div.item {margin-bottom: 5px;}");
        styleSheet.addRule("i {color: gray}");
        styleSheet.addRule("h2 {color: rgb(0,22,103)}; font-size: 18pt");
        styleSheet.addRule("h3 {font-size: 15pt");
        styleSheet.addRule("h4 {font-size: 12pt");
        styleSheet.addRule("h3 a {border: 0; font-weight: normal; text-decoration: none; font-size: smaller}");
        styleSheet.addRule("h3 a img {color: white; border: 0}");
        final String str = this.loadRepoFeeds(instProj);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (str != null) {
                    SourcesInformationPanel.this.srcFeedPane.setText(String.format("<html><h2>%s</h2>%s</html>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_PROJECT_SOURCES"), str));
                    SourcesInformationPanel.this.srcFeedPane.validate();
                    SourcesInformationPanel.this.srcFeedPane.setCaretPosition(0);
                    for (final String id : SourcesInformationPanel.this.registeredButtonID) {
                        SourcesInformationPanel.this.registerHTMLButton((HTMLDocument)SourcesInformationPanel.this.srcFeedPane.getDocument(), id, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                new GetSourcesFromKenaiAction(new SourceAccessorImpl.ProjectAndFeature(instProj, (KenaiFeature)SourcesInformationPanel.this.repoMap.get(id), null), null).actionPerformed(e);
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public void clearContent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SourcesInformationPanel.this.srcFeedPane.setText(SourcesInformationPanel.this.WAIT_STRING);
            }
        });
    }
}

