/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.project;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.DefaultButtonModel;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.ui.project.RefreshableContentPanel;
import org.netbeans.modules.kenai.ui.project.SourcesInformationPanel;
import org.netbeans.modules.kenai.ui.project.kenaiProjectTopComponent;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ForumsAndMailingListsPanel
extends JPanel
implements RefreshableContentPanel {
    public static final String CHAT_BUTTON = "CHAT_BUTTON";
    private final String WAIT_STRING = String.format("<html><table cellpadding=\"0\" border=\"0\" cellspacing=\"0\"><tr><td width=\"30\"><img src=\"%s\"></td><td>%s</td></tr></table></html>", SourcesInformationPanel.class.getResource("/org/netbeans/modules/kenai/ui/resources/wait.gif"), NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_WAIT"));
    private JEditorPane commChannelsDisplayer;

    public ForumsAndMailingListsPanel() {
        this.initComponents();
        this.commChannelsDisplayer.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    ForumsAndMailingListsPanel.this.commChannelsDisplayer.setToolTipText(e.getDescription());
                    ForumsAndMailingListsPanel.this.commChannelsDisplayer.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    ForumsAndMailingListsPanel.this.commChannelsDisplayer.setToolTipText("");
                    ForumsAndMailingListsPanel.this.commChannelsDisplayer.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(e.getURL());
                    return;
                }
            }
        });
    }

    public String getChatRoomHTML(KenaiProject instProj) {
        String innerStr = "";
        try {
            if (instProj.isMyProject()) {
                KenaiFeature[] chats = instProj.getFeatures(KenaiService.Type.CHAT);
                innerStr = innerStr + String.format("<div class=\"section\"><h2>%s</h2>", NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_CHATROOM"));
                innerStr = chats.length > 0 ? innerStr + String.format("<input type=\"reset\" id=\"CHAT_BUTTON\" value=\"%s\"><br>", NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_ENTER_CHATROOM")) : innerStr + String.format("<i>%s</i><br>", NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_NO_CHAT"));
            }
        }
        catch (KenaiException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        innerStr = innerStr + "</div>";
        return innerStr;
    }

    public String getForumsHTML(KenaiProject instProj) {
        KenaiFeature[] forums = null;
        String innerStr = "";
        try {
            forums = instProj.getFeatures(KenaiService.Type.FORUM);
        }
        catch (KenaiException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (forums.length > 0) {
            innerStr = String.format("<div class=\"section\"><h2>%s</h2>", NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_FORUMS"));
            for (int i = 0; i < forums.length; ++i) {
                KenaiFeature forum = forums[i];
                innerStr = innerStr + String.format("<div class=\"item\">%s&nbsp;<a href=\"%s\">%s</a> - <i>%s</i></div>", kenaiProjectTopComponent.linkImageHTML, forum.getWebLocation(), forum.getDisplayName(), forum.getWebLocation());
            }
            innerStr = innerStr + "</div>";
        }
        return innerStr;
    }

    public String getMailingListsHTML(KenaiProject instProj) {
        KenaiFeature[] mails = null;
        String innerStr = "";
        try {
            mails = instProj.getFeatures(KenaiService.Type.LISTS);
        }
        catch (KenaiException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (mails.length > 0) {
            innerStr = innerStr + String.format("<div class=\"section\"><h2>%s</h2>", NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_MAILING_LISTS"));
            for (int i = 0; i < mails.length; ++i) {
                KenaiFeature mail = mails[i];
                innerStr = innerStr + String.format("<div class=\"item\">%s&nbsp;<a href=\"%s\">%s</a> - <i>%s</i></div>", kenaiProjectTopComponent.linkImageHTML, mail.getWebLocation(), mail.getDisplayName(), mail.getWebLocation());
            }
            innerStr = innerStr + "</div>";
        }
        return innerStr;
    }

    public void loadActiveTopics(KenaiProject proj) throws DOMException {
        try {
            DocumentBuilder dbf = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            String base = proj.getKenai().getUrl().toString().replaceFirst("https://", "http://");
            String urlStr = base + "/projects/" + proj.getName() + "/forums?format=atom";
            int entriesCount = 0;
            NodeList entries = null;
            if (Thread.interrupted()) {
                this.clearContent();
                return;
            }
            try {
                Document doc = dbf.parse(urlStr);
                if (Thread.interrupted()) {
                    this.clearContent();
                    return;
                }
                entries = doc.getElementsByTagName("entry");
                entriesCount = entries.getLength();
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            catch (SAXParseException e) {
                final String appString = "<div class=\"section\"><i>" + NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_PARSE_ERR") + "</i></div>";
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Element insertionPoint = ((HTMLDocument)ForumsAndMailingListsPanel.this.commChannelsDisplayer.getDocument()).getElement("DYN_CONTENT");
                            if (insertionPoint != null) {
                                ((HTMLDocument)ForumsAndMailingListsPanel.this.commChannelsDisplayer.getDocument()).insertAfterStart(insertionPoint, appString);
                            }
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
                return;
            }
            String _appString = "<div class=\"section\">";
            if (entriesCount > 0 && entries != null) {
                for (int i = 0; i < entriesCount; ++i) {
                    if (Thread.interrupted()) {
                        this.clearContent();
                        return;
                    }
                    Node entry = entries.item(i);
                    NodeList entryProps = entry.getChildNodes();
                    String title = null;
                    String content = null;
                    String href = null;
                    for (int j = 0; j < entryProps.getLength(); ++j) {
                        if (Thread.interrupted()) {
                            this.clearContent();
                            return;
                        }
                        Node elem = entryProps.item(j);
                        if (elem.getNodeName().equals("title")) {
                            title = elem.getFirstChild().getNodeValue();
                            continue;
                        }
                        if (elem.getNodeName().equals("link")) {
                            href = elem.getAttributes().getNamedItem("href").getNodeValue();
                            if (href.startsWith(base)) continue;
                            href = base + href;
                            continue;
                        }
                        if (!elem.getNodeName().equals("content")) continue;
                        content = elem.getFirstChild().getNodeValue();
                    }
                    if (title != null && href != null) {
                        _appString = _appString + String.format("%s&nbsp;<a href=\"%s\">%s</a><br>", kenaiProjectTopComponent.linkImageHTML, href, title);
                    }
                    if (content == null) continue;
                    _appString = _appString + String.format("<i>%s</i><br><br>", content);
                }
                _appString = _appString + "</div>";
                if (Thread.interrupted()) {
                    this.clearContent();
                    return;
                }
                final String appString = _appString;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Element insertionPoint = ((HTMLDocument)ForumsAndMailingListsPanel.this.commChannelsDisplayer.getDocument()).getElement("DYN_CONTENT");
                            if (insertionPoint != null) {
                                ((HTMLDocument)ForumsAndMailingListsPanel.this.commChannelsDisplayer.getDocument()).insertAfterStart(insertionPoint, appString);
                            }
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            } else {
                final String appString = _appString + "<i>" + NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_NO_ACTIVE_TOPICS") + "</i></div>";
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Element insertionPoint = ((HTMLDocument)ForumsAndMailingListsPanel.this.commChannelsDisplayer.getDocument()).getElement("DYN_CONTENT");
                            if (insertionPoint != null) {
                                ((HTMLDocument)ForumsAndMailingListsPanel.this.commChannelsDisplayer.getDocument()).insertAfterStart(insertionPoint, appString);
                            }
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void resetContent(final KenaiProject instProj) {
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { background-color: white; font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; padding: 10px;}";
        StyleSheet styleSheet = ((HTMLDocument)this.commChannelsDisplayer.getDocument()).getStyleSheet();
        styleSheet.addRule(bodyRule);
        styleSheet.addRule("div.section {margin-bottom: 10px;}");
        styleSheet.addRule("div.item {margin-bottom: 5px;}");
        styleSheet.addRule("i {color: gray}");
        styleSheet.addRule("h2 {color: rgb(0,22,103)}");
        String innerStr = "<html>";
        innerStr = innerStr + this.getMailingListsHTML(instProj);
        if (Thread.interrupted()) {
            this.clearContent();
            return;
        }
        innerStr = innerStr + this.getChatRoomHTML(instProj);
        if (Thread.interrupted()) {
            this.clearContent();
            return;
        }
        innerStr = innerStr + this.getForumsHTML(instProj);
        if (Thread.interrupted()) {
            this.clearContent();
            return;
        }
        innerStr = innerStr + String.format("<h2>%s</h2><div id=\"DYN_CONTENT\"></div>", NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_ACTIVE_FORUMS"));
        if (Thread.interrupted()) {
            this.clearContent();
            return;
        }
        innerStr = innerStr + "</html>";
        if (Thread.interrupted()) {
            this.clearContent();
            return;
        }
        final String _istr = innerStr;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ForumsAndMailingListsPanel.this.commChannelsDisplayer.setText(_istr);
                ForumsAndMailingListsPanel.this.commChannelsDisplayer.validate();
                ForumsAndMailingListsPanel.this.commChannelsDisplayer.setCaretPosition(0);
                HTMLDocument htm = (HTMLDocument)ForumsAndMailingListsPanel.this.commChannelsDisplayer.getDocument();
                Element e = htm.getElement(ForumsAndMailingListsPanel.CHAT_BUTTON);
                if (e != null) {
                    AttributeSet attr = e.getAttributes();
                    Enumeration<?> enu = attr.getAttributeNames();
                    while (enu.hasMoreElements()) {
                        Object name = enu.nextElement();
                        Object value = attr.getAttribute(name);
                        if (!"model".equals(name.toString())) continue;
                        DefaultButtonModel model = (DefaultButtonModel)value;
                        model.setActionCommand(ForumsAndMailingListsPanel.CHAT_BUTTON);
                        model.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ChatTopComponent ct = ChatTopComponent.findInstance();
                                ct.open();
                                ct.requestActive();
                                ct.setActiveGroup(instProj.getName() + "@muc." + instProj.getKenai().getUrl().getHost());
                            }
                        });
                    }
                }
            }
        });
        this.loadActiveTopics(instProj);
    }

    private void initComponents() {
        this.commChannelsDisplayer = new JEditorPane();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new BorderLayout());
        this.commChannelsDisplayer.setBackground(new Color(255, 255, 255));
        this.commChannelsDisplayer.setContentType(NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"ForumsAndMailingListsPanel.commChannelsDisplayer.contentType"));
        this.commChannelsDisplayer.setEditable(false);
        this.commChannelsDisplayer.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ForumsAndMailingListsPanel.this.commChannelsDisplayerFocusGained(evt);
            }
        });
        this.add((Component)this.commChannelsDisplayer, "Center");
    }

    private void commChannelsDisplayerFocusGained(FocusEvent evt) {
        this.commChannelsDisplayer.getCaret().setVisible(false);
    }

    @Override
    public void clearContent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ForumsAndMailingListsPanel.this.commChannelsDisplayer.setText(ForumsAndMailingListsPanel.this.WAIT_STRING);
            }
        });
    }
}

