/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.nodes;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class KenaiInstanceCustomizer
extends JPanel
implements Customizer,
DocumentListener {
    private Object bean;
    private NotificationLineSupport ns;
    private DialogDescriptor dd;
    private JButton addButton;
    private JLabel lblName;
    private JLabel lblUrl;
    private JProgressBar progress;
    private JButton proxy;
    private JTextField txtDisplayName;
    private JTextField txtUrl;
    private static Pattern urlPatten = Pattern.compile("https://([a-zA-Z0-9\\-\\.])+\\.(([a-zA-Z]{2,3})|(info)|(name)|(aero)|(coop)|(museum)|(jobs)|(mobi)|(travel))/?$");

    public KenaiInstanceCustomizer(JButton addButton) {
        this.addButton = addButton;
        this.initComponents();
        this.progress.setVisible(false);
        this.txtDisplayName.getDocument().addDocumentListener(this);
        this.txtUrl.getDocument().addDocumentListener(this);
    }

    @Override
    public void setObject(Object bean) {
        this.bean = bean;
    }

    public String getDisplayName() {
        return this.txtDisplayName.getText();
    }

    public String getUrl() {
        return this.txtUrl.getText();
    }

    private void initComponents() {
        this.lblName = new JLabel();
        this.lblUrl = new JLabel();
        this.txtDisplayName = new JTextField();
        this.txtUrl = new JTextField();
        this.progress = new JProgressBar();
        this.proxy = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.lblName.setLabelFor(this.txtDisplayName);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"KenaiInstanceCustomizer.lblName.text"));
        this.lblUrl.setLabelFor(this.txtUrl);
        Mnemonics.setLocalizedText((JLabel)this.lblUrl, (String)NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"KenaiInstanceCustomizer.lblUrl.text"));
        this.txtUrl.setText(NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"KenaiInstanceCustomizer.txtUrl.text"));
        this.progress.setIndeterminate(true);
        this.progress.setString(NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"KenaiInstanceCustomizer.progress.string"));
        this.progress.setStringPainted(true);
        Mnemonics.setLocalizedText((AbstractButton)this.proxy, (String)NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"KenaiInstanceCustomizer.proxy.text"));
        this.proxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KenaiInstanceCustomizer.this.proxyActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lblName).add((Component)this.lblUrl)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.txtUrl, -1, 326, Short.MAX_VALUE).add((Component)this.txtDisplayName, -1, 326, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.proxy).add(18, 18, 18).add((Component)this.progress, -1, 221, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblName).add((Component)this.txtDisplayName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.txtUrl, -2, -1, -2).add((Component)this.lblUrl)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(4).add((Component)this.proxy).add((Component)this.progress, -2, -1, -2)).add(2, 2, 2)));
        this.txtDisplayName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"KenaiInstanceCustomizer.txtDisplayName.AccessibleContext.accessibleName"));
        this.txtDisplayName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"KenaiInstanceCustomizer.txtDisplayName.AccessibleContext.accessibleDescription"));
        this.txtUrl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"KenaiInstanceCustomizer.txtUrl.AccessibleContext.accessibleName"));
        this.txtUrl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"KenaiInstanceCustomizer.txtUrl.AccessibleContext.accessibleDescription"));
        this.proxy.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"KenaiInstanceCustomizer.proxy.AccessibleContext.accessibleDescription"));
    }

    private void proxyActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void validateInput() {
        this.clearError();
        String name = this.getDisplayName();
        if (name.trim().length() == 0) {
            this.showError(NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"ERR_NoName"));
            return;
        }
        if (name.contains(",")) {
            this.showError(NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"ERR_IllegalCharacter", (Object)"','"));
            return;
        }
        if (name.contains(";")) {
            this.showError(NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"ERR_IllegalCharacter", (Object)"';'"));
            return;
        }
        String e = KenaiInstanceCustomizer.urlValid(this.getUrl());
        if (e != null) {
            this.showError(e);
            return;
        }
    }

    void showError(String text) {
        this.stopProgress();
        this.ns.setInformationMessage(text);
        this.dd.setValid(false);
        this.addButton.setEnabled(false);
    }

    void clearError() {
        this.ns.clearMessages();
        this.dd.setValid(true);
        this.addButton.setEnabled(true);
    }

    void startProgress() {
        this.progress.setVisible(true);
    }

    void stopProgress() {
        this.progress.setVisible(false);
    }

    private static String urlValid(String s) {
        if (!s.startsWith("https://")) {
            return NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"ERR_NotHttps");
        }
        if (!urlPatten.matcher(s).matches()) {
            return NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"ERR_UrlNotValid");
        }
        for (Kenai instance : KenaiManager.getDefault().getKenais()) {
            if (!instance.getUrl().toString().equals(s.endsWith("/") ? s.substring(0, s.length() - 1) : s)) continue;
            return NbBundle.getMessage(KenaiInstanceCustomizer.class, (String)"ERR_UrlUsed", (Object)s);
        }
        try {
            new URL(s);
            return null;
        }
        catch (MalformedURLException ex) {
            return ex.getMessage();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateInput();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateInput();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateInput();
    }

    void setNotificationsSupport(NotificationLineSupport support) {
        this.ns = support;
    }

    void setDialogDescriptor(DialogDescriptor dd) {
        this.dd = dd;
    }
}

