/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.spi.MessagingAccessor;
import org.netbeans.modules.kenai.ui.spi.MessagingHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectAccessor;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.QueryAccessor;
import org.netbeans.modules.kenai.ui.spi.QueryHandle;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;
import org.netbeans.modules.kenai.ui.treelist.LeafNode;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MyProjectNode
extends LeafNode {
    private final ProjectHandle project;
    private final ProjectAccessor accessor;
    private final QueryAccessor qaccessor;
    private final MessagingAccessor maccessor;
    private MessagingHandle mh;
    private Action openAction;
    private JPanel component = null;
    private JLabel lbl = null;
    private LinkButton btnOpen = null;
    private LinkButton btnMessages = null;
    private LinkButton btnBugs = null;
    private boolean isMemberProject = false;
    private final Object LOCK = new Object();
    private final PropertyChangeListener projectListener;
    private TreeLabel rightPar;
    private TreeLabel leftPar;
    private RequestProcessor issuesRP = new RequestProcessor(MyProjectNode.class);

    public MyProjectNode(final ProjectHandle project) {
        super(null);
        if (project == null) {
            throw new IllegalArgumentException("project cannot be null");
        }
        this.projectListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("content".equals(evt.getPropertyName())) {
                    MyProjectNode.this.refreshChildren();
                    if (null != MyProjectNode.this.lbl) {
                        MyProjectNode.this.lbl.setText(project.getDisplayName());
                    }
                } else if ("messageCount".equals(evt.getPropertyName())) {
                    if (MyProjectNode.this.btnMessages != null) {
                        MyProjectNode.this.setOnline(MyProjectNode.this.mh.getMessageCount() > 0);
                        MyProjectNode.this.btnMessages.setText(MyProjectNode.this.mh.getMessageCount() + "");
                    }
                } else if ("xmpp_login".equals(evt.getPropertyName())) {
                    if (evt.getOldValue() == null) {
                        MyProjectNode.this.setOnline(MyProjectNode.this.mh.getMessageCount() > 0);
                    } else if (evt.getNewValue() == null) {
                        MyProjectNode.this.setOnline(false);
                        MyProjectNode.this.mh.removePropertyChangeListener(MyProjectNode.this.projectListener);
                        MyProjectNode.this.mh = MyProjectNode.this.maccessor.getMessaging(project);
                        MyProjectNode.this.mh.addPropertyChangeListener(MyProjectNode.this.projectListener);
                    }
                } else if ("queryResult".equals(evt.getPropertyName())) {
                    List queryResults = (List)evt.getNewValue();
                    for (QueryResultHandle queryResult : queryResults) {
                        if (queryResult.getResultType() != QueryResultHandle.ResultType.ALL_CHANGES_RESULT) continue;
                        DashboardImpl.getInstance().myProjectsProgressStarted();
                        MyProjectNode.this.setBugsLater(queryResult);
                        return;
                    }
                }
            }
        };
        this.project = project;
        this.project.addPropertyChangeListener(this.projectListener);
        this.accessor = ProjectAccessor.getDefault();
        this.maccessor = MessagingAccessor.getDefault();
        this.qaccessor = QueryAccessor.getDefault();
        this.mh = this.maccessor.getMessaging(project);
        this.mh.addPropertyChangeListener(this.projectListener);
        project.getKenaiProject().getKenai().addPropertyChangeListener(this.projectListener);
    }

    ProjectHandle getProject() {
        return this.project;
    }

    ProjectAccessor getAccessor() {
        return this.accessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JComponent getComponent(Color foreground, Color background, boolean isSelected, boolean hasFocus) {
        Object object = this.LOCK;
        synchronized (object) {
            if (null == this.component) {
                this.component = new JPanel(new GridBagLayout());
                this.component.setOpaque(false);
                this.lbl = new TreeLabel(this.project.getDisplayName());
                this.component.add((Component)this.lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 0, 3), 0, 0));
                int count = this.mh.getMessageCount();
                this.leftPar = new TreeLabel("(");
                this.rightPar = new TreeLabel(")");
                this.component.add((Component)this.leftPar, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.btnMessages = new LinkButton(count + "", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/collab/resources/newmessage.png", (boolean)true), this.maccessor.getOpenMessagesAction(this.project));
                this.btnMessages.setHorizontalTextPosition(2);
                this.component.add((Component)this.btnMessages, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.component.add((Component)this.rightPar, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.setOnline(this.mh.getOnlineCount() >= 0 && count > 0);
                this.issuesRP.post(new Runnable(){

                    @Override
                    public void run() {
                        DashboardImpl.getInstance().myProjectsProgressStarted();
                        QueryHandle handle = MyProjectNode.this.qaccessor.getAllIssuesQuery(MyProjectNode.this.project);
                        if (handle != null) {
                            handle.addPropertyChangeListener(MyProjectNode.this.projectListener);
                            List<QueryResultHandle> queryResults = MyProjectNode.this.qaccessor.getQueryResults(handle);
                            for (QueryResultHandle queryResult : queryResults) {
                                if (queryResult.getResultType() != QueryResultHandle.ResultType.ALL_CHANGES_RESULT) continue;
                                MyProjectNode.this.setBugsLater(queryResult);
                                return;
                            }
                        }
                        DashboardImpl.getInstance().myProjectsProgressFinished();
                    }
                });
                this.component.add((Component)new JLabel(), new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.btnOpen = new LinkButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/ui/resources/open.png", (boolean)true), this.getOpenAction());
                this.btnOpen.setText(null);
                this.btnOpen.setToolTipText(NbBundle.getMessage(MyProjectNode.class, (String)"LBL_Open"));
                this.btnOpen.setRolloverEnabled(true);
                this.btnOpen.setRolloverIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/ui/resources/open_over.png", (boolean)true));
                this.component.add((Component)this.btnOpen, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0));
            }
            this.lbl.setForeground(foreground);
            return this.component;
        }
    }

    @Override
    public Action getDefaultAction() {
        return this.accessor.getDefaultAction(this.project, false);
    }

    private void setOnline(final boolean b) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (MyProjectNode.this.btnBugs == null || "0".equals(MyProjectNode.this.btnBugs.getText())) {
                    if (MyProjectNode.this.leftPar != null) {
                        MyProjectNode.this.leftPar.setVisible(b);
                    }
                    if (MyProjectNode.this.rightPar != null) {
                        MyProjectNode.this.rightPar.setVisible(b);
                    }
                }
                if (MyProjectNode.this.btnMessages != null) {
                    MyProjectNode.this.btnMessages.setVisible(b);
                }
                DashboardImpl.getInstance().dashboardComponent.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    private Action getOpenAction() {
        if (this.openAction == null) {
            this.openAction = this.getDefaultAction();
        }
        return this.openAction;
    }

    @Override
    public Action[] getPopupActions() {
        return this.accessor.getPopupActions(this.project, false);
    }

    void setMemberProject(boolean isMemberProject) {
        if (isMemberProject == this.isMemberProject) {
            return;
        }
        this.isMemberProject = isMemberProject;
        this.fireContentChanged();
        this.refreshChildren();
    }

    @Override
    protected void dispose() {
        super.dispose();
        if (null != this.project) {
            this.project.removePropertyChangeListener(this.projectListener);
        }
        if (null != this.mh) {
            this.mh.removePropertyChangeListener(this.projectListener);
        }
        this.project.getKenaiProject().getKenai().removePropertyChangeListener(this.projectListener);
    }

    private void setBugsLater(final QueryResultHandle bug) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MyProjectNode.this.btnBugs != null) {
                    MyProjectNode.this.component.remove(MyProjectNode.this.btnBugs);
                }
                boolean hasMsgs = MyProjectNode.this.btnMessages != null && MyProjectNode.this.btnMessages.isVisible();
                MyProjectNode.this.btnBugs = new LinkButton(bug.getText(), ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/ui/resources/bug.png", (boolean)true), MyProjectNode.this.qaccessor.getOpenQueryResultAction(bug));
                MyProjectNode.this.btnBugs.setHorizontalTextPosition(2);
                MyProjectNode.this.btnBugs.setToolTipText(bug.getToolTipText());
                MyProjectNode.this.component.add((Component)MyProjectNode.this.btnBugs, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
                boolean visible = hasMsgs || !"0".equals(bug.getText());
                MyProjectNode.this.leftPar.setVisible(visible);
                MyProjectNode.this.rightPar.setVisible(visible);
                MyProjectNode.this.btnBugs.setVisible(!"0".equals(bug.getText()));
                MyProjectNode.this.component.validate();
                DashboardImpl instance = DashboardImpl.getInstance();
                instance.myProjectsProgressFinished();
                instance.dashboardComponent.repaint();
            }
        });
    }
}

