/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.NewKenaiProjectWizardIterator;
import org.netbeans.modules.kenai.ui.SourceAndIssuesWizardPanel;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SourceAndIssuesWizardPanelGUI
extends JPanel {
    private WizardDescriptor settings;
    private SourceAndIssuesWizardPanel panel;
    private List<KenaiService> repositoriesList = null;
    private List<KenaiService> issuesList = null;
    static final String REPO_NAME_PREVIEW_MSG = "{0}/{1}/{2}~{3}";
    private static final String HG_REPO_NAME = "hg";
    static final String SVN_REPO_NAME = "svn";
    private static final String DEFAULT_REPO_FOLDER = "{0}~{1}";
    private static final String EXT_REPO_ITEM = NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.External");
    private static final String NO_REPO_ITEM = NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.None");
    private static final String EXT_ISSUES_ITEM = NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.External");
    private static final String NO_ISSUES_ITEM = NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.None");
    static final String SVN_DEFAULT_NAME = "subversion";
    private static final String HG_DEFAULT_NAME = "mercurial";
    private static final int PANEL_HEIGHT = 110;
    private boolean localFolderPathEdited = false;
    private String criticalMessage = null;
    private final SharedItemsListModel itemsToShareModel;
    private final List<NewKenaiProjectWizardIterator.SharedItem> itemsToShare = new ArrayList<NewKenaiProjectWizardIterator.SharedItem>(1);
    private JButton addFolderButton;
    private JButton addProjectButton;
    private JCheckBox autoCommit;
    private JSeparator chatSeparator;
    private JCheckBox createChatRoom;
    private JLabel foldersToShareLabel;
    private JList foldersToShareList;
    private JLabel issueTrackingLabel;
    private JLabel issueTrackingUrlLabel;
    private JComboBox issuesComboBox;
    private JPanel issuesSpacerPanel;
    private JTextField issuesUrlTextField;
    private JSeparator itSeparator;
    private JScrollPane jScrollPane1;
    private JButton localFolderBrowseButton;
    private JTextField localFolderTextField;
    private JLabel localRepoFolderLabel;
    private JLabel noIssueTrackingDescLabel;
    private JLabel noneRepoDescLabel;
    private JButton removeButton;
    private JComboBox repoComboBox;
    private JLabel repoNameLabel;
    private JLabel repoNamePreviewLabel;
    private JTextField repoNameTextField;
    private JPanel repoSpacerPanel;
    private JLabel repoUrlLabel;
    private JTextField repoUrlTextField;
    private JSeparator scSeparator;
    private JLabel sourceCodeLabel;
    private JPanel spacerPanel;

    private final String getSvnRepoItem() {
        return NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.SubversionOnKenai", (Object)this.panel.getKenai().getName());
    }

    private final String getHgRepoItem() {
        return NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.MercurialOnKenai", (Object)this.panel.getKenai().getName());
    }

    private final String getBgzIssuesItem() {
        return NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.BugzillaOnKenai", (Object)this.panel.getKenai().getName());
    }

    private final String getJiraIssuesItem() {
        return NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.JIRAOnKenai", (Object)this.panel.getKenai().getName());
    }

    public SourceAndIssuesWizardPanelGUI(SourceAndIssuesWizardPanel pnl) {
        this.panel = pnl;
        this.initComponents();
        this.spacerPanel.setPreferredSize(this.localFolderBrowseButton.getPreferredSize());
        DocumentListener firingDocListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SourceAndIssuesWizardPanelGUI.this.panel.fireChangeEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SourceAndIssuesWizardPanelGUI.this.panel.fireChangeEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SourceAndIssuesWizardPanelGUI.this.panel.fireChangeEvent();
            }
        };
        DocumentListener updatingDocListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SourceAndIssuesWizardPanelGUI.this.updateRepoNamePreview();
                SourceAndIssuesWizardPanelGUI.this.updateRepoPath();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SourceAndIssuesWizardPanelGUI.this.updateRepoNamePreview();
                SourceAndIssuesWizardPanelGUI.this.updateRepoPath();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SourceAndIssuesWizardPanelGUI.this.updateRepoNamePreview();
                SourceAndIssuesWizardPanelGUI.this.updateRepoPath();
            }
        };
        this.repoNameTextField.getDocument().addDocumentListener(updatingDocListener);
        this.repoNameTextField.getDocument().addDocumentListener(firingDocListener);
        this.localFolderTextField.getDocument().addDocumentListener(firingDocListener);
        this.repoUrlTextField.getDocument().addDocumentListener(firingDocListener);
        this.issuesUrlTextField.getDocument().addDocumentListener(firingDocListener);
        List<NewKenaiProjectWizardIterator.SharedItem> initalItems = this.panel.getInitialItems();
        this.setupServicesListModels(initalItems.size() == 0);
        this.showRepoOnKenaiGUI();
        this.showIssuesOnKenaiGUI();
        this.itSeparator.setVisible(false);
        this.createChatRoom.setVisible(false);
        if (this.panel.getKenai() != null && !this.panel.getKenai().getUrl().getHost().equals("testkenai.com")) {
            this.createChatRoom.setSelected(false);
        }
        this.setPreferredSize(new Dimension(Math.max(700, this.getPreferredSize().width), 450));
        this.itemsToShare.addAll(initalItems);
        this.itemsToShareModel = new SharedItemsListModel();
        this.foldersToShareList.setModel(this.itemsToShareModel);
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.panelName");
    }

    private void setupServicesListModels(final boolean isEmptyKenaiProject) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                String serviceName;
                Collection services = null;
                try {
                    if (SourceAndIssuesWizardPanelGUI.this.panel.getKenai() != null) {
                        services = SourceAndIssuesWizardPanelGUI.this.panel.getKenai().getServices();
                    }
                }
                catch (KenaiException ex) {
                    // empty catch block
                }
                ArrayList<KenaiService> repoList = new ArrayList<KenaiService>();
                final DefaultComboBoxModel<Object> repoModel = new DefaultComboBoxModel<Object>();
                ArrayList<KenaiService> issuesList = new ArrayList<KenaiService>();
                final DefaultComboBoxModel<Object> issuesModel = new DefaultComboBoxModel<Object>();
                if (services != null) {
                    for (KenaiService service : services) {
                        if (service.getType() != KenaiService.Type.SOURCE || !isEmptyKenaiProject && !service.getName().equals(SourceAndIssuesWizardPanelGUI.SVN_DEFAULT_NAME) && !service.getName().equals(SourceAndIssuesWizardPanelGUI.HG_DEFAULT_NAME)) continue;
                        repoList.add(service);
                    }
                    for (KenaiService service : services) {
                        if (service.getType() != KenaiService.Type.ISSUES) continue;
                        issuesList.add(service);
                    }
                } else {
                    repoModel.addElement(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.noRepoAvailable"));
                    issuesModel.addElement(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.noIssuesAvailable"));
                }
                if (!repoList.isEmpty()) {
                    for (KenaiService service : repoList) {
                        serviceName = service.getName();
                        if (SourceAndIssuesWizardPanelGUI.SVN_DEFAULT_NAME.equals(serviceName)) {
                            repoModel.addElement(new KenaiServiceItem(service, SourceAndIssuesWizardPanelGUI.this.getSvnRepoItem()));
                            continue;
                        }
                        if (SourceAndIssuesWizardPanelGUI.HG_DEFAULT_NAME.equals(serviceName)) {
                            repoModel.addElement(new KenaiServiceItem(service, SourceAndIssuesWizardPanelGUI.this.getHgRepoItem()));
                            continue;
                        }
                        if (!"external_repository".equals(serviceName)) continue;
                        repoModel.addElement(new KenaiServiceItem(service, EXT_REPO_ITEM));
                    }
                    if (isEmptyKenaiProject) {
                        repoModel.addElement(new KenaiServiceItem(null, NO_REPO_ITEM));
                    }
                    SourceAndIssuesWizardPanelGUI.this.setRepositories(repoList);
                }
                if (!issuesList.isEmpty()) {
                    for (KenaiService service : issuesList) {
                        serviceName = service.getName();
                        if ("bugzilla".equals(serviceName)) {
                            issuesModel.addElement(new KenaiServiceItem(service, SourceAndIssuesWizardPanelGUI.this.getBgzIssuesItem()));
                            continue;
                        }
                        if ("jira".equals(serviceName)) {
                            issuesModel.addElement(new KenaiServiceItem(service, SourceAndIssuesWizardPanelGUI.this.getJiraIssuesItem()));
                            continue;
                        }
                        if (!"external_issues".equals(serviceName)) continue;
                        issuesModel.addElement(new KenaiServiceItem(service, EXT_ISSUES_ITEM));
                    }
                    issuesModel.addElement(new KenaiServiceItem(null, NO_ISSUES_ITEM));
                    SourceAndIssuesWizardPanelGUI.this.setIssues(issuesList);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SourceAndIssuesWizardPanelGUI.this.repoComboBox.setModel(repoModel);
                        SourceAndIssuesWizardPanelGUI.this.repoComboBox.setEnabled(true);
                        SourceAndIssuesWizardPanelGUI.this.issuesComboBox.setModel(issuesModel);
                        SourceAndIssuesWizardPanelGUI.this.issuesComboBox.setEnabled(true);
                    }
                });
            }
        });
    }

    private synchronized void setRepositories(List<KenaiService> list) {
        this.repositoriesList = list;
    }

    private synchronized List<KenaiService> getRepositories() {
        return this.repositoriesList;
    }

    private synchronized void setIssues(List<KenaiService> list) {
        this.issuesList = list;
    }

    private synchronized List<KenaiService> getIssues() {
        return this.issuesList;
    }

    private void updateRepoNamePreview() {
        String repoTypeName;
        String prjName = (String)this.settings.getProperty("projectName");
        if (SVN_DEFAULT_NAME.equals(this.getRepoType())) {
            repoTypeName = SVN_REPO_NAME;
        } else if (HG_DEFAULT_NAME.equals(this.getRepoType())) {
            repoTypeName = HG_REPO_NAME;
        } else {
            return;
        }
        String message = MessageFormat.format(REPO_NAME_PREVIEW_MSG, this.panel.getKenai().getUrl().toString(), repoTypeName, prjName, this.repoNameTextField.getText());
        this.repoNamePreviewLabel.setText(message);
    }

    private void updateRepoPath() {
        if (!this.localFolderPathEdited) {
            File parent = NewKenaiProjectWizardIterator.getCommonParent(this.itemsToShare);
            if (parent != null) {
                this.setRepoLocal(parent.getAbsolutePath());
            } else {
                String prjName = (String)this.settings.getProperty("projectName");
                this.setRepoLocal(Utilities.getDefaultRepoFolder().getPath() + File.separator + MessageFormat.format(DEFAULT_REPO_FOLDER, prjName, this.getRepoName()));
            }
        }
    }

    private void setDefaultRepoName() {
        if (SVN_DEFAULT_NAME.equals(this.getRepoType()) && (HG_DEFAULT_NAME.equals(this.getRepoName()) || "".equals(this.getRepoName()))) {
            this.setRepoName(SVN_DEFAULT_NAME);
        } else if (HG_DEFAULT_NAME.equals(this.getRepoType()) && (SVN_DEFAULT_NAME.equals(this.getRepoName()) || "".equals(this.getRepoName()))) {
            this.setRepoName(HG_DEFAULT_NAME);
        }
    }

    private void initComponents() {
        this.sourceCodeLabel = new JLabel();
        this.repoComboBox = new JComboBox();
        this.issueTrackingLabel = new JLabel();
        this.issuesComboBox = new JComboBox();
        this.scSeparator = new JSeparator();
        this.itSeparator = new JSeparator();
        this.repoNameLabel = new JLabel();
        this.repoNameTextField = new JTextField();
        this.localRepoFolderLabel = new JLabel();
        this.repoNamePreviewLabel = new JLabel();
        this.localFolderTextField = new JTextField();
        this.chatSeparator = new JSeparator();
        this.createChatRoom = new JCheckBox();
        this.localFolderBrowseButton = new JButton();
        this.spacerPanel = new JPanel();
        this.repoUrlLabel = new JLabel();
        this.repoUrlTextField = new JTextField();
        this.noneRepoDescLabel = new JLabel();
        this.issueTrackingUrlLabel = new JLabel();
        this.issuesUrlTextField = new JTextField();
        this.noIssueTrackingDescLabel = new JLabel();
        this.issuesSpacerPanel = new JPanel();
        this.repoSpacerPanel = new JPanel();
        this.foldersToShareLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.foldersToShareList = new JList();
        this.addProjectButton = new JButton();
        this.addFolderButton = new JButton();
        this.removeButton = new JButton();
        this.autoCommit = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.sourceCodeLabel.setLabelFor(this.repoComboBox);
        Mnemonics.setLocalizedText((JLabel)this.sourceCodeLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.sourceCodeLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.sourceCodeLabel, gridBagConstraints);
        this.sourceCodeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.sourceCodeLabel.AccessibleContext.accessibleDescription"));
        this.repoComboBox.setEnabled(false);
        this.repoComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceAndIssuesWizardPanelGUI.this.repoComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.add((Component)this.repoComboBox, gridBagConstraints);
        this.repoComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoComboBox.AccessibleContext.accessibleName"));
        this.repoComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoComboBox.AccessibleContext.accessibleDescription"));
        this.issueTrackingLabel.setLabelFor(this.issuesComboBox);
        Mnemonics.setLocalizedText((JLabel)this.issueTrackingLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issueTrackingLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this.issueTrackingLabel, gridBagConstraints);
        this.issueTrackingLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issueTrackingLabel.AccessibleContext.accessibleDescription"));
        this.issuesComboBox.setEnabled(false);
        this.issuesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceAndIssuesWizardPanelGUI.this.issuesComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.add((Component)this.issuesComboBox, gridBagConstraints);
        this.issuesComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issuesComboBox.AccessibleContext.accessibleName"));
        this.issuesComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issuesComboBox.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this.scSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this.itSeparator, gridBagConstraints);
        this.repoNameLabel.setLabelFor(this.repoNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.repoNameLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.repoNameLabel, gridBagConstraints);
        this.repoNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNameLabel.AccessibleContext.accessibleDescription"));
        this.repoNameTextField.setText(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNameTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 0, 0);
        this.add((Component)this.repoNameTextField, gridBagConstraints);
        this.repoNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNameTextField.AccessibleContext.accessibleName"));
        this.repoNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNameTextField.AccessibleContext.accessibleDescription"));
        this.localRepoFolderLabel.setLabelFor(this.localFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.localRepoFolderLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.localRepoFolderLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.localRepoFolderLabel, gridBagConstraints);
        this.localRepoFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.localRepoFolderLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.repoNamePreviewLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNamePreviewLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 16, 0);
        this.add((Component)this.repoNamePreviewLabel, gridBagConstraints);
        this.repoNamePreviewLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNamePreviewLabel.AccessibleContext.accessibleName"));
        this.repoNamePreviewLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNamePreviewLabel.AccessibleContext.accessibleDescription"));
        this.localFolderTextField.setText(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.localFolderTextField.text"));
        this.localFolderTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SourceAndIssuesWizardPanelGUI.this.localFolderTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.localFolderTextField, gridBagConstraints);
        this.localFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.localFolderTextField.AccessibleContext.accessibleName"));
        this.localFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.localFolderTextField.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this.chatSeparator, gridBagConstraints);
        this.createChatRoom.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createChatRoom, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.createChatRoom.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.createChatRoom, gridBagConstraints);
        this.createChatRoom.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.createChatRoom.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.localFolderBrowseButton, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.localFolderBrowseButton.text"));
        this.localFolderBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceAndIssuesWizardPanelGUI.this.localFolderBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.localFolderBrowseButton, gridBagConstraints);
        this.localFolderBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.localFolderBrowseButton.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.spacerPanel, gridBagConstraints);
        this.repoUrlLabel.setLabelFor(this.repoUrlTextField);
        Mnemonics.setLocalizedText((JLabel)this.repoUrlLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoUrlLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.repoUrlLabel, gridBagConstraints);
        this.repoUrlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoUrlLabel.AccessibleContext.accessibleDescription"));
        this.repoUrlTextField.setText(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoUrlTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 0, 0);
        this.add((Component)this.repoUrlTextField, gridBagConstraints);
        this.repoUrlTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoUrlTextField.AccessibleContext.accessibleName"));
        this.repoUrlTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoUrlTextField.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.noneRepoDescLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.noneRepoDescLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.noneRepoDescLabel, gridBagConstraints);
        this.noneRepoDescLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.noneRepoDescLabel.AccessibleContext.accessibleDescription"));
        this.issueTrackingUrlLabel.setLabelFor(this.issuesUrlTextField);
        Mnemonics.setLocalizedText((JLabel)this.issueTrackingUrlLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issueTrackingUrlLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.issueTrackingUrlLabel, gridBagConstraints);
        this.issueTrackingUrlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issueTrackingUrlLabel.AccessibleContext.accessibleDescription"));
        this.issuesUrlTextField.setText(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issuesUrlTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 0, 0);
        this.add((Component)this.issuesUrlTextField, gridBagConstraints);
        this.issuesUrlTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issuesUrlTextField.AccessibleContext.accessibleName"));
        this.issuesUrlTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issuesUrlTextField.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.noIssueTrackingDescLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.noIssueTrackingDescLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.noIssueTrackingDescLabel, gridBagConstraints);
        this.noIssueTrackingDescLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.noIssueTrackingDescLabel.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.issuesSpacerPanel, gridBagConstraints);
        this.repoSpacerPanel.setMinimumSize(new Dimension(1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        this.add((Component)this.repoSpacerPanel, gridBagConstraints);
        this.foldersToShareLabel.setLabelFor(this.foldersToShareList);
        Mnemonics.setLocalizedText((JLabel)this.foldersToShareLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.foldersToShareLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.foldersToShareLabel, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.foldersToShareList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addProjectButton, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.addProjectButton.text"));
        this.addProjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceAndIssuesWizardPanelGUI.this.addProjectButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.addProjectButton, gridBagConstraints);
        this.addProjectButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.addProjectButton.AccessibleContext.accessibleName"));
        this.addProjectButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.addProjectButton.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.addFolderButton, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.addFolderButton.text"));
        this.addFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceAndIssuesWizardPanelGUI.this.addFolderButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.addFolderButton, gridBagConstraints);
        this.addFolderButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.addFolderButton.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceAndIssuesWizardPanelGUI.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.removeButton.AccessibleContext.accessibleDescription"));
        this.autoCommit.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.autoCommit, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.autoCommit.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.autoCommit, gridBagConstraints);
        this.autoCommit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.autoCommit.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.AccessibleContext.accessibleDescription"));
    }

    private void repoComboBoxActionPerformed(ActionEvent evt) {
        KenaiServiceItem selObject = (KenaiServiceItem)this.repoComboBox.getSelectedItem();
        if (selObject != null && selObject.getService() != null) {
            if (SVN_DEFAULT_NAME.equals(selObject.getService().getName()) || HG_DEFAULT_NAME.equals(selObject.getService().getName())) {
                this.showRepoOnKenaiGUI();
                this.setDefaultRepoName();
                this.updateRepoNamePreview();
                this.updateRepoPath();
            } else if ("external_repository".equals(selObject.getService().getName())) {
                this.showExtRepoGUI();
            }
        } else {
            this.showNoRepoGUI();
        }
        this.panel.fireChangeEvent();
    }

    private void localFolderBrowseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        File uFile = new File(this.localFolderTextField.getText());
        if (uFile.exists()) {
            chooser.setCurrentDirectory(FileUtil.normalizeFile((File)uFile));
        }
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File selFile = chooser.getSelectedFile();
            this.localFolderTextField.setText(selFile.getAbsolutePath());
            this.localFolderPathEdited = true;
        }
        this.panel.fireChangeEvent();
    }

    private void issuesComboBoxActionPerformed(ActionEvent evt) {
        KenaiServiceItem selObject = (KenaiServiceItem)this.issuesComboBox.getSelectedItem();
        if (selObject != null && selObject.getService() != null) {
            if ("bugzilla".equals(selObject.getService().getName()) || "jira".equals(selObject.getService().getName())) {
                this.showIssuesOnKenaiGUI();
            } else if ("external_issues".equals(selObject.getService().getName())) {
                this.showExtIssuesGUI();
            }
        } else {
            this.showNoIssuesGUI();
        }
        this.panel.fireChangeEvent();
    }

    private void localFolderTextFieldKeyTyped(KeyEvent evt) {
        this.localFolderPathEdited = true;
    }

    private void addProjectButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = ProjectChooser.projectChooser();
        this.choose(chooser);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int[] selection = this.foldersToShareList.getSelectedIndices();
        for (int i = selection.length - 1; i >= 0; --i) {
            this.itemsToShare.remove(selection[i]);
        }
        this.foldersToShareList.clearSelection();
        this.itemsToShareModel.fireContentsChanged();
        this.updateRepoPath();
    }

    private void addFolderButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        this.choose(chooser);
    }

    private void choose(JFileChooser chooser) {
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(true);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File[] selFiles;
            block0: for (File file : selFiles = chooser.getSelectedFiles()) {
                for (NewKenaiProjectWizardIterator.SharedItem item : this.itemsToShare) {
                    if (!item.getRoot().equals(file)) continue;
                    continue block0;
                }
                if (VersioningSupport.getOwner((File)file) != null) continue;
                NewKenaiProjectWizardIterator.SharedItem item = new NewKenaiProjectWizardIterator.SharedItem(file);
                this.itemsToShare.add(item);
            }
            this.itemsToShareModel.fireContentsChanged();
            this.updateRepoPath();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.panel.fireChangeEvent();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.putClientProperty("exceptionErrorMessage", null);
    }

    public boolean valid() {
        String message = this.checkForErrors();
        if (message != null) {
            this.settings.putProperty("WizardPanel_errorMessage", (Object)message);
            return false;
        }
        this.settings.putProperty("WizardPanel_errorMessage", null);
        message = this.checkForWarnings();
        if (message != null) {
            this.settings.putProperty("WizardPanel_warningMessage", (Object)message);
            return false;
        }
        this.settings.putProperty("WizardPanel_warningMessage", null);
        message = this.checkForInfos();
        if (message != null) {
            this.settings.putProperty("WizardPanel_infoMessage", (Object)message);
            return false;
        }
        this.settings.putProperty("WizardPanel_infoMessage", null);
        return true;
    }

    private String checkForErrors() {
        String excErrMsg = (String)this.getClientProperty("exceptionErrorMessage");
        if (excErrMsg != null) {
            return excErrMsg;
        }
        return null;
    }

    private String checkForWarnings() {
        return null;
    }

    private String checkForInfos() {
        String localRepoPath = this.getRepoLocal();
        if ((SVN_DEFAULT_NAME.equals(this.getRepoType()) || HG_DEFAULT_NAME.equals(this.getRepoType())) && ("".equals(localRepoPath) || localRepoPath == null)) {
            return NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.LocalRepoRequired");
        }
        String extRepoUrl = this.getRepoUrl();
        if ("external_repository".equals(this.getRepoType()) && ("".equals(extRepoUrl) || extRepoUrl == null)) {
            return NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.ExternalRepoRequired");
        }
        String extIssuesUrl = this.getIssuesUrl();
        if ("external_issues".equals(this.getIssuesType()) && ("".equals(extIssuesUrl) || extIssuesUrl == null)) {
            return NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.ExternalIssueRepoRequired");
        }
        return null;
    }

    public void validateWizard() throws WizardValidationException {
    }

    public void read(WizardDescriptor settings) {
        this.settings = settings;
        String scmType = (String)this.settings.getProperty("projectSCMType");
        String repoName = (String)this.settings.getProperty("projectSCMName");
        if (repoName == null || "".equals(repoName.trim())) {
            this.setDefaultRepoName();
        } else {
            this.setRepoName(repoName);
        }
        String repoUrl = (String)this.settings.getProperty("projectSCMUrl");
        if (repoUrl == null || "".equals(repoUrl.trim())) {
            this.setRepoUrl("");
        } else {
            this.setRepoUrl(repoUrl);
        }
        String repoLocal = (String)this.settings.getProperty("projectSCMLocal");
        if (repoLocal == null || "".equals(repoLocal.trim())) {
            File parent = NewKenaiProjectWizardIterator.getCommonParent(this.itemsToShare);
            if (parent != null) {
                this.setRepoLocal(parent.getAbsolutePath());
            } else {
                String prjName = (String)this.settings.getProperty("projectName");
                this.setRepoLocal(Utilities.getDefaultRepoFolder().getPath() + File.separator + MessageFormat.format(DEFAULT_REPO_FOLDER, prjName, this.getRepoName()));
            }
        } else {
            this.setRepoLocal(repoLocal);
        }
        String issuesType = (String)this.settings.getProperty("projectIssues");
        String issuesUrl = (String)this.settings.getProperty("projectIssuesUrl");
        if (issuesUrl == null || "".equals(issuesUrl.trim())) {
            this.setIssuesUrl("");
        } else {
            this.setIssuesUrl(issuesUrl);
        }
        Boolean createChat = (Boolean)this.settings.getProperty("projectCreateChat");
        if (createChat != null) {
            this.createChatRoom.setSelected(createChat);
        } else {
            this.createChatRoom.setSelected(true);
        }
        String c = (String)this.settings.getProperty("projectAutoCommit");
        this.setAutoCommit(c == null ? true : Boolean.parseBoolean(c));
    }

    public void store(WizardDescriptor settings) {
        settings.putProperty("projectSCMType", (Object)this.getRepoType());
        settings.putProperty("projectSCMName", (Object)this.getRepoName());
        settings.putProperty("projectSCMUrl", (Object)this.getRepoUrl());
        settings.putProperty("projectSCMLocal", (Object)this.getRepoLocal());
        settings.putProperty("projectSCMPreview", (Object)this.repoNamePreviewLabel.getText());
        settings.putProperty("projectIssues", (Object)this.getIssuesType());
        settings.putProperty("projectIssuesUrl", (Object)this.getIssuesUrl());
        settings.putProperty("projectCreateChat", (Object)this.createChatRoom.isSelected());
        settings.putProperty("projectFoldersToShare", this.itemsToShare);
        settings.putProperty("projectAutoCommit", (Object)Boolean.toString(this.isAutoCommit()));
    }

    private void setAutoCommit(boolean autoCommit) {
        this.autoCommit.setSelected(autoCommit);
    }

    private boolean isAutoCommit() {
        return this.autoCommit.isSelected();
    }

    private void setRepoType(String repo) {
    }

    private String getRepoType() {
        KenaiServiceItem selItem = (KenaiServiceItem)this.repoComboBox.getSelectedItem();
        if (selItem != null && selItem.getService() != null) {
            return selItem.getService().getName();
        }
        return "none";
    }

    private void setRepoName(String name) {
        this.repoNameTextField.setText(name);
    }

    private String getRepoName() {
        return this.repoNameTextField.getText();
    }

    private void setRepoUrl(String url) {
        this.repoUrlTextField.setText(url);
    }

    private String getRepoUrl() {
        return this.repoUrlTextField.getText();
    }

    private void setRepoLocal(String localPath) {
        this.localFolderTextField.setText(localPath);
    }

    private String getRepoLocal() {
        return this.localFolderTextField.getText();
    }

    private void setIssuesType(String issues) {
    }

    private String getIssuesType() {
        KenaiServiceItem selItem = (KenaiServiceItem)this.issuesComboBox.getSelectedItem();
        if (selItem != null && selItem.getService() != null) {
            return selItem.getService().getName();
        }
        return "none";
    }

    private void setIssuesUrl(String issues) {
        this.issuesUrlTextField.setText(issues);
    }

    private String getIssuesUrl() {
        return this.issuesUrlTextField.getText();
    }

    private void showRepoOnKenaiGUI() {
        this._setRepoOnKenaiGUIVisible(true);
        this.hideExtRepoGUI();
        this.hideNoRepoGUI();
        int h1 = this.repoNameTextField.getPreferredSize().height + 8;
        int h2 = this.repoNamePreviewLabel.getPreferredSize().height + 16;
        int h3 = this.localFolderTextField.getPreferredSize().height;
        int spacerHeight = 110 - (h1 + h2 + h3) - 1;
        this.repoSpacerPanel.setPreferredSize(new Dimension(10, spacerHeight));
        this.revalidate();
        this.repaint();
    }

    private void hideRepoOnKenaiGUI() {
        this._setRepoOnKenaiGUIVisible(false);
    }

    private void _setRepoOnKenaiGUIVisible(boolean show) {
        this.repoNameLabel.setVisible(show);
        this.repoNameTextField.setVisible(show);
        this.repoNamePreviewLabel.setVisible(show);
        this.localRepoFolderLabel.setVisible(show);
        this.localFolderTextField.setVisible(show);
        this.localFolderBrowseButton.setVisible(show);
        this.addFolderButton.setVisible(show);
        this.addProjectButton.setVisible(show);
        this.removeButton.setVisible(show);
        this.autoCommit.setVisible(show);
        this.foldersToShareLabel.setVisible(show);
        this.jScrollPane1.setVisible(show);
        this.chatSeparator.setVisible(show);
    }

    private void showExtRepoGUI() {
        this.hideRepoOnKenaiGUI();
        this._setExtRepoGUIVisible(true);
        this.hideNoRepoGUI();
        int h1 = this.repoUrlTextField.getPreferredSize().height + 8;
        int spacerHeight = 110 - h1;
        this.repoSpacerPanel.setPreferredSize(new Dimension(10, spacerHeight));
        this.revalidate();
        this.repaint();
    }

    private void hideExtRepoGUI() {
        this._setExtRepoGUIVisible(false);
    }

    private void _setExtRepoGUIVisible(boolean show) {
        this.repoUrlLabel.setVisible(show);
        this.repoUrlTextField.setVisible(show);
    }

    private void showNoRepoGUI() {
        this.hideRepoOnKenaiGUI();
        this.hideExtRepoGUI();
        this._setNoRepoGUIVisible(true);
        int h1 = this.noneRepoDescLabel.getPreferredSize().height;
        int spacerHeight = 110 - h1;
        this.repoSpacerPanel.setPreferredSize(new Dimension(10, spacerHeight));
        this.revalidate();
        this.repaint();
    }

    private void hideNoRepoGUI() {
        this._setNoRepoGUIVisible(false);
    }

    private void _setNoRepoGUIVisible(boolean show) {
        this.noneRepoDescLabel.setVisible(show);
    }

    private void showIssuesOnKenaiGUI() {
        this.hideExtIssuesGUI();
        this.hideNoIssuesGUI();
        this.issuesSpacerPanel.setPreferredSize(new Dimension(10, 110));
        this.revalidate();
        this.repaint();
    }

    private void hideIssuesOnKenaiGUI() {
    }

    private void _setIssuesOnKenaiGUIVisible(boolean show) {
    }

    private void showExtIssuesGUI() {
        this._setExtIssuesGUIVisible(true);
        this.hideNoIssuesGUI();
        int h1 = this.issuesUrlTextField.getPreferredSize().height + 8;
        int spacerHeight = 110 - h1;
        this.issuesSpacerPanel.setPreferredSize(new Dimension(10, spacerHeight));
        this.revalidate();
        this.repaint();
    }

    private void hideExtIssuesGUI() {
        this._setExtIssuesGUIVisible(false);
    }

    private void _setExtIssuesGUIVisible(boolean show) {
        this.issueTrackingUrlLabel.setVisible(show);
        this.issuesUrlTextField.setVisible(show);
    }

    private void showNoIssuesGUI() {
        this.hideExtIssuesGUI();
        this._setNoIssuesGUIVisible(true);
        int h1 = this.noIssueTrackingDescLabel.getPreferredSize().height;
        int spacerHeight = 110 - h1;
        this.issuesSpacerPanel.setPreferredSize(new Dimension(10, spacerHeight));
        this.revalidate();
        this.repaint();
    }

    private void hideNoIssuesGUI() {
        this._setNoIssuesGUIVisible(false);
    }

    private void _setNoIssuesGUIVisible(boolean show) {
        this.noIssueTrackingDescLabel.setVisible(show);
    }

    private class SharedItemsListModel
    extends AbstractListModel {
        private SharedItemsListModel() {
        }

        @Override
        public Object getElementAt(int arg0) {
            return SourceAndIssuesWizardPanelGUI.this.itemsToShare.get(arg0);
        }

        @Override
        public int getSize() {
            return SourceAndIssuesWizardPanelGUI.this.itemsToShare.size();
        }

        private void fireContentsChanged() {
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }
    }

    private static class KenaiServiceItem {
        private KenaiService kenaiService;
        private String displayName;

        public KenaiServiceItem(KenaiService service, String dName) {
            this.kenaiService = service;
            this.displayName = dName;
        }

        public KenaiService getService() {
            return this.kenaiService;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

