/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.kenai.ui.spi.KenaiIssueAccessor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class InsertLinkAction
extends AbstractAction {
    private String outText;
    private JTextPane out;

    public InsertLinkAction(JTextComponent component, JTextPane out, boolean insertLineNumber, boolean insertAccelerator) {
        Project p;
        assert (component != null);
        Document document = component.getDocument();
        FileObject fo = NbEditorUtilities.getFileObject((Document)document);
        int line = NbDocument.findLineNumber((StyledDocument)((StyledDocument)document), (int)component.getCaretPosition()) + 1;
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (insertLineNumber) {
            this.putValue("Name", fo.getNameExt() + ":" + line);
            if (insertAccelerator) {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, 128));
            }
        } else {
            this.putValue("Name", fo.getNameExt());
        }
        this.outText = cp != null ? cp.getResourceName(fo) : ((p = FileOwnerQuery.getOwner((FileObject)fo)) != null ? "{$" + ProjectUtils.getInformation((Project)p).getName() + "}/" + FileUtil.getRelativePath((FileObject)p.getProjectDirectory(), (FileObject)fo) : fo.getPath());
        if (insertLineNumber) {
            this.outText = this.outText + ":" + line;
        }
        this.out = out;
        this.outText = "FILE:" + this.outText;
    }

    public InsertLinkAction(KenaiIssueAccessor.IssueHandle issueHandle, JTextPane outbox, boolean insertAccelerator) {
        this.putValue("Name", issueHandle.getShortDisplayName());
        if (insertAccelerator) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, 128));
        }
        this.out = outbox;
        this.outText = "ISSUE:" + issueHandle.getID();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.out.getDocument().insertString(this.out.getCaretPosition(), this.outText, null);
            this.out.requestFocus();
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

