/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.netbeans.modules.kenai.collab.chat.ContactListItem;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.openide.awt.HtmlRenderer;
import org.openide.util.ImageUtilities;

public class ContactListCellRenderer
extends JPanel
implements ListCellRenderer {
    private JLabel buddyLabel;
    private JLabel kenaiName;
    private JLabel messageLabel;

    public ContactListCellRenderer() {
        this.initComponents();
        this.setOpaque(true);
        this.buddyLabel.setOpaque(true);
        this.messageLabel.setOpaque(true);
        this.kenaiName.setOpaque(true);
    }

    private void initComponents() {
        this.buddyLabel = HtmlRenderer.createLabel();
        this.messageLabel = new JLabel();
        this.kenaiName = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 5));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.buddyLabel, gridBagConstraints);
        this.messageLabel.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.messageLabel, gridBagConstraints);
        this.kenaiName.setForeground(Color.gray);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.kenaiName, gridBagConstraints);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.buddyLabel.setText(value.toString());
        ContactListItem item = (ContactListItem)value;
        this.buddyLabel.setBorder(new EmptyBorder(0, item.getIcon() == null ? 22 : 3, 0, 0));
        this.buddyLabel.setIcon(item.getIcon());
        if (item.hasMessages()) {
            this.messageLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/collab/resources/newmessage.png", (boolean)true));
            this.messageLabel.setBorder(new EmptyBorder(0, 3, 0, 3));
        } else {
            this.messageLabel.setIcon(null);
            this.messageLabel.setBorder(new EmptyBorder(0, 3, 16, 19));
        }
        if (KenaiManager.getDefault().getKenais().size() > 1) {
            this.kenaiName.setText(item.getKenaiName());
        } else {
            this.kenaiName.setText("");
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
            this.buddyLabel.setBackground(list.getSelectionBackground());
            this.buddyLabel.setForeground(list.getSelectionForeground());
            this.messageLabel.setBackground(list.getSelectionBackground());
            this.messageLabel.setForeground(list.getSelectionForeground());
            this.kenaiName.setBackground(list.getSelectionBackground());
            this.kenaiName.setForeground(list.getSelectionForeground());
        } else {
            Color bg = ColorManager.getDefault().getDefaultBackground();
            this.setBackground(bg);
            this.setForeground(list.getForeground());
            this.buddyLabel.setBackground(bg);
            this.buddyLabel.setForeground(list.getForeground());
            this.messageLabel.setBackground(bg);
            this.messageLabel.setForeground(list.getForeground());
            this.kenaiName.setBackground(bg);
            this.kenaiName.setForeground(Color.gray);
        }
        this.setPreferredSize(new Dimension(10, this.getPreferredSize().height));
        return this;
    }
}

