/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.StringUtils;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.netbeans.modules.kenai.collab.chat.MessagingHandleImpl;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;

public class ChatNotifications {
    public static final String NOTIFICATIONS_PREF = "chat.notifications.";
    private static ImageIcon NEWMSG = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/collab/resources/newmessage.png", (boolean)true);
    private static ChatNotifications instance;
    private HashMap<String, MessagingHandleImpl> groupMessages = new HashMap();
    private HashMap<String, Notification> privateNotifications = new HashMap();
    private HashMap<String, Integer> privateMessagesCounter = new HashMap();
    private Preferences preferences = NbPreferences.forModule(ChatNotifications.class);

    private ChatNotifications() {
    }

    public static synchronized ChatNotifications getDefault() {
        if (instance == null) {
            instance = new ChatNotifications();
        }
        return instance;
    }

    public synchronized void removeGroup(String name) {
        Utilities.assertJid(name);
        MessagingHandleImpl r = this.groupMessages.get(name);
        if (r != null) {
            r.disposeNotification();
            r.notifyMessagesRead();
        }
    }

    public synchronized void removePrivate(String name) {
        Utilities.assertJid(name);
        Notification n = this.privateNotifications.get(name);
        if (n != null) {
            n.clear();
            this.privateNotifications.remove(name);
            this.privateMessagesCounter.remove(name);
        }
    }

    synchronized void addGroupMessage(final Message msg) {
        assert (SwingUtilities.isEventDispatchThread());
        KenaiProject prj = KenaiConnection.getKenaiProject(StringUtils.parseBareAddress((String)msg.getFrom()));
        MessagingHandleImpl r = this.getMessagingHandle(prj);
        r.notifyMessageReceived(msg);
        String title = null;
        int count = r.getMessageCount();
        title = count == 1 ? NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_ChatNotification", (Object[])new Object[]{prj.getDisplayName(), count}) : NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_ChatNotifications", (Object[])new Object[]{prj.getDisplayName(), count});
        String description = NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_ReadIt");
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ChatTopComponent chatTc = ChatTopComponent.findInstance();
                ChatTopComponent.openAction((TopComponent)chatTc, (String)"", (String)"", (boolean)false).actionPerformed(arg0);
                chatTc.setActiveGroup(StringUtils.parseBareAddress((String)msg.getFrom()));
            }
        };
        if (r.getMessageCount() > 0) {
            Notification n = NotificationDisplayer.getDefault().notify(title, this.getIcon(), description, l, NotificationDisplayer.Priority.NORMAL);
            r.updateNotification(n);
        }
        ChatTopComponent.refreshContactList();
    }

    synchronized void addPrivateMessage(Message msg) {
        assert (SwingUtilities.isEventDispatchThread());
        final String name = StringUtils.parseBareAddress((String)msg.getFrom());
        Notification n = this.privateNotifications.get(name);
        if (n != null) {
            n.clear();
            this.privateNotifications.remove(name);
        }
        this.increasePrivateMessagesCount(name);
        int count = this.getPrivateMessagesCount(name);
        String title = count == 1 ? NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_ChatNotification", (Object[])new Object[]{name, count}) : NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_ChatNotifications", (Object[])new Object[]{name, count});
        String description = NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_ReadIt");
        n = NotificationDisplayer.getDefault().notify(title, this.getIcon(), description, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChatTopComponent tc = ChatTopComponent.findInstance();
                tc.open();
                tc.setActivePrivate(name);
            }
        }, NotificationDisplayer.Priority.NORMAL);
        this.privateNotifications.put(name, n);
        ChatTopComponent.refreshContactList();
        DashboardImpl.getInstance().getComponent().repaint();
    }

    public synchronized boolean hasNewPrivateMessages(String name) {
        Utilities.assertJid(name);
        return this.privateNotifications.get(name) != null;
    }

    public synchronized MessagingHandleImpl getMessagingHandle(KenaiProject prj) {
        MessagingHandleImpl handle = this.groupMessages.get(prj.getName() + "@muc." + prj.getKenai().getUrl().getHost());
        if (handle == null) {
            handle = new MessagingHandleImpl(prj);
            this.groupMessages.put(prj.getName() + "@muc." + prj.getKenai().getUrl().getHost(), handle);
        }
        return handle;
    }

    synchronized void clearAll(Kenai kenai) {
        String name = "@muc." + kenai.getUrl().getHost();
        Iterator<Map.Entry<String, MessagingHandleImpl>> iterator = this.groupMessages.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, MessagingHandleImpl> entry = iterator.next();
            if (!entry.getKey().endsWith(name)) continue;
            MessagingHandleImpl h = entry.getValue();
            h.disposeNotification();
            h.setMessageCount(0);
            h.setOnlineCount(-1);
            iterator.remove();
        }
    }

    boolean isEnabled(String name) {
        Utilities.assertJid(name);
        assert (name != null);
        return this.preferences.getBoolean(NOTIFICATIONS_PREF + name, true);
    }

    void setEnabled(String name, boolean b) {
        Utilities.assertJid(name);
        assert (name != null);
        this.preferences.putBoolean(NOTIFICATIONS_PREF + name, b);
    }

    private Icon getIcon() {
        return NEWMSG;
    }

    private void increasePrivateMessagesCount(String name) {
        Utilities.assertJid(name);
        this.privateMessagesCounter.put(name, this.getPrivateMessagesCount(name) + 1);
    }

    private int getPrivateMessagesCount(String name) {
        Utilities.assertJid(name);
        Integer count = this.privateMessagesCounter.get(name);
        if (count == null) {
            return 0;
        }
        return count;
    }
}

