/*
 * Decompiled with CFR 0.152.
 */
package org.iso_relax.verifier.impl;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFilter;
import org.iso_relax.verifier.VerifierHandler;
import org.iso_relax.verifier.impl.SAXEventGenerator;
import org.iso_relax.verifier.impl.VerifierFilterImpl;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class VerifierImpl
implements Verifier {
    protected XMLReader reader;
    protected ErrorHandler errorHandler = new ErrorHandler(){

        public void warning(SAXParseException sAXParseException) {
        }

        public void error(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) {
        }
    };
    protected EntityResolver entityResolver;
    private VerifierFilter filter;

    protected VerifierImpl() throws VerifierConfigurationException {
        this.prepareXMLReader();
    }

    protected void prepareXMLReader() throws VerifierConfigurationException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            this.reader = sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (SAXException sAXException) {
            throw new VerifierConfigurationException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new VerifierConfigurationException(parserConfigurationException);
        }
    }

    public boolean isFeature(String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://www.iso-relax.org/verifier/handler".equals(string2) || "http://www.iso-relax.org/verifier/filter".equals(string2)) {
            return true;
        }
        throw new SAXNotRecognizedException(string2);
    }

    public void setFeature(String string2, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string2);
    }

    public Object getProperty(String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string2);
    }

    public void setProperty(String string2, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string2);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public boolean verify(String string2) throws SAXException, IOException {
        return this.verify(new InputSource(string2));
    }

    public boolean verify(InputSource inputSource) throws SAXException, IOException {
        VerifierHandler verifierHandler = this.getVerifierHandler();
        this.reader.setErrorHandler(this.errorHandler);
        if (this.entityResolver != null) {
            this.reader.setEntityResolver(this.entityResolver);
        }
        this.reader.setContentHandler(verifierHandler);
        this.reader.parse(inputSource);
        return verifierHandler.isValid();
    }

    public boolean verify(File file) throws SAXException, IOException {
        String string2 = "file:" + file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            string2 = string2.replace('\\', '/');
        }
        return this.verify(new InputSource(string2));
    }

    public boolean verify(Node node) throws SAXException {
        SAXEventGenerator sAXEventGenerator = new SAXEventGenerator(node);
        sAXEventGenerator.setDocumentEmulation(true);
        sAXEventGenerator.setErrorHandler(this.errorHandler);
        VerifierHandler verifierHandler = this.getVerifierHandler();
        sAXEventGenerator.makeEvent(verifierHandler);
        return verifierHandler.isValid();
    }

    public abstract VerifierHandler getVerifierHandler() throws SAXException;

    public VerifierFilter getVerifierFilter() throws SAXException {
        if (this.filter == null) {
            this.filter = new VerifierFilterImpl(this);
        }
        return this.filter;
    }
}

