/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.reference;

import com.sun.istack.NotNull;
import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.ws.security.secext10.KeyIdentifierType;
import com.sun.xml.ws.security.secext10.ObjectFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.impl.misc.Base64;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;

public class KeyIdentifier
extends KeyIdentifierType
implements com.sun.xml.ws.security.opt.api.reference.KeyIdentifier,
SecurityHeaderElement,
SecurityElementWriter {
    private SOAPVersion soapVersion = SOAPVersion.SOAP_11;

    public KeyIdentifier(SOAPVersion sv) {
        this.soapVersion = sv;
    }

    public String getValueType() {
        return super.getValueType();
    }

    public void setValueType(String valueType) {
        super.setValueType(valueType);
    }

    public String getEncodingType() {
        return super.getEncodingType();
    }

    public void setEncodingType(String value) {
        super.setEncodingType(value);
    }

    public String getReferenceValue() {
        return super.getValue();
    }

    public void setReferenceValue(String referenceValue) {
        super.setValue(referenceValue);
    }

    public String getType() {
        return "Identifier";
    }

    public String getId() {
        QName qname = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", "wsu");
        Map<QName, String> otherAttributes = this.getOtherAttributes();
        return otherAttributes.get(qname);
    }

    public void setId(String id) {
        QName qname = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", "wsu");
        Map<QName, String> otherAttributes = this.getOtherAttributes();
        otherAttributes.put(qname, id);
    }

    public String getNamespaceURI() {
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    }

    public String getLocalPart() {
        return "KeyIdentifier".intern();
    }

    public String getAttribute(@NotNull String nsUri, @NotNull String localName) {
        QName qname = new QName(nsUri, localName);
        Map<QName, String> otherAttributes = this.getOtherAttributes();
        return otherAttributes.get(qname);
    }

    public String getAttribute(@NotNull QName name) {
        Map<QName, String> otherAttributes = this.getOtherAttributes();
        return otherAttributes.get(name);
    }

    public XMLStreamReader readHeader() throws XMLStreamException {
        XMLStreamBufferResult xbr = new XMLStreamBufferResult();
        JAXBElement<KeyIdentifierType> keyIdentifierElem = new ObjectFactory().createKeyIdentifier(this);
        try {
            this.getMarshaller().marshal(keyIdentifierElem, (Result)xbr);
        }
        catch (JAXBException je) {
            throw new XMLStreamException(je);
        }
        return xbr.getXMLStreamBuffer().readAsXMLStreamReader();
    }

    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        JAXBElement<KeyIdentifierType> keyIdentifierElem = new ObjectFactory().createKeyIdentifier(this);
        try {
            OutputStream os;
            if (streamWriter instanceof Map && (os = (OutputStream)((Map)((Object)streamWriter)).get("sjsxp-outputstream")) != null) {
                streamWriter.writeCharacters("");
                this.getMarshaller().marshal(keyIdentifierElem, os);
                return;
            }
            this.getMarshaller().marshal(keyIdentifierElem, streamWriter);
        }
        catch (JAXBException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        try {
            Marshaller marshaller = this.getMarshaller();
            for (Map.Entry entry : props.entrySet()) {
                marshaller.setProperty((String)entry.getKey(), entry.getValue());
            }
            this.writeTo(streamWriter);
        }
        catch (JAXBException jbe) {
            throw new XMLStreamException(jbe);
        }
    }

    private Marshaller getMarshaller() throws JAXBException {
        return JAXBUtil.createMarshaller(this.soapVersion);
    }

    public void writeTo(OutputStream os) {
    }

    public void updateReferenceValue(byte[] kerberosToken) throws XWSSecurityException {
        if (this.getValueType() == "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1") {
            try {
                this.setReferenceValue(Base64.encode(MessageDigest.getInstance("SHA-1").digest(kerberosToken)));
            }
            catch (NoSuchAlgorithmException ex) {
                throw new XWSSecurityException("Digest algorithm SHA-1 not found");
            }
        } else {
            throw new XWSSecurityException(this.getValueType() + " ValueType not supported for kerberos tokens");
        }
    }

    public void updateReferenceValue(X509Certificate cert) throws XWSSecurityException {
        if (this.getValueType() == "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1") {
            try {
                this.setReferenceValue(Base64.encode(MessageDigest.getInstance("SHA-1").digest(cert.getEncoded())));
            }
            catch (NoSuchAlgorithmException ex) {
                throw new XWSSecurityException("Digest algorithm SHA-1 not found");
            }
            catch (CertificateEncodingException ex) {
                throw new XWSSecurityException("Error while getting certificate's raw content");
            }
        } else if (this.getValueType() == "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier") {
            byte[] keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(cert);
            if (keyId == null) {
                return;
            }
            this.setReferenceValue(Base64.encode(keyId));
        }
    }

    public boolean refersToSecHdrWithId(String id) {
        String valueType = this.getValueType();
        return ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(valueType)) && this.getValue().equals(id);
    }
}

